-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 固件信息集成测试用例
local skynet = require 'skynet'
local log = require 'mc.logging'
local mdb_service = require 'mc.mdb.mdb_service'
local mdb = require 'mc.mdb'
require 'stub_service.FirmwareInfo'

local FWINVENTORY_PATH = '/bmc/kepler/UpdateService/FirmwareInventory'
local FWINFO_INTERFACE = 'bmc.kepler.UpdateService.FirmwareInfo'

local fw_info_cases = {}

function fw_info_cases.test_fw_info_register(bus)
    local result = mdb_service.get_sub_paths(bus, FWINVENTORY_PATH, 1, {})
    local times = 5
    while #result.SubPaths == 1 and times > 0 do
        mdb_service.get_sub_paths(bus, FWINVENTORY_PATH, 1, {})
        skynet.sleep(100)
        times = times - 1
    end

    local bios_obj =
        mdb.get_cached_object(bus, '/bmc/kepler/UpdateService/FirmwareInventory/Bios', FWINFO_INTERFACE)
    log:info('bios version is: ' .. bios_obj.Version)
    assert(bios_obj.Location == 'U75')
    log:info('==========test_fw_info_register ok========')
end

return fw_info_cases
