-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local PowerControlInterface = require 'stub_service.PowerControlInterface'
 
local childs = {}
local PowerControl = {childs = childs}
 
local Mdb = require 'mc.mdb'
 
local TComputerSystemPowerControl = Mdb.register_object(
    '/bmc/kepler/Systems/:ComputerSystemId/FruCtrl/:FruId', {
        {name = 'Policy', interface = PowerControlInterface.IPowerControlPolicy},
        {name = 'Control', interface = PowerControlInterface.IComputerSystemPowerControl},
        {name = 'Locks', interface = PowerControlInterface.IPowerOnCriteria}
    })
PowerControl.ComputerSystemPowerControl = TComputerSystemPowerControl
 
function TComputerSystemPowerControl:ctor(ComputerSystemId, FruId)
    self.path = '/bmc/kepler/Systems/' .. ComputerSystemId .. '/FruCtrl/' .. FruId .. ''
end
 
local TComputerSystemPowerControlAccessor = Mdb.register_object(
    '/bmc/kepler/Hwproxy/Systems/:ComputerSystemId',
    {{name = 'Accessor', interface = PowerControlInterface.IComputerSystemPowerControlAccessor}})
PowerControl.ComputerSystemPowerControlAccessor = TComputerSystemPowerControlAccessor
 
function TComputerSystemPowerControlAccessor:ctor(ComputerSystemId)
    self.path = '/bmc/kepler/Hwproxy/Systems/' .. ComputerSystemId .. ''
end
 
return PowerControl