-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require "mc.class"
local abstr_operation = require "util.operator.abstract_operation"

local operation = {}

-- 整型比较
local TIntegerOperation = class(abstr_operation)

function TIntegerOperation.is_equal(obj1, obj2)
    return obj1 == obj2
end

function TIntegerOperation.is_no_equal(obj1, obj2)
    return obj1 ~= obj2
end

function TIntegerOperation.is_greater(obj1, obj2)
    return obj1 > obj2
end

function TIntegerOperation.is_greater_or_equal(obj1, obj2)
    return obj1 >= obj2
end

function TIntegerOperation.is_less(obj1, obj2)
    return obj1 < obj2
end

function TIntegerOperation.is_less_or_equal(obj1, obj2)
    return obj1 <= obj2
end

operation.IntegerOperation = TIntegerOperation

-- Bool类型比较
local TBooleanOperation = class(abstr_operation)

function TBooleanOperation.is_equal(obj1, obj2)
    return obj1 == obj2
end

function TBooleanOperation.is_no_equal(obj1, obj2)
    return obj1 ~= obj2
end

operation.BooleanOperation = TBooleanOperation

-- String类型比较
local TStringOperation = class(abstr_operation)

function TStringOperation.is_equal(obj1, obj2)
    return obj1 == obj2
end

function TStringOperation.is_no_equal(obj1, obj2)
    return obj1 ~= obj2
end

operation.StringOperation = TStringOperation

return operation