-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require "mc.class"
local prop_def = require 'macros.property_def'

local abstract_operation = class()

function abstract_operation:operator(op_type, obj1, obj2)
    if op_type == prop_def.REGRIST_PROP_COMPARE_EQU then
        return self.is_equal(obj1, obj2)
    elseif op_type == prop_def.REGRIST_PROP_COMPARE_NEQ then
        return self.is_no_equal(obj1, obj2)
    elseif op_type == prop_def.REGRIST_PROP_COMPARE_GTR then
        return self.is_greater(obj1, obj2)
    elseif op_type == prop_def.REGRIST_PROP_COMPARE_GEQ then
        return self.is_greater_or_equal(obj1, obj2)
    elseif op_type == prop_def.REGRIST_PROP_COMPARE_LSS then
        return self.is_less(obj1, obj2)
    elseif op_type == prop_def.REGRIST_PROP_COMPARE_LEQ then
        return self.is_less_or_equal(obj1, obj2)
    else
        return false
    end
end

function abstract_operation.is_equal(obj1, obj2)
    return false
end

function abstract_operation.is_no_equal(obj1, obj2)
    return false
end

function abstract_operation.is_greater(obj1, obj2)
    return false
end

function abstract_operation.is_greater_or_equal(obj1, obj2)
    return false
end

function abstract_operation.is_less(obj1, obj2)
    return false
end

function abstract_operation.is_less_or_equal(obj1, obj2)
    return false
end

return abstract_operation