-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local prop_def = require "macros.property_def"
local log = require 'mc.logging'
local file_object = {}
file_object.__index = file_object

function file_object.new()
    local data_operate = {
        data_flag = 0x00,
        data_offset = 0x00,
        data_len = 0x00,
        data_buf = nil,
        file_size_limit = 0x00,
        checksum = 0x00
    }
    return setmetatable({data_operate = data_operate}, file_object)
end

function file_object:clear_data_operate()
    if not self.data_operate then
        log:error("[bios]clear_data_operate: file data operate is NULL!")
        return
    end

    self.data_operate.data_flag = prop_def.BIOS_FLAG_IDLE
    self.data_operate.data_len = 0
    self.data_operate.data_offset = 0

    if self.data_operate.data_buf then
        self.data_operate.data_buf = nil
    end
end

function file_object:get_flag()
    return self.data_operate.data_flag
end

function file_object:set_flag(value)
    self.data_operate.data_flag = value
    return
end

function file_object:get_offset()
    return self.data_operate.data_offset
end

function file_object:set_offset(value)
    if type(value) ~= 'number' then
        log:error("[bios]set file operate data offest error, type:" .. type(value))
        return
    end
    self.data_operate.data_offset = value
    return
end

function file_object:get_len()
    return self.data_operate.data_len
end

function file_object:set_len(value)
    if type(value) ~= 'number' or value < 0 then
        log:error("[bios]set file operate data length error, type:" .. type(value))
        return
    end
    self.data_operate.data_len = value
    return
end

function file_object:get_buf()
    return self.data_operate.data_buf
end

function file_object:set_buf(value)
    self.data_operate.data_buf = value
end

function file_object:get_file_size_limit()
    return self.data_operate.file_size_limit
end

function file_object:set_file_size_limit(value)
    self.data_operate.file_size_limit = value
end

function file_object:init_checksum()
    self.data_operate.checksum = 0x00
end

function file_object:add_checksum(cur_checksum)
    local checksum = self.data_operate.checksum
    self.data_operate.checksum = (checksum + cur_checksum) & 0xff
end

function file_object:get_checksum()
    return self.data_operate.checksum
end

return file_object