-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require "mc.class"
local abstract_cfg = require "pojo.boot.abstract_boot_option"
local boot_def = require "macros.boot_def"
local bios_factory = require 'factory.bios_factory'

local boot_progress = class(abstract_cfg)

function boot_progress:ctor(option_db_obj, system_id)
    boot_progress.super.init_db_info(self, option_db_obj,
        boot_def.SET_IN_PROGRESS, boot_def.SET_IN_PROGRESS_LOG, system_id)
end

-- 设置启动参数
function boot_progress:operate_info(config_data)
    local boot_options_service = bios_factory.get_service('boot_options_service')
    local customer = boot_options_service:get_customer() or ''
    if #config_data > 1 and customer == 'ByteDance' then
        return boot_def.COMP_CODE_LEN_INVALID
    end
    local comp_code = boot_def.COMP_CODE_SUCCESS
    local process_flag = string.sub(config_data, 1, 1):byte()
    process_flag = process_flag & 3
    if process_flag == boot_def.BOOTOPTION_SET_COMPLETE then
        self.data[0] = boot_def.BOOTOPTION_SET_COMPLETE
    elseif process_flag == boot_def.BOOTOPTION_SET_INPROGRESS then
        if self.data[0] == boot_def.BOOTOPTION_SET_INPROGRESS then
            comp_code = boot_def.COMP_CODE_SET_IN_PROGRESS
        else
            self.data[0] = boot_def.BOOTOPTION_SET_INPROGRESS
        end
    elseif process_flag == boot_def.BOOTOPTION_COMMIT_WRITE then
        self.data[0] = boot_def.BOOTOPTION_COMMIT_WRITE
    else
        comp_code = boot_def.COMP_CODE_OUTOF_RANGE
    end

    return comp_code
end

return boot_progress