-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require "mc.class"
local abstract_cfg = require "pojo.boot.abstract_boot_option"
local boot_def = require "macros.boot_def"
local log = require "mc.logging"
local bios_factory = require 'factory.bios_factory'
local ENABLE_BIT_MASK<const> = 0x1f

local boot_info_acknowledge = class(abstract_cfg)

function boot_info_acknowledge:ctor(option_db_obj, system_id)
    boot_info_acknowledge.super.init_db_info(self, option_db_obj,
        boot_def.BOOT_INFO_ACKNOWLEDGE, boot_def.BOOT_INFO_ACKNOWLEDGE_LOG, system_id)
end

-- 设置启动参数
function boot_info_acknowledge:operate_info(config_data)
    local boot_options_service = bios_factory.get_service('boot_options_service')
    local customer = boot_options_service:get_customer() or ''
    if #config_data > boot_def.BIOS_BOOT_ACK_INFO_NUM and customer == 'ByteDance' then
        return boot_def.COMP_CODE_LEN_INVALID
    end

    local mask = string.sub(config_data, 1, 1):byte()
    local new_value = (string.sub(config_data, 2, 2):byte() & ENABLE_BIT_MASK)
    local pre_value = self.data[1]

    self.data[1] = ((mask & new_value) | (~mask & pre_value))
    self.data[0] = 0

    return boot_def.COMP_CODE_SUCCESS
end

return boot_info_acknowledge