-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require "mc.class"
local abstract_cfg = require "pojo.boot.abstract_boot_option"
local boot_def = require "macros.boot_def"
local bios_factory = require 'factory.bios_factory'

local boot_flag_valid = class(abstract_cfg)

function boot_flag_valid:ctor(option_db_obj, system_id)
    local db_has_value = boot_flag_valid.super.init_db_info(self, option_db_obj,
        boot_def.BOOT_FLAG_VALID_BIT_CLEARING, boot_def.BOOT_FLAG_VALID_BIT_CLEARING_LOG, system_id)
    if db_has_value then
        return
    end
    -- 初始化时如果持久化中没有数据，将第3位设置为1，默认超过60秒未上下电不清除ipmi下发的启动项配置
    if self.data == nil then
        self.data = {}
    end
    local old_value = type(self.data[0]) == "number" and self.data[0] or 0
    self.data[0] = old_value | boot_def.PBIT3
end

function boot_flag_valid:operate_info(config_data)
    local boot_options_service = bios_factory.get_service('boot_options_service')
    local customer = boot_options_service:get_customer() or ''
    if #config_data > 1 and customer == 'ByteDance' then
        return boot_def.COMP_CODE_LEN_INVALID
    end
    self.data[0] = string.sub(config_data, 1, 1):byte()
    return boot_def.COMP_CODE_SUCCESS
end

function boot_flag_valid:auto_clear_valid()
    return ((self.data[0] & boot_def.PBIT3) >> boot_def.BIOS_AUTO_CLEAR_BOOT_FLAG_SHIFT) ==
               boot_def.BIOS_AUTO_CLEAR_BOOT_FLAG_VALID
end

return boot_flag_valid
