-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local boot_def = {}

boot_def.EFFECTIVE_NONE = 0
boot_def.EFFECTIVE_ONCE = 1
boot_def.EFFECTIVE_FOREVER = 2

boot_def.BMC_DISABLE = 0
boot_def.BMC_ENABLE = 1

boot_def.BIOS_BOOT_VALID_NUM = 5

boot_def.BIOS_BOOT_LEGACY = 0
boot_def.BIOS_BOOT_UEFI = 1

boot_def.BOOT_MODE_SUPPORT_FLAG_ENABLE = 1

boot_def.BIOS_BOOT_OPTION_BIT = 7
-- BIT掩码（与操作用）
boot_def.PBIT0 = 0x01
boot_def.PBIT1 = 0x02
boot_def.PBIT2 = 0x04
boot_def.PBIT3 = 0x08
boot_def.PBIT4 = 0x10
boot_def.PBIT5 = 0x20
boot_def.PBIT6 = 0x40
boot_def.PBIT7 = 0x80
-- BIT掩码（或操作用）
boot_def.NBIT0 = 0xfe
boot_def.NBIT1 = 0xfd
boot_def.NBIT2 = 0xfb
boot_def.NBIT3 = 0xf7
boot_def.NBIT4 = 0xef
boot_def.NBIT5 = 0xdf
boot_def.NBIT6 = 0xbf
boot_def.NBIT7 = 0x7f

boot_def.BIOS_AUTO_CLEAR_BOOT_FLAG_SHIFT = 3
boot_def.BIOS_AUTO_CLEAR_BOOT_FLAG_VALID = 0
boot_def.BIOS_AUTO_CLEAR_BOOT_FLAG_INVALID = 1

boot_def.BIOS_BOOT_PROGRESS_CMD = 0
boot_def.BIOS_BOOT_PARTITION_SEL_CMD = 1
boot_def.BIOS_BOOT_PARTITION_SCAN_CMD = 2
boot_def.BIOS_BOOT_FLAG_VALID_CMD = 3
boot_def.BIOS_BOOT_ACKNOWLEDGE_CMD = 4
boot_def.BIOS_BOOT_FLAGS_CMD = 5
boot_def.BIOS_BOOT_INITIATOR_INFO_CMD = 6
boot_def.BIOS_BOOT_INITIATOR_MAILBOX_CMD = 7
boot_def.BIOS_BOOT_OEM_WRITE_PROT_CMD = 0x63
boot_def.BIOS_BOOT_NUM = 256

boot_def.POWER_OFF_TIMEOUT = 0x62
boot_def.POWER_ON_DELAY = 0x65

boot_def.BIOS_BOOT_TYPE_STR = "BootType"
boot_def.BIOS_UEFI_BOOT = "UEFI"
boot_def.BIOS_UEFI_BOOT_STR = "UEFIBoot"
boot_def.BIOS_LEGACY_BOOT_STR = "LegacyBoot"

boot_def.BIOS_VALID_FLAG_INTREVAL = 8

boot_def.BIOS_BOOT_OPTION_INVALID = 0
boot_def.BIOS_BOOT_OPTION_VALID = 1

boot_def.BIOS_BOOT_VALID_SEG_NUM = 16

boot_def.BOOT_ORDER_HDD = "HardDiskDrive"
boot_def.BOOT_ORDER_DVD = "DVDROMDrive"
boot_def.BOOT_ORDER_PXE = "PXE"
boot_def.BOOT_ORDER_OTHERS = "Others"

boot_def.BOOT_OPTION_IPMI_RESP_FORMAT = '<<ParameterVersion, BootOptionSelector, ConfigurationData/string>>'
boot_def.BOOT_OPTION_PARAMETER_VERSION = 1

boot_def.NO_OVERRIDE = 0x00
boot_def.FORCE_PEX = 0x01
boot_def.FORCE_HARD_DRIVE = 0x02
boot_def.FORCE_SAFE_MODE = 0x03
boot_def.FORCE_DIAGNOSTIC_PARTITION = 0x04
boot_def.FORCE_CD_DVD = 0x05
boot_def.FORCE_BIOS_SETUP = 0x06
boot_def.FORCE_FLOPPY_REMOVABLE_MEDIA = 0x0F

boot_def.BOOTOPTION_SET_COMPLETE = 0
boot_def.BOOTOPTION_SET_INPROGRESS = 1
boot_def.BOOTOPTION_COMMIT_WRITE = 2

boot_def.COMP_CODE_INVALID_CMD = 0xC1
boot_def.COMP_CODE_INVALID_FIELD = 0xCC
boot_def.COMP_CODE_SUCCESS = 0x00
boot_def.COMP_CODE_SET_IN_PROGRESS = 0x81
boot_def.COMP_CODE_LEN_INVALID = 0xC7
boot_def.COMP_CODE_OUTOF_RANGE = 0xC9
boot_def.COMP_CODE_PARAM_NOT_SUPPORTED = 0x80
boot_def.COMP_CODE_UNKNOWN = 0xFF

boot_def.BIOS_BOOT_ACK_INFO_NUM = 2
boot_def.BIOS_BOOT_INIT_INFO_NUM = 9
boot_def.BIOS_BOOT_MAIBOX_SEG_LEN = 1
boot_def.BIOS_BOOT_INIT_MAILBOX_NUM = 80
boot_def.BIOS_BOOT_VALID_SEG_NUM = 16
boot_def.BIOS_BOOT_VALID_SEG_TOTAL_NUM = 17
boot_def.BIOS_MAILBOX_SEG_MAX_NUM = boot_def.BIOS_BOOT_INIT_MAILBOX_NUM / boot_def.BIOS_BOOT_VALID_SEG_NUM
boot_def.BIOS_BOOT_SEG_MIN_NUM = 1

boot_def.VALID_FLAG = 'ValidFlag'
boot_def.SET_IN_PROGRESS = 'SetInProgress'
boot_def.SERVICE_PARTITION_SELECTOR = 'ServicePartitionSelector'
boot_def.SERVICE_PARTITION_SCAN = 'ServicePartitionScan'
boot_def.BOOT_FLAG_VALID_BIT_CLEARING = 'BootFlagValidBitClearing'
boot_def.BOOT_INFO_ACKNOWLEDGE = 'BootInfoAcknowledge'
boot_def.BOOT_FLAGS = 'BootFlags'
boot_def.BOOT_INITIATOR_INFO = 'BootInitiatorInfo'
boot_def.BOOT_INITIATOR_MAILBOX = 'BootInitiatorMailbox'
boot_def.WRITE_PROTECT = 'WriteProtect'

boot_def.VALID_FLAG_LOG = 'valid flag'
boot_def.SET_IN_PROGRESS_LOG = 'set in progress'
boot_def.SERVICE_PARTITION_SELECTOR_LOG = 'service partition selector'
boot_def.SERVICE_PARTITION_SCAN_LOG = 'service partition scan'
boot_def.BOOT_FLAG_VALID_BIT_CLEARING_LOG = 'boot flag valid bit clearing'
boot_def.BOOT_INFO_ACKNOWLEDGE_LOG = 'boot info acknowledge'
boot_def.BOOT_FLAGS_LOG = 'boot flags'
boot_def.BOOT_INITIATOR_INFO_LOG = 'boot initiator info'
boot_def.BOOT_INITIATOR_MAILBOX_LOG = 'boot initiator mailbox'
boot_def.WRITE_PROTECT_LOG = 'write protect'

boot_def.BOOT_LEN_TBL = {
    [boot_def.VALID_FLAG] = boot_def.BIOS_BOOT_VALID_SEG_NUM,
    [boot_def.SET_IN_PROGRESS] = 1,
    [boot_def.SERVICE_PARTITION_SELECTOR] = 1,
    [boot_def.SERVICE_PARTITION_SCAN] = 1,
    [boot_def.BOOT_FLAG_VALID_BIT_CLEARING] = 1,
    [boot_def.BOOT_INFO_ACKNOWLEDGE] = boot_def.BIOS_BOOT_ACK_INFO_NUM,
    [boot_def.BOOT_FLAGS] = boot_def.BIOS_BOOT_VALID_NUM,
    [boot_def.BOOT_INITIATOR_INFO] = boot_def.BIOS_BOOT_INIT_INFO_NUM,
    [boot_def.BOOT_INITIATOR_MAILBOX] = boot_def.BIOS_BOOT_MAIBOX_SEG_LEN,
    [boot_def.WRITE_PROTECT] = 1
}

boot_def.start_option_string_tbl = {
    [boot_def.NO_OVERRIDE] = "None",
    [boot_def.FORCE_PEX] = "Pxe",
    [boot_def.FORCE_HARD_DRIVE] = "Hdd",
    [boot_def.FORCE_CD_DVD] = "Cd",
    [boot_def.FORCE_BIOS_SETUP] = "BiosSetup",
    [boot_def.FORCE_FLOPPY_REMOVABLE_MEDIA] = "Floppy"
}

boot_def.start_option_to_order = {
    ["Pxe"] = "PXE",
    ["Hdd"] = "HardDiskDrive",
    ["Cd"] = "DVDROMDrive",
    ["None"] = "",
    ["BiosSetup"] = "Others",
    ["Floppy"] = "Others"
}

boot_def.start_option_tbl = {
    ["None"] = boot_def.NO_OVERRIDE,
    ["Pxe"] = boot_def.FORCE_PEX,
    ["Hdd"] = boot_def.FORCE_HARD_DRIVE,
    ["Cd"] = boot_def.FORCE_CD_DVD,
    ["BiosSetup"] = boot_def.FORCE_BIOS_SETUP,
    ["Floppy"] = boot_def.FORCE_FLOPPY_REMOVABLE_MEDIA
}

boot_def.TaskFlag = {
    Begin = 0,
    LastRpc = 1,
    LastIpmi = 2
}

boot_def.start_option_flag_tbl = {
    ["Disabled"] = boot_def.EFFECTIVE_NONE,
    ["Once"] = boot_def.EFFECTIVE_ONCE,
    ["Continuous"] = boot_def.EFFECTIVE_FOREVER
}

return boot_def