-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'

local config_handler = {}

local TExport_handler = class()
-- 将export_cfg中包含traverse_cfg的都去掉
function TExport_handler.handle(traverse_cfg, output_cfg)
    if not traverse_cfg or not output_cfg then
        return nil
    end

    for key, _ in pairs(traverse_cfg) do
        output_cfg[key] = nil
    end

    return output_cfg
end

config_handler.export_handler = TExport_handler

local TImport_handler = class()
function TImport_handler.handle(traverse_cfg, output_cfg)
    if not traverse_cfg then
        return nil
    end

    for key, value in pairs(traverse_cfg) do
        if key and value then
            return key
        end
    end

    return nil
end

config_handler.import_handler = TImport_handler
return config_handler