-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local defs = {}

defs.Type = {
    Block = 1,
    Character = 2
}

defs.ParameterSelector = {
    [0] = 'SetProgressSystemInfo',
    [1] = 'SystemFirmwareVersion',
    [2] = 'SystemName',
    [3] = 'PrimaryOperatingSystemName',
    [4] = 'OperatingSystemName',
    [5] = 'PresentOSVersionNumber',
    [6] = 'BMCUrl',
    [7] = 'BaseOsUrlForManageability'
}

defs.ParameterSelectorToCmd = {
    SetProgressSystemInfo = 0,
    SystemFirmwareVersion = 1,
    SystemName = 2,
    PrimaryOperatingSystemName = 3,
    OperatingSystemName = 4,
    PresentOSVersionNumber = 5,
    BMCUrl = 6,
    BaseOsUrlForManageability = 7
}

defs.ParameterSelectorType = {
    SystemFirmwareVersion = defs.Type.Block,
    SystemName = defs.Type.Block,
    PrimaryOperatingSystemName = defs.Type.Block,
    OperatingSystemName = defs.Type.Block,
    PresentOSVersionNumber = defs.Type.Block,
    BMCUrl = defs.Type.Character,
    BaseOsUrlForManageability = defs.Type.Character
}

defs.ParameterSelectorVolidate = {
    SystemFirmwareVersion = false,
    SystemName = false,
    PrimaryOperatingSystemName = true,
    OperatingSystemName = true,
    PresentOSVersionNumber = false,
    BMCUrl = false,
    BaseOsUrlForManageability = false
}

return defs