-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local defs = {}

defs.AlarmType = {
    MemoryLink = 'MemoryLink',
    PowerLink = 'PowerLink',
    VRAbnormal = 'VRAbnormal'
}

defs.MemaryLinkAlarmArgs = {
    DimmIndex = 'DimmIndex'
}

defs.PowerLinkAlarmArgs = {
    CPU = 'CPU',
    Type = 'Type',
    Die = 'Die',
    Channel = 'Channel'
}

defs.VRAbnormalArgs = {
    CPU = 'CPU',
    Die = 'Die',
    Type = 'Type'
}

defs.PowerTypeInfo = {
    [0] = 'CORE',
    [1] = 'UNCORE',
    [2] = 'DDR VDD',
    [3] = 'Nimbus',
    [4] = 'DDR VDDQ',
    [5] = 'CORE_MEM',
    [6] = 'UNCORE_MEM',
    [7] = 'SIOE',
    [8] = 'HBM',
    [13] = 'SERDES',
    [14] = 'IO_DVDD09'
}

defs.DeviceId = {
    PSU = 13,
    VR = 14
}

defs.PowerDie = {
    [0] = 'NA',
    [1] = 'TA',
    [2] = 'NB',
    [3] = 'TB',
    [4] = 'NC',
    [5] = 'TC',
    [6] = 'ND',
    [7] = 'TD',
    [80] = 'NANAB',
    [81] = 'NCND',
    [255] = ''
}

defs.PowerChannel = {
    [0] = 'PMBUS',
    [1] = 'AVSBUS'
}

return defs
