-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'
local create_enum_type = require 'mc.enum'

local BiosEnum = {}

---@class BiosEnum.SmbiosErrCode: Enum
local ESmbiosErrCode = create_enum_type('SmbiosErrCode')
ESmbiosErrCode.SMBIOS_ERR_NORMALLY = ESmbiosErrCode.new(0)
ESmbiosErrCode.SMBIOS_ERR_INVALID_STATUS = ESmbiosErrCode.new(213)
ESmbiosErrCode.SMBIOS_ERR_INVALID_CHKSUM = ESmbiosErrCode.new(128)
ESmbiosErrCode.SMBIOS_ERR_WRONG_OFFSET = ESmbiosErrCode.new(129)
ESmbiosErrCode.SMBIOS_ERR_FM_FAIL = ESmbiosErrCode.new(130)
ESmbiosErrCode.SMBIOS_ERR_IV_LEN = ESmbiosErrCode.new(131)
ESmbiosErrCode.SMBIOS_ERR_INVALID_FIELD = ESmbiosErrCode.new(204)
ESmbiosErrCode.SMBIOS_ERR_INVALID_CMD = ESmbiosErrCode.new(193)

BiosEnum.SmbiosErrCode = ESmbiosErrCode

---@class BiosEnum.SmbiosWriteStage: Enum
local ESmbiosWriteStage = create_enum_type('SmbiosWriteStage')
ESmbiosWriteStage.SMBIOS_WRITE_PREPARE = ESmbiosWriteStage.new(0)
ESmbiosWriteStage.SMBIOS_WRITE_DATA = ESmbiosWriteStage.new(1)
ESmbiosWriteStage.SMBIOS_WRITE_FINISH = ESmbiosWriteStage.new(3)
ESmbiosWriteStage.SMBIOS_WRITE_NOT_START = ESmbiosWriteStage.new(4)

BiosEnum.SmbiosWriteStage = ESmbiosWriteStage

---@class BiosEnum.SmBiosUpdatedFlag: Enum
local ESmBiosUpdatedFlag = create_enum_type('SmBiosUpdatedFlag')
ESmBiosUpdatedFlag.NO_ONCE_UPDATE_SMBIOS = ESmBiosUpdatedFlag.new(0)
ESmBiosUpdatedFlag.UPDATED_SMBIOS_AT_LEASE_ONCE = ESmBiosUpdatedFlag.new(1)

BiosEnum.SmBiosUpdatedFlag = ESmBiosUpdatedFlag

---@class BiosEnum.FileChange: Enum
local EFileChange = create_enum_type('FileChange')
EFileChange.SMBIOS_FILE_NO_CHANGE = EFileChange.new(0)
EFileChange.SMBIOS_FILE_ALREADY_CHANGE = EFileChange.new(1)

BiosEnum.FileChange = EFileChange

---@class BiosEnum.BiosStartupState: Enum
local EBiosStartupState = create_enum_type('BiosStartupState')
EBiosStartupState.BIOS_STARTUP_STATE_OFF = EBiosStartupState.new(0)
EBiosStartupState.BIOS_STARTUP_ME_EOP = EBiosStartupState.new(32)
EBiosStartupState.BIOS_STARTUP_PCIE_INFO_REPORTED = EBiosStartupState.new(64)
EBiosStartupState.BIOS_STARTUP_SMBIOS_WRITE_PREPARE = EBiosStartupState.new(96)
EBiosStartupState.BIOS_STARTUP_SMBIOS_WRITE_DATA = EBiosStartupState.new(99)
EBiosStartupState.BIOS_STARTUP_SMBIOS_WRITE_FINISH = EBiosStartupState.new(102)
EBiosStartupState.BIOS_STARTUP_POST_STAGE_FINISH = EBiosStartupState.new(254)

BiosEnum.BiosStartupState = EBiosStartupState

---@class BiosEnum.BiosErrCode: Enum
local EBiosErrCode = create_enum_type('BiosErrCode')
EBiosErrCode.BIOS_ERR_NORMALLY = EBiosErrCode.new(0)
EBiosErrCode.BIOS_ERR_INVALID_STATUS = EBiosErrCode.new(213)
EBiosErrCode.BIOS_ERR_INVALID_CHKSUM = EBiosErrCode.new(128)
EBiosErrCode.BIOS_ERR_WRONG_OFFSET = EBiosErrCode.new(129)
EBiosErrCode.BIOS_ERR_FM_FAIL = EBiosErrCode.new(130)
EBiosErrCode.BIOS_ERR_IV_LEN = EBiosErrCode.new(131)
EBiosErrCode.BIOS_ERR_INVALID_FIELD = EBiosErrCode.new(204)
EBiosErrCode.BIOS_ERR_INVALID_CMD = EBiosErrCode.new(193)

BiosEnum.BiosErrCode = EBiosErrCode

---@class BiosEnum.BiosWriteStage: Enum
local EBiosWriteStage = create_enum_type('BiosWriteStage')
EBiosWriteStage.BIOS_WRITE_PREPARE = EBiosWriteStage.new(0)
EBiosWriteStage.BIOS_WRITE_DATA = EBiosWriteStage.new(1)
EBiosWriteStage.BIOS_WRITE_FINISH = EBiosWriteStage.new(3)

BiosEnum.BiosWriteStage = EBiosWriteStage

---@class BiosEnum.BiosReadStage: Enum
local EBiosReadStage = create_enum_type('BiosReadStage')
EBiosReadStage.BIOS_READ_PREPARE = EBiosReadStage.new(0)
EBiosReadStage.BIOS_READ_DATA = EBiosReadStage.new(1)
EBiosReadStage.BIOS_READ_FINISH = EBiosReadStage.new(3)

BiosEnum.BiosReadStage = EBiosReadStage

return BiosEnum
