-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local create_enum_type = require 'mc.enum'

local def_types = {}

---@class def_types.FlashAlignPosition: Enum
local EFlashAlignPosition = create_enum_type('FlashAlignPosition')
EFlashAlignPosition.default = EFlashAlignPosition.new(2147483647)
EFlashAlignPosition.struct = nil
EFlashAlignPosition.Head = EFlashAlignPosition.new(1)
EFlashAlignPosition.Tail = EFlashAlignPosition.new(2)

def_types.FlashAlignPosition = EFlashAlignPosition

---@class def_types.MultihostConfig
---@field SlotId integer
---@field Bus integer
---@field Device integer
---@field Function integer
---@field MultihostIds integer[]
local TMultihostConfig = {}
TMultihostConfig.__index = TMultihostConfig
TMultihostConfig.group = {}

local function TMultihostConfig_from_obj(obj)
    return setmetatable(obj, TMultihostConfig)
end

function TMultihostConfig.new(SlotId, Bus, Device, Function, MultihostIds)
    return TMultihostConfig_from_obj({
        SlotId = SlotId,
        Bus = Bus,
        Device = Device,
        Function = Function,
        MultihostIds = MultihostIds
    })
end
---@param obj def_types.MultihostConfig
function TMultihostConfig:init_from_obj(obj)
    self.SlotId = obj.SlotId
    self.Bus = obj.Bus
    self.Device = obj.Device
    self.Function = obj.Function
    self.MultihostIds = obj.MultihostIds
end

function TMultihostConfig:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMultihostConfig.group)
end

TMultihostConfig.from_obj = TMultihostConfig_from_obj

TMultihostConfig.proto_property = {'SlotId', 'Bus', 'Device', 'Function', 'MultihostIds'}

TMultihostConfig.default = {0, 0, 0, 0, {}}

TMultihostConfig.struct = {
    {name = 'SlotId', is_array = false, struct = nil}, {name = 'Bus', is_array = false, struct = nil},
    {name = 'Device', is_array = false, struct = nil}, {name = 'Function', is_array = false, struct = nil},
    {name = 'MultihostIds', is_array = true, struct = nil}
}

function TMultihostConfig:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SlotId', self.SlotId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Bus', self.Bus, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Device', self.Device, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Function', self.Function, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'MultihostIds', self.MultihostIds, 'uint8', false, errs, need_convert)

    TMultihostConfig:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMultihostConfig.proto_property, errs, need_convert)
    return self
end

function TMultihostConfig:unpack(_)
    return self.SlotId, self.Bus, self.Device, self.Function, self.MultihostIds
end

def_types.MultihostConfig = TMultihostConfig

---@class def_types.IPMIChannelConfig
---@field HostId integer
---@field Instance integer
local TIPMIChannelConfig = {}
TIPMIChannelConfig.__index = TIPMIChannelConfig
TIPMIChannelConfig.group = {}

local function TIPMIChannelConfig_from_obj(obj)
    return setmetatable(obj, TIPMIChannelConfig)
end

function TIPMIChannelConfig.new(HostId, Instance)
    return TIPMIChannelConfig_from_obj({HostId = HostId, Instance = Instance})
end
---@param obj def_types.IPMIChannelConfig
function TIPMIChannelConfig:init_from_obj(obj)
    self.HostId = obj.HostId
    self.Instance = obj.Instance
end

function TIPMIChannelConfig:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIPMIChannelConfig.group)
end

TIPMIChannelConfig.from_obj = TIPMIChannelConfig_from_obj

TIPMIChannelConfig.proto_property = {'HostId', 'Instance'}

TIPMIChannelConfig.default = {0, 0}

TIPMIChannelConfig.struct = {
    {name = 'HostId', is_array = false, struct = nil}, {name = 'Instance', is_array = false, struct = nil}
}

function TIPMIChannelConfig:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HostId', self.HostId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Instance', self.Instance, 'uint8', false, errs, need_convert)

    TIPMIChannelConfig:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIPMIChannelConfig.proto_property, errs, need_convert)
    return self
end

function TIPMIChannelConfig:unpack(_)
    return self.HostId, self.Instance
end

def_types.IPMIChannelConfig = TIPMIChannelConfig

return def_types
