-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MSmBiosInfoTable = {}

---@class MSmBiosInfoTable.SmBiosStatus
---@field SmBiosStatus integer
local TSmBiosStatus = {}
TSmBiosStatus.__index = TSmBiosStatus
TSmBiosStatus.group = {}

local function TSmBiosStatus_from_obj(obj)
    return setmetatable(obj, TSmBiosStatus)
end

function TSmBiosStatus.new(SmBiosStatus)
    return TSmBiosStatus_from_obj({SmBiosStatus = SmBiosStatus or 4})
end
---@param obj MSmBiosInfoTable.SmBiosStatus
function TSmBiosStatus:init_from_obj(obj)
    self.SmBiosStatus = obj.SmBiosStatus or 4
end

function TSmBiosStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSmBiosStatus.group)
end

TSmBiosStatus.from_obj = TSmBiosStatus_from_obj

TSmBiosStatus.proto_property = {'SmBiosStatus'}

TSmBiosStatus.default = {0}

TSmBiosStatus.struct = {{name = 'SmBiosStatus', is_array = false, struct = nil}}

function TSmBiosStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SmBiosStatus', self.SmBiosStatus, 'uint8', false, errs, need_convert)

    TSmBiosStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSmBiosStatus.proto_property, errs, need_convert)
    return self
end

function TSmBiosStatus:unpack(_)
    return self.SmBiosStatus
end

MSmBiosInfoTable.SmBiosStatus = TSmBiosStatus

---@class MSmBiosInfoTable.SmBiosUpdatedFlag
---@field SmBiosUpdatedFlag integer
local TSmBiosUpdatedFlag = {}
TSmBiosUpdatedFlag.__index = TSmBiosUpdatedFlag
TSmBiosUpdatedFlag.group = {}

local function TSmBiosUpdatedFlag_from_obj(obj)
    return setmetatable(obj, TSmBiosUpdatedFlag)
end

function TSmBiosUpdatedFlag.new(SmBiosUpdatedFlag)
    return TSmBiosUpdatedFlag_from_obj({SmBiosUpdatedFlag = SmBiosUpdatedFlag})
end
---@param obj MSmBiosInfoTable.SmBiosUpdatedFlag
function TSmBiosUpdatedFlag:init_from_obj(obj)
    self.SmBiosUpdatedFlag = obj.SmBiosUpdatedFlag
end

function TSmBiosUpdatedFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSmBiosUpdatedFlag.group)
end

TSmBiosUpdatedFlag.from_obj = TSmBiosUpdatedFlag_from_obj

TSmBiosUpdatedFlag.proto_property = {'SmBiosUpdatedFlag'}

TSmBiosUpdatedFlag.default = {0}

TSmBiosUpdatedFlag.struct = {{name = 'SmBiosUpdatedFlag', is_array = false, struct = nil}}

function TSmBiosUpdatedFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SmBiosUpdatedFlag', self.SmBiosUpdatedFlag, 'uint8', false, errs, need_convert)

    TSmBiosUpdatedFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSmBiosUpdatedFlag.proto_property, errs, need_convert)
    return self
end

function TSmBiosUpdatedFlag:unpack(_)
    return self.SmBiosUpdatedFlag
end

MSmBiosInfoTable.SmBiosUpdatedFlag = TSmBiosUpdatedFlag

---@class MSmBiosInfoTable.Family
---@field Family string
local TFamily = {}
TFamily.__index = TFamily
TFamily.group = {}

local function TFamily_from_obj(obj)
    return setmetatable(obj, TFamily)
end

function TFamily.new(Family)
    return TFamily_from_obj({Family = Family})
end
---@param obj MSmBiosInfoTable.Family
function TFamily:init_from_obj(obj)
    self.Family = obj.Family
end

function TFamily:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFamily.group)
end

TFamily.from_obj = TFamily_from_obj

TFamily.proto_property = {'Family'}

TFamily.default = {''}

TFamily.struct = {{name = 'Family', is_array = false, struct = nil}}

function TFamily:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Family', self.Family, 'string', false, errs, need_convert)

    TFamily:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFamily.proto_property, errs, need_convert)
    return self
end

function TFamily:unpack(_)
    return self.Family
end

MSmBiosInfoTable.Family = TFamily

---@class MSmBiosInfoTable.SKUNumber
---@field SKUNumber string
local TSKUNumber = {}
TSKUNumber.__index = TSKUNumber
TSKUNumber.group = {}

local function TSKUNumber_from_obj(obj)
    return setmetatable(obj, TSKUNumber)
end

function TSKUNumber.new(SKUNumber)
    return TSKUNumber_from_obj({SKUNumber = SKUNumber})
end
---@param obj MSmBiosInfoTable.SKUNumber
function TSKUNumber:init_from_obj(obj)
    self.SKUNumber = obj.SKUNumber
end

function TSKUNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSKUNumber.group)
end

TSKUNumber.from_obj = TSKUNumber_from_obj

TSKUNumber.proto_property = {'SKUNumber'}

TSKUNumber.default = {''}

TSKUNumber.struct = {{name = 'SKUNumber', is_array = false, struct = nil}}

function TSKUNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SKUNumber', self.SKUNumber, 'string', false, errs, need_convert)

    TSKUNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSKUNumber.proto_property, errs, need_convert)
    return self
end

function TSKUNumber:unpack(_)
    return self.SKUNumber
end

MSmBiosInfoTable.SKUNumber = TSKUNumber

---@class MSmBiosInfoTable.Version
---@field Version string
local TVersion = {}
TVersion.__index = TVersion
TVersion.group = {}

local function TVersion_from_obj(obj)
    return setmetatable(obj, TVersion)
end

function TVersion.new(Version)
    return TVersion_from_obj({Version = Version})
end
---@param obj MSmBiosInfoTable.Version
function TVersion:init_from_obj(obj)
    self.Version = obj.Version
end

function TVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVersion.group)
end

TVersion.from_obj = TVersion_from_obj

TVersion.proto_property = {'Version'}

TVersion.default = {''}

TVersion.struct = {{name = 'Version', is_array = false, struct = nil}}

function TVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Version', self.Version, 'string', false, errs, need_convert)

    TVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVersion.proto_property, errs, need_convert)
    return self
end

function TVersion:unpack(_)
    return self.Version
end

MSmBiosInfoTable.Version = TVersion

---@class MSmBiosInfoTable.Id
---@field Id string
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MSmBiosInfoTable.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {''}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MSmBiosInfoTable.Id = TId

return MSmBiosInfoTable
