-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local mdb = require 'mc.mdb'
local class = require 'mc.class_mgnt'
local privilege = require 'mc.privilege'

local bios_class_types = require 'class.types.Bios'
local spi_channel_class_types = require 'class.types.SPIChannel'
local secure_boot_options_class_types = require 'class.types.SecureBootOptions'
local bios_fw_info_table_class_types = require 'class.types.BiosFwInfoTable'
local bios_boot_option_table_class_types = require 'class.types.BiosBootOptionTable'
local bios_boot_table_class_types = require 'class.types.BiosBootTable'
local bios_info_table_class_types = require 'class.types.BiosInfoTable'
local bios_update_cfg_table_class_types = require 'class.types.BiosUpdateCfgTable'
local sm_bios_info_table_class_types = require 'class.types.SmBiosInfoTable'
local cert_info_table_class_types = require 'class.types.CertInfoTable'
local bios_config_table_class_types = require 'class.types.BiosConfigTable'
local event_msg_class_types = require 'class.types.EventMsg'
local bios_upgrade_service_class_types = require 'class.types.BiosUpgradeService'
local cached_bios_upgrade_table_class_types = require 'class.types.CachedBiosUpgradeTable'
local tee_os_fw_info_table_class_types = require 'class.types.TeeOSFwInfoTable'
local biosipmi_channel_config_class_types = require 'class.types.BIOSIPMIChannelConfig'
local spi_rate_class_types = require 'class.types.SPIRate'
local bios_multihost_config_class_types = require 'class.types.BIOSMultihostConfig'
local cpu_die_class_types = require 'class.types.CPUDie'
local bios_firmware_custom_config_class_types = require 'class.types.BiosFirmwareCustomConfig'
local memory_silk_class_types = require 'class.types.MemorySilk'
local allowed_bios_upgrade_table_class_types = require 'class.types.AllowedBiosUpgradeTable'
local base_os_boot_class_types = require 'class.types.BaseOSBoot'
local system_info_table_class_types = require 'class.types.SystemInfoTable'
local bios_intf_types = require 'bios.json_types.Bios'
local retirement_intf_types = require 'bios.json_types.Retirement'
local properties_intf_types = require 'bios.json_types.Properties'
local sm_bios_intf_types = require 'bios.json_types.SmBios'
local boot_options_intf_types = require 'bios.json_types.BootOptions'
local secure_boot_options_intf_types = require 'bios.json_types.SecureBootOptions'
local bios_upgrade_service_intf_types = require 'bios.json_types.BiosUpgradeService'
local system_firmware_progress_status_intf_types = require 'bios.json_types.SystemFirmwareProgressStatus'
local ipmi_event_intf_types = require 'bios.json_types.IPMIEvent'

local Bios = {
    ['prop_configs'] = {
        ['ResetCmos'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = bios_class_types.ResetCmos},
        ['Slot'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = bios_class_types.Slot},
        ['SecureBootEnableCompletionCode'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = bios_class_types.SecureBootEnableCompletionCode
        },
        ['SecureBootEnableState'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = bios_class_types.SecureBootEnableState
        },
        ['SecureBootVerifyCompletionCode'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = bios_class_types.SecureBootVerifyCompletionCode
        },
        ['SecureBootVerifyState'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = bios_class_types.SecureBootVerifyState
        },
        ['Soc'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = bios_class_types.Soc},
        ['FlashNum'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['validator'] = bios_class_types.FlashNum
        },
        ['FlashSize'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 32,
            ['validator'] = bios_class_types.FlashSize
        },
        ['FlashChannel'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = bios_class_types.FlashChannel
        }
    },
    ['default_props'] = {
        ['ResetCmos'] = bios_class_types.ResetCmos.default[1],
        ['Slot'] = bios_class_types.Slot.default[1],
        ['SecureBootEnableCompletionCode'] = bios_class_types.SecureBootEnableCompletionCode.default[1],
        ['SecureBootEnableState'] = bios_class_types.SecureBootEnableState.default[1],
        ['SecureBootVerifyCompletionCode'] = bios_class_types.SecureBootVerifyCompletionCode.default[1],
        ['SecureBootVerifyState'] = bios_class_types.SecureBootVerifyState.default[1],
        ['Soc'] = bios_class_types.Soc.default[1],
        ['FlashNum'] = 1,
        ['FlashSize'] = 32,
        ['FlashChannel'] = 0
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Bios'] = {
            ['SystemStartupState'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['enum'] = {0, 32, 64, 96, 99, 102, 111, 254},
                ['validator'] = bios_intf_types.SystemStartupState
            },
            ['SystemId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = bios_intf_types.SystemId
            },
            ['Version'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = bios_intf_types.Version
            },
            ['BackupVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = bios_intf_types.BackupVersion
            },
            ['CurrentValueFileName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = bios_intf_types.CurrentValueFileName
            },
            ['ResultFileName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = bios_intf_types.ResultFileName
            },
            ['SettingFileName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = bios_intf_types.SettingFileName
            },
            ['RegistryFileName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = bios_intf_types.RegistryFileName
            },
            ['MenuData'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = bios_intf_types.MenuData},
            ['MenuChangeFlag'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = bios_intf_types.MenuChangeFlag
            },
            ['RegistryVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = bios_intf_types.RegistryVersion
            },
            ['DEMTConfig'] = {['baseType'] = 'U8', ['readOnly'] = true, ['validator'] = bios_intf_types.DEMTConfig},
            ['PcieCardBDF'] = {['baseType'] = 'U8[]', ['readOnly'] = true, ['validator'] = bios_intf_types.PcieCardBDF},
            ['PcieDiskBDF'] = {['baseType'] = 'U8[]', ['readOnly'] = true, ['validator'] = bios_intf_types.PcieDiskBDF},
            ['OCPCardBDF'] = {['baseType'] = 'U8[]', ['readOnly'] = true, ['validator'] = bios_intf_types.OCPCardBDF},
            ['BiosBootStage'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = bios_intf_types.BiosBootStage
            },
            ['UpgradeFailed'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = bios_intf_types.UpgradeFailed
            },
            ['RecoverFailed'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = bios_intf_types.RecoverFailed
            },
            ['BiosLogPrintEnabled'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = bios_intf_types.BiosLogPrintEnabled
            },
            ['BiosConfigActiveMode'] = {
                ['baseType'] = 'U64',
                ['readOnly'] = true,
                ['validator'] = bios_intf_types.BiosConfigActiveMode
            },
            ['ResetBiosToDefaultsPending'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['validator'] = bios_intf_types.ResetBiosToDefaultsPending
            },
            ['SettingsEffectiveStatus'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = bios_intf_types.SettingsEffectiveStatus
            },
            ['TeeOSVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = bios_intf_types.TeeOSVersion
            }
        },
        ['bmc.kepler.LifeCycle.Retirement'] = {
            ['Media'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'Flash', 'SSD', 'Eeprom', 'HDD'},
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = retirement_intf_types.Media
            },
            ['Source'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'Huawei', 'User'},
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = retirement_intf_types.Source
            },
            ['Description'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'Clear', 'Perge'},
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = retirement_intf_types.Description
            },
            ['Method'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'OverWrite', 'BlockErase', 'CryptoErase'},
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = retirement_intf_types.Method
            },
            ['Result'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'Successful', 'Failed'},
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = retirement_intf_types.Result
            },
            ['Progress'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = retirement_intf_types.Progress
            },
            ['State'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'Idle', 'Running', 'Finish'},
                ['default'] = 'Idle',
                ['validator'] = retirement_intf_types.State
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.Bios'] = {
            ['ClearCmos'] = {
                ['req'] = {},
                ['rsp'] = {{['baseType'] = 'S32', ['param'] = 'Result'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['ResetSetupConfig'] = {
                ['req'] = {},
                ['rsp'] = {{['baseType'] = 'S32', ['param'] = 'Result'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['ChangePassword'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['param'] = 'PasswordType'},
                    {['baseType'] = 'String', ['param'] = 'OldPassword'},
                    {['baseType'] = 'String', ['param'] = 'NewPassword'}
                },
                ['rsp'] = {{['baseType'] = 'S32', ['param'] = 'Result'}},
                ['privilege'] = {'UserMgmt'}
            },
            ['ImportBiosSetup'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['param'] = 'FileType'}, {['baseType'] = 'String', ['param'] = 'Content'}
                },
                ['rsp'] = {{['baseType'] = 'S32', ['param'] = 'Result'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['GetCurrentValueSetting'] = {
                ['req'] = {{['baseType'] = 'String', ['param'] = 'ReqKey'}},
                ['rsp'] = {{['baseType'] = 'String', ['param'] = 'RespValue'}}
            },
            ['RemoveCachedSettings'] = {
                ['req'] = {},
                ['rsp'] = {{['baseType'] = 'S32', ['param'] = 'Result'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['ExportFirmware'] = {
                ['req'] = {{['baseType'] = 'String', ['param'] = 'OutputFilePath'}},
                ['rsp'] = {{['baseType'] = 'U32', ['param'] = 'TaskId'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['SetBiosConfigActiveMode'] = {['req'] = {{['baseType'] = 'U64', ['param'] = 'Mode'}}, ['rsp'] = {}},
            ['SetBiosLogEnabled'] = {
                ['req'] = {{['baseType'] = 'U8', ['param'] = 'BiosLogPrintEnabled'}},
                ['rsp'] = {{['baseType'] = 'S32', ['param'] = 'Result'}}
            },
            ['ExportBiosSetup'] = {
                ['req'] = {{['baseType'] = 'String', ['param'] = 'FileType'}},
                ['rsp'] = {{['baseType'] = 'String', ['param'] = 'Result'}}
            }
        },
        ['bmc.kepler.LifeCycle.Retirement'] = {
            ['DataWipe'] = {['req'] = {}, ['rsp'] = {}, ['privilege'] = {'UserMgmt'}},
            ['GetReport'] = {
                ['req'] = {},
                ['rsp'] = {{['baseType'] = 'Dictionary', ['$ref'] = '#/defs/DataWipeReportDict', ['param'] = 'Report'}},
                ['privilege'] = {'ReadOnly'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Bios'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Bios'] = {
            ['property_defaults'] = {
                ['SystemStartupState'] = bios_intf_types.SystemStartupState.default[1],
                ['SystemId'] = bios_intf_types.SystemId.default[1],
                ['Version'] = bios_intf_types.Version.default[1],
                ['BackupVersion'] = bios_intf_types.BackupVersion.default[1],
                ['CurrentValueFileName'] = bios_intf_types.CurrentValueFileName.default[1],
                ['ResultFileName'] = bios_intf_types.ResultFileName.default[1],
                ['SettingFileName'] = bios_intf_types.SettingFileName.default[1],
                ['RegistryFileName'] = bios_intf_types.RegistryFileName.default[1],
                ['MenuData'] = bios_intf_types.MenuData.default[1],
                ['MenuChangeFlag'] = bios_intf_types.MenuChangeFlag.default[1],
                ['RegistryVersion'] = bios_intf_types.RegistryVersion.default[1],
                ['DEMTConfig'] = bios_intf_types.DEMTConfig.default[1],
                ['PcieCardBDF'] = bios_intf_types.PcieCardBDF.default[1],
                ['PcieDiskBDF'] = bios_intf_types.PcieDiskBDF.default[1],
                ['OCPCardBDF'] = bios_intf_types.OCPCardBDF.default[1],
                ['BiosBootStage'] = bios_intf_types.BiosBootStage.default[1],
                ['UpgradeFailed'] = bios_intf_types.UpgradeFailed.default[1],
                ['RecoverFailed'] = bios_intf_types.RecoverFailed.default[1],
                ['BiosLogPrintEnabled'] = bios_intf_types.BiosLogPrintEnabled.default[1],
                ['BiosConfigActiveMode'] = bios_intf_types.BiosConfigActiveMode.default[1],
                ['ResetBiosToDefaultsPending'] = bios_intf_types.ResetBiosToDefaultsPending.default[1],
                ['SettingsEffectiveStatus'] = bios_intf_types.SettingsEffectiveStatus.default[1],
                ['TeeOSVersion'] = bios_intf_types.TeeOSVersion.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ConfigureSelf,
                ['methods'] = {
                    ['ClearCmos'] = privilege.BasicSetting,
                    ['ResetSetupConfig'] = privilege.BasicSetting,
                    ['ChangePassword'] = privilege.UserMgmt,
                    ['ImportBiosSetup'] = privilege.BasicSetting,
                    ['RemoveCachedSettings'] = privilege.BasicSetting,
                    ['ExportFirmware'] = privilege.BasicSetting
                }
            },
            ['interface_types'] = bios_intf_types
        },
        ['bmc.kepler.LifeCycle.Retirement'] = {
            ['property_defaults'] = {
                ['Media'] = retirement_intf_types.Media.default[1],
                ['Source'] = retirement_intf_types.Source.default[1],
                ['Description'] = retirement_intf_types.Description.default[1],
                ['Method'] = retirement_intf_types.Method.default[1],
                ['Result'] = retirement_intf_types.Result.default[1],
                ['Progress'] = retirement_intf_types.Progress.default[1],
                ['State'] = 'Idle'
            },
            ['privileges'] = {
                ['path'] = privilege.ConfigureSelf,
                ['methods'] = {['DataWipe'] = privilege.UserMgmt, ['GetReport'] = privilege.ReadOnly}
            },
            ['interface_types'] = retirement_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = properties_intf_types
        }
    })
}

local SmBios = {
    ['prop_configs'] = {},
    ['default_props'] = {},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.SmBios'] = {
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = sm_bios_intf_types.SerialNumber
            },
            ['Version'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = sm_bios_intf_types.Version},
            ['SKUNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = sm_bios_intf_types.SKUNumber
            },
            ['Family'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = sm_bios_intf_types.Family},
            ['SmBiosStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = sm_bios_intf_types.SmBiosStatus
            },
            ['SmBiosUpdatedFlag'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = sm_bios_intf_types.SmBiosUpdatedFlag
            },
            ['FileChange'] = {['baseType'] = 'U8', ['readOnly'] = true, ['validator'] = sm_bios_intf_types.FileChange},
            ['FileName'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = sm_bios_intf_types.FileName},
            ['DiffFileName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = sm_bios_intf_types.DiffFileName
            },
            ['SystemId'] = {['baseType'] = 'U8', ['readOnly'] = true, ['validator'] = sm_bios_intf_types.SystemId}
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/SmBios'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.SmBios'] = {
            ['property_defaults'] = {
                ['SerialNumber'] = sm_bios_intf_types.SerialNumber.default[1],
                ['Version'] = sm_bios_intf_types.Version.default[1],
                ['SKUNumber'] = sm_bios_intf_types.SKUNumber.default[1],
                ['Family'] = sm_bios_intf_types.Family.default[1],
                ['SmBiosStatus'] = sm_bios_intf_types.SmBiosStatus.default[1],
                ['SmBiosUpdatedFlag'] = sm_bios_intf_types.SmBiosUpdatedFlag.default[1],
                ['FileChange'] = sm_bios_intf_types.FileChange.default[1],
                ['FileName'] = sm_bios_intf_types.FileName.default[1],
                ['DiffFileName'] = sm_bios_intf_types.DiffFileName.default[1],
                ['SystemId'] = sm_bios_intf_types.SystemId.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = sm_bios_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = properties_intf_types
        }
    })
}

local SPIChannel = {
    ['prop_configs'] = {
        ['Switch'] = {['baseType'] = 'U8', ['usage'] = {'CSR'}, ['validator'] = spi_channel_class_types.Switch}
    },
    ['default_props'] = {['Switch'] = spi_channel_class_types.Switch.default[1]}
}

local BootOptions = {
    ['prop_configs'] = {},
    ['default_props'] = {},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.BootOptions'] = {
            ['BootSourceOverrideMode'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['default'] = 'UEFI',
                ['validator'] = boot_options_intf_types.BootSourceOverrideMode
            },
            ['BootSourceOverrideEnabled'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['default'] = 'Disabled',
                ['validator'] = boot_options_intf_types.BootSourceOverrideEnabled
            },
            ['BootSourceOverrideTarget'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['default'] = 'HDD',
                ['validator'] = boot_options_intf_types.BootSourceOverrideTarget
            },
            ['BootOptionReference'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = true,
                ['validator'] = boot_options_intf_types.BootOptionReference
            },
            ['BootOrder'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = true,
                ['validator'] = boot_options_intf_types.BootOrder
            },
            ['BootModeSupport'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['default'] = true,
                ['validator'] = boot_options_intf_types.BootModeSupport
            },
            ['BootModeIpmiSettable'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['default'] = true,
                ['validator'] = boot_options_intf_types.BootModeIpmiSettable
            },
            ['BootOptionPolicy'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['default'] = 0,
                ['validator'] = boot_options_intf_types.BootOptionPolicy
            },
            ['PreviousBootSourceOverrideTarget'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['default'] = '',
                ['validator'] = boot_options_intf_types.PreviousBootSourceOverrideTarget
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.BootOptions'] = {
            ['ShieldIpmiModifyBootModeSupport'] = {
                ['req'] = {{['baseType'] = 'Boolean', ['param'] = 'ModeSwitch'}},
                ['rsp'] = {{['baseType'] = 'S32', ['param'] = 'RespCode'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['ImportCertificate'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['param'] = 'CertString'},
                    {['baseType'] = 'String', ['param'] = 'CertType'}
                },
                ['rsp'] = {},
                ['privilege'] = {'SecurityMgmt'}
            },
            ['ImportCrl'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['param'] = 'CertString'},
                    {['baseType'] = 'String', ['param'] = 'CertType'}
                },
                ['rsp'] = {},
                ['privilege'] = {'SecurityMgmt'}
            },
            ['ResetCrl'] = {
                ['req'] = {{['baseType'] = 'String', ['param'] = 'ResetType'}},
                ['rsp'] = {},
                ['privilege'] = {'SecurityMgmt'}
            },
            ['ResetCertificate'] = {
                ['req'] = {{['baseType'] = 'String', ['param'] = 'ResetType'}},
                ['rsp'] = {},
                ['privilege'] = {'SecurityMgmt'}
            },
            ['SetBootOrder'] = {
                ['req'] = {{['baseType'] = 'String', ['param'] = 'BootOrderJson'}},
                ['rsp'] = {
                    {['baseType'] = 'S32', ['param'] = 'OutCode'}, {['baseType'] = 'String', ['param'] = 'ErrName'},
                    {['baseType'] = 'String', ['param'] = 'ErrValue'}
                },
                ['privilege'] = {'BasicSetting'}
            },
            ['SetStartOption'] = {
                ['req'] = {{['baseType'] = 'String', ['param'] = 'StartOption'}},
                ['rsp'] = {{['baseType'] = 'S32', ['param'] = 'Result'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['SetStartOptionFlag'] = {
                ['req'] = {{['baseType'] = 'String', ['param'] = 'StartOptionFlag'}},
                ['rsp'] = {{['baseType'] = 'S32', ['param'] = 'Result'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['SetBootMode'] = {
                ['req'] = {{['baseType'] = 'String', ['param'] = 'mode'}},
                ['rsp'] = {{['baseType'] = 'S32', ['param'] = 'RespCode'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['GetCertificate'] = {['req'] = {}, ['rsp'] = {{['baseType'] = 'String', ['param'] = 'CertInfo'}}}
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:Id/BootOptions'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.BootOptions'] = {
            ['property_defaults'] = {
                ['BootSourceOverrideMode'] = 'UEFI',
                ['BootSourceOverrideEnabled'] = 'Disabled',
                ['BootSourceOverrideTarget'] = 'HDD',
                ['BootOptionReference'] = boot_options_intf_types.BootOptionReference.default[1],
                ['BootOrder'] = boot_options_intf_types.BootOrder.default[1],
                ['BootModeSupport'] = true,
                ['BootModeIpmiSettable'] = true,
                ['BootOptionPolicy'] = 0,
                ['PreviousBootSourceOverrideTarget'] = ''
            },
            ['privileges'] = {
                ['path'] = privilege.ConfigureSelf,
                ['methods'] = {
                    ['ShieldIpmiModifyBootModeSupport'] = privilege.BasicSetting,
                    ['ImportCertificate'] = privilege.SecurityMgmt,
                    ['ImportCrl'] = privilege.SecurityMgmt,
                    ['ResetCrl'] = privilege.SecurityMgmt,
                    ['ResetCertificate'] = privilege.SecurityMgmt,
                    ['SetBootOrder'] = privilege.BasicSetting,
                    ['SetStartOption'] = privilege.BasicSetting,
                    ['SetStartOptionFlag'] = privilege.BasicSetting,
                    ['SetBootMode'] = privilege.BasicSetting
                }
            },
            ['interface_types'] = boot_options_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = properties_intf_types
        }
    })
}

local SecureBootOptions = {
    ['prop_configs'] = {
        ['Slot'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = secure_boot_options_class_types.Slot}
    },
    ['default_props'] = {['Slot'] = secure_boot_options_class_types.Slot.default[1]},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.SecureBootOptions'] = {
            ['SystemId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = secure_boot_options_intf_types.SystemId
            },
            ['CertificateExpired'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = secure_boot_options_intf_types.CertificateExpired
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.SecureBootOptions'] = {
            ['ImportCertificate'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['param'] = 'DatabseType'},
                    {['baseType'] = 'String', ['param'] = 'CertString'},
                    {['baseType'] = 'String', ['param'] = 'CertType'}
                },
                ['rsp'] = {},
                ['privilege'] = {'SecurityMgmt'}
            },
            ['ResetCertificate'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['param'] = 'DatabseType'},
                    {['baseType'] = 'String', ['param'] = 'ResetType'}
                },
                ['rsp'] = {},
                ['privilege'] = {'SecurityMgmt'}
            },
            ['GetCertificate'] = {['req'] = {}, ['rsp'] = {{['baseType'] = 'String', ['param'] = 'CertInfo'}}}
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/SecureBootOptions'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.SecureBootOptions'] = {
            ['property_defaults'] = {
                ['SystemId'] = secure_boot_options_intf_types.SystemId.default[1],
                ['CertificateExpired'] = 0
            },
            ['privileges'] = {
                ['path'] = privilege.ConfigureSelf,
                ['methods'] = {
                    ['ImportCertificate'] = privilege.SecurityMgmt,
                    ['ResetCertificate'] = privilege.SecurityMgmt
                }
            },
            ['interface_types'] = secure_boot_options_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = properties_intf_types
        }
    })
}

local BiosFwInfoTable = {
    ['table_name'] = 't_bios_fw_info',
    ['prop_configs'] = {
        ['Id'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_fw_info_table_class_types.Id
        },
        ['Name'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_fw_info_table_class_types.Name
        },
        ['Version'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_fw_info_table_class_types.Version
        },
        ['BuildNum'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_fw_info_table_class_types.BuildNum
        },
        ['ReleaseDate'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_fw_info_table_class_types.ReleaseDate
        },
        ['LowestSupportedVersion'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_fw_info_table_class_types.LowestSupportedVersion
        },
        ['SoftwareId'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_fw_info_table_class_types.SoftwareId
        },
        ['Manufacturer'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_fw_info_table_class_types.Manufacturer
        },
        ['Updateable'] = {
            ['baseType'] = 'Boolean',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_fw_info_table_class_types.Updateable
        },
        ['Location'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_fw_info_table_class_types.Location
        },
        ['Capability'] = {
            ['baseType'] = 'U16',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_fw_info_table_class_types.Capability
        },
        ['State'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_fw_info_table_class_types.State
        },
        ['ActiveMode'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_fw_info_table_class_types.ActiveMode
        },
        ['ActiveModeSupported'] = {
            ['baseType'] = 'Boolean',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_fw_info_table_class_types.ActiveModeSupported
        },
        ['ActiveModeEnabled'] = {
            ['baseType'] = 'Boolean',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_fw_info_table_class_types.ActiveModeEnabled
        }
    },
    ['default_props'] = {
        ['Id'] = bios_fw_info_table_class_types.Id.default[1],
        ['Name'] = bios_fw_info_table_class_types.Name.default[1],
        ['Version'] = bios_fw_info_table_class_types.Version.default[1],
        ['BuildNum'] = bios_fw_info_table_class_types.BuildNum.default[1],
        ['ReleaseDate'] = bios_fw_info_table_class_types.ReleaseDate.default[1],
        ['LowestSupportedVersion'] = bios_fw_info_table_class_types.LowestSupportedVersion.default[1],
        ['SoftwareId'] = bios_fw_info_table_class_types.SoftwareId.default[1],
        ['Manufacturer'] = bios_fw_info_table_class_types.Manufacturer.default[1],
        ['Updateable'] = bios_fw_info_table_class_types.Updateable.default[1],
        ['Location'] = bios_fw_info_table_class_types.Location.default[1],
        ['Capability'] = bios_fw_info_table_class_types.Capability.default[1],
        ['State'] = bios_fw_info_table_class_types.State.default[1],
        ['ActiveMode'] = bios_fw_info_table_class_types.ActiveMode.default[1],
        ['ActiveModeSupported'] = bios_fw_info_table_class_types.ActiveModeSupported.default[1],
        ['ActiveModeEnabled'] = bios_fw_info_table_class_types.ActiveModeEnabled.default[1]
    }
}

local BiosBootOptionTable = {
    ['table_name'] = 't_bios_boot_option_info',
    ['prop_configs'] = {
        ['Id'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_boot_option_table_class_types.Id
        },
        ['ValidFlag'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_boot_option_table_class_types.ValidFlag
        },
        ['SetInProgress'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_boot_option_table_class_types.SetInProgress
        },
        ['ServicePartitionSelector'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_boot_option_table_class_types.ServicePartitionSelector
        },
        ['ServicePartitionScan'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_boot_option_table_class_types.ServicePartitionScan
        },
        ['BootFlagValidBitClearing'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_boot_option_table_class_types.BootFlagValidBitClearing
        },
        ['BootInfoAcknowledge'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_boot_option_table_class_types.BootInfoAcknowledge
        },
        ['BootFlags'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_boot_option_table_class_types.BootFlags
        },
        ['BootInitiatorInfo'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_boot_option_table_class_types.BootInitiatorInfo
        },
        ['BootInitiatorMailbox'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_boot_option_table_class_types.BootInitiatorMailbox
        },
        ['WriteProtect'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_boot_option_table_class_types.WriteProtect
        }
    },
    ['default_props'] = {
        ['Id'] = bios_boot_option_table_class_types.Id.default[1],
        ['ValidFlag'] = bios_boot_option_table_class_types.ValidFlag.default[1],
        ['SetInProgress'] = bios_boot_option_table_class_types.SetInProgress.default[1],
        ['ServicePartitionSelector'] = bios_boot_option_table_class_types.ServicePartitionSelector.default[1],
        ['ServicePartitionScan'] = bios_boot_option_table_class_types.ServicePartitionScan.default[1],
        ['BootFlagValidBitClearing'] = bios_boot_option_table_class_types.BootFlagValidBitClearing.default[1],
        ['BootInfoAcknowledge'] = bios_boot_option_table_class_types.BootInfoAcknowledge.default[1],
        ['BootFlags'] = bios_boot_option_table_class_types.BootFlags.default[1],
        ['BootInitiatorInfo'] = bios_boot_option_table_class_types.BootInitiatorInfo.default[1],
        ['BootInitiatorMailbox'] = bios_boot_option_table_class_types.BootInitiatorMailbox.default[1],
        ['WriteProtect'] = bios_boot_option_table_class_types.WriteProtect.default[1]
    }
}

local BiosBootTable = {
    ['table_name'] = 't_bios_boot_info',
    ['prop_configs'] = {
        ['Id'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_boot_table_class_types.Id
        },
        ['BootModeSupport'] = {
            ['baseType'] = 'Boolean',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_boot_table_class_types.BootModeSupport
        },
        ['BootModeIpmiSettable'] = {
            ['baseType'] = 'Boolean',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_boot_table_class_types.BootModeIpmiSettable
        },
        ['BootSourceOverrideMode'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_boot_table_class_types.BootSourceOverrideMode
        },
        ['BootSourceOverrideEnabled'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_boot_table_class_types.BootSourceOverrideEnabled
        },
        ['BootSourceOverrideTarget'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_boot_table_class_types.BootSourceOverrideTarget
        },
        ['BootOrder'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_boot_table_class_types.BootOrder
        },
        ['BootOptionPolicy'] = {
            ['baseType'] = 'U8',
            ['usage'] = {},
            ['validator'] = bios_boot_table_class_types.BootOptionPolicy
        },
        ['PreviousBootSourceOverrideTarget'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_boot_table_class_types.PreviousBootSourceOverrideTarget
        }
    },
    ['default_props'] = {
        ['Id'] = bios_boot_table_class_types.Id.default[1],
        ['BootModeSupport'] = bios_boot_table_class_types.BootModeSupport.default[1],
        ['BootModeIpmiSettable'] = bios_boot_table_class_types.BootModeIpmiSettable.default[1],
        ['BootSourceOverrideMode'] = bios_boot_table_class_types.BootSourceOverrideMode.default[1],
        ['BootSourceOverrideEnabled'] = bios_boot_table_class_types.BootSourceOverrideEnabled.default[1],
        ['BootSourceOverrideTarget'] = bios_boot_table_class_types.BootSourceOverrideTarget.default[1],
        ['BootOrder'] = bios_boot_table_class_types.BootOrder.default[1],
        ['BootOptionPolicy'] = bios_boot_table_class_types.BootOptionPolicy.default[1],
        ['PreviousBootSourceOverrideTarget'] = bios_boot_table_class_types.PreviousBootSourceOverrideTarget.default[1]
    }
}

local BiosInfoTable = {
    ['table_name'] = 't_bios_info',
    ['prop_configs'] = {
        ['Id'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_info_table_class_types.Id
        },
        ['Version'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_info_table_class_types.Version
        },
        ['BackupVersion'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_info_table_class_types.BackupVersion
        },
        ['OldSetupPassword'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['sensitive'] = true,
            ['validator'] = bios_info_table_class_types.OldSetupPassword
        },
        ['NewSetupPassword'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['sensitive'] = true,
            ['validator'] = bios_info_table_class_types.NewSetupPassword
        },
        ['UserOldSetupPassword'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['sensitive'] = true,
            ['validator'] = bios_info_table_class_types.UserOldSetupPassword
        },
        ['UserNewSetupPassword'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['sensitive'] = true,
            ['validator'] = bios_info_table_class_types.UserNewSetupPassword
        },
        ['UpgradeFailed'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_info_table_class_types.UpgradeFailed
        },
        ['RecoverFailed'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_info_table_class_types.RecoverFailed
        },
        ['BiosLogPrintEnabled'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_info_table_class_types.BiosLogPrintEnabled
        },
        ['RegistryVersion'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['default'] = 'V0.00',
            ['validator'] = bios_info_table_class_types.RegistryVersion
        },
        ['SystemStartupState'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'ResetPer'},
            ['default'] = 0,
            ['validator'] = bios_info_table_class_types.SystemStartupState
        },
        ['BiosBootStage'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'ResetPer'},
            ['default'] = 0,
            ['validator'] = bios_info_table_class_types.BiosBootStage
        },
        ['TeeOSVersion'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['default'] = '',
            ['validator'] = bios_info_table_class_types.TeeOSVersion
        },
        ['ResetBiosToDefaultsPending'] = {
            ['baseType'] = 'Boolean',
            ['usage'] = {'ResetPer'},
            ['default'] = false,
            ['validator'] = bios_info_table_class_types.ResetBiosToDefaultsPending
        }
    },
    ['default_props'] = {
        ['Id'] = bios_info_table_class_types.Id.default[1],
        ['Version'] = bios_info_table_class_types.Version.default[1],
        ['BackupVersion'] = bios_info_table_class_types.BackupVersion.default[1],
        ['OldSetupPassword'] = bios_info_table_class_types.OldSetupPassword.default[1],
        ['NewSetupPassword'] = bios_info_table_class_types.NewSetupPassword.default[1],
        ['UserOldSetupPassword'] = bios_info_table_class_types.UserOldSetupPassword.default[1],
        ['UserNewSetupPassword'] = bios_info_table_class_types.UserNewSetupPassword.default[1],
        ['UpgradeFailed'] = bios_info_table_class_types.UpgradeFailed.default[1],
        ['RecoverFailed'] = bios_info_table_class_types.RecoverFailed.default[1],
        ['BiosLogPrintEnabled'] = bios_info_table_class_types.BiosLogPrintEnabled.default[1],
        ['RegistryVersion'] = 'V0.00',
        ['SystemStartupState'] = 0,
        ['BiosBootStage'] = 0,
        ['TeeOSVersion'] = '',
        ['ResetBiosToDefaultsPending'] = false
    }
}

local BiosUpdateCfgTable = {
    ['table_name'] = 't_bios_cfg_info',
    ['prop_configs'] = {
        ['Id'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_update_cfg_table_class_types.Id
        },
        ['idex'] = {
            ['baseType'] = 'U32',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_update_cfg_table_class_types.idex
        },
        ['UpgradeFinishFlag'] = {
            ['baseType'] = 'Boolean',
            ['usage'] = {'PoweroffPer'},
            ['default'] = true,
            ['validator'] = bios_update_cfg_table_class_types.UpgradeFinishFlag
        },
        ['Version'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_update_cfg_table_class_types.Version
        },
        ['EffectiveFlag'] = {
            ['baseType'] = 'U32',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_update_cfg_table_class_types.EffectiveFlag
        },
        ['PackageType'] = {
            ['baseType'] = 'U32',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_update_cfg_table_class_types.PackageType
        },
        ['Period'] = {
            ['baseType'] = 'U32',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_update_cfg_table_class_types.Period
        },
        ['FirmwareEffectiveStatus'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_update_cfg_table_class_types.FirmwareEffectiveStatus
        },
        ['SlaveUpgrade'] = {
            ['baseType'] = 'Boolean',
            ['usage'] = {'ResetPer'},
            ['default'] = false,
            ['validator'] = bios_update_cfg_table_class_types.SlaveUpgrade
        }
    },
    ['default_props'] = {
        ['Id'] = bios_update_cfg_table_class_types.Id.default[1],
        ['idex'] = bios_update_cfg_table_class_types.idex.default[1],
        ['UpgradeFinishFlag'] = true,
        ['Version'] = bios_update_cfg_table_class_types.Version.default[1],
        ['EffectiveFlag'] = bios_update_cfg_table_class_types.EffectiveFlag.default[1],
        ['PackageType'] = bios_update_cfg_table_class_types.PackageType.default[1],
        ['Period'] = bios_update_cfg_table_class_types.Period.default[1],
        ['FirmwareEffectiveStatus'] = bios_update_cfg_table_class_types.FirmwareEffectiveStatus.default[1],
        ['SlaveUpgrade'] = false
    }
}

local SmBiosInfoTable = {
    ['table_name'] = 't_smbios_info',
    ['prop_configs'] = {
        ['Id'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = sm_bios_info_table_class_types.Id
        },
        ['Version'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = sm_bios_info_table_class_types.Version
        },
        ['SKUNumber'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = sm_bios_info_table_class_types.SKUNumber
        },
        ['Family'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = sm_bios_info_table_class_types.Family
        },
        ['SmBiosUpdatedFlag'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'ResetPer'},
            ['validator'] = sm_bios_info_table_class_types.SmBiosUpdatedFlag
        },
        ['SmBiosStatus'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'ResetPer'},
            ['default'] = 4,
            ['validator'] = sm_bios_info_table_class_types.SmBiosStatus
        }
    },
    ['default_props'] = {
        ['Id'] = sm_bios_info_table_class_types.Id.default[1],
        ['Version'] = sm_bios_info_table_class_types.Version.default[1],
        ['SKUNumber'] = sm_bios_info_table_class_types.SKUNumber.default[1],
        ['Family'] = sm_bios_info_table_class_types.Family.default[1],
        ['SmBiosUpdatedFlag'] = sm_bios_info_table_class_types.SmBiosUpdatedFlag.default[1],
        ['SmBiosStatus'] = 4
    }
}

local CertInfoTable = {
    ['table_name'] = 't_cert_info',
    ['prop_configs'] = {
        ['Id'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = cert_info_table_class_types.Id
        },
        ['CertificateExpired'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'PoweroffPer'},
            ['default'] = 0,
            ['validator'] = cert_info_table_class_types.CertificateExpired
        }
    },
    ['default_props'] = {['Id'] = cert_info_table_class_types.Id.default[1], ['CertificateExpired'] = 0}
}

local BiosConfigTable = {
    ['table_name'] = 't_bios_config_info',
    ['prop_configs'] = {
        ['Id'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = bios_config_table_class_types.Id
        },
        ['FileChangeFlag'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'PoweroffPer'},
            ['default'] = 0,
            ['validator'] = bios_config_table_class_types.FileChangeFlag
        },
        ['FileChannel'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'PoweroffPer'},
            ['default'] = 0,
            ['validator'] = bios_config_table_class_types.FileChannel
        },
        ['FileNum'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'PoweroffPer'},
            ['default'] = 0,
            ['validator'] = bios_config_table_class_types.FileNum
        }
    },
    ['default_props'] = {
        ['Id'] = bios_config_table_class_types.Id.default[1],
        ['FileChangeFlag'] = 0,
        ['FileChannel'] = 0,
        ['FileNum'] = 0
    }
}

local EventMsg = {
    ['table_name'] = 't_event_msg',
    ['prop_configs'] = {
        ['Id'] = {['primaryKey'] = true, ['baseType'] = 'String', ['validator'] = event_msg_class_types.Id},
        ['ComponentName'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'String',
            ['validator'] = event_msg_class_types.ComponentName
        },
        ['State'] = {['notAllowNull'] = true, ['baseType'] = 'String', ['validator'] = event_msg_class_types.State},
        ['EventKeyId'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'String',
            ['validator'] = event_msg_class_types.EventKeyId
        },
        ['MessageArgs'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'String',
            ['validator'] = event_msg_class_types.MessageArgs
        },
        ['SystemId'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'String',
            ['validator'] = event_msg_class_types.SystemId
        },
        ['ManagerId'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'String',
            ['validator'] = event_msg_class_types.ManagerId
        },
        ['ChassisId'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'String',
            ['validator'] = event_msg_class_types.ChassisId
        },
        ['NodeId'] = {['notAllowNull'] = true, ['baseType'] = 'String', ['validator'] = event_msg_class_types.NodeId},
        ['SubjectType'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'String',
            ['validator'] = event_msg_class_types.SubjectType
        }
    },
    ['default_props'] = {
        ['Id'] = event_msg_class_types.Id.default[1],
        ['ComponentName'] = event_msg_class_types.ComponentName.default[1],
        ['State'] = event_msg_class_types.State.default[1],
        ['EventKeyId'] = event_msg_class_types.EventKeyId.default[1],
        ['MessageArgs'] = event_msg_class_types.MessageArgs.default[1],
        ['SystemId'] = event_msg_class_types.SystemId.default[1],
        ['ManagerId'] = event_msg_class_types.ManagerId.default[1],
        ['ChassisId'] = event_msg_class_types.ChassisId.default[1],
        ['NodeId'] = event_msg_class_types.NodeId.default[1],
        ['SubjectType'] = event_msg_class_types.SubjectType.default[1]
    }
}

local BiosUpgradeService = {
    ['prop_configs'] = {},
    ['default_props'] = {},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.BiosUpgradeService'] = {
            ['ActivatedStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['enum'] = {0, 1, 2},
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = bios_upgrade_service_intf_types.ActivatedStatus
            },
            ['FirmwareEffectiveStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 3,
                ['enum'] = {1, 2, 3},
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = bios_upgrade_service_intf_types.FirmwareEffectiveStatus
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.BiosUpgradeService'] = {
            ['ActivateFirmware'] = {
                ['req'] = {{['baseType'] = 'String[]', ['param'] = 'DatabseType'}},
                ['rsp'] = {},
                ['privilege'] = {'BasicSetting'}
            },
            ['ExportBiosFirmware'] = {
                ['req'] = {},
                ['rsp'] = {{['baseType'] = 'U32', ['param'] = 'TaskId'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['GetFirmwareInfo'] = {['req'] = {}, ['rsp'] = {{['baseType'] = 'String', ['param'] = 'FirmwareInfo'}}}
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/BiosUpgradeService'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.BiosUpgradeService'] = {
            ['property_defaults'] = {['ActivatedStatus'] = 0, ['FirmwareEffectiveStatus'] = 3},
            ['privileges'] = {
                ['path'] = privilege.ConfigureSelf,
                ['methods'] = {
                    ['ActivateFirmware'] = privilege.BasicSetting,
                    ['ExportBiosFirmware'] = privilege.BasicSetting
                }
            },
            ['interface_types'] = bios_upgrade_service_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = properties_intf_types
        }
    })
}

local CachedBiosUpgradeTable = {
    ['table_name'] = 't_cached_bios_upgrade_info',
    ['prop_configs'] = {
        ['Id'] = {['baseType'] = 'U8', ['primaryKey'] = true, ['validator'] = cached_bios_upgrade_table_class_types.Id},
        ['CachedBiosUpgradeMode'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = cached_bios_upgrade_table_class_types.CachedBiosUpgradeMode
        },
        ['BiosActiveCondition'] = {
            ['baseType'] = 'String',
            ['default'] = 'PowerOff',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = cached_bios_upgrade_table_class_types.BiosActiveCondition
        }
    },
    ['default_props'] = {
        ['Id'] = cached_bios_upgrade_table_class_types.Id.default[1],
        ['CachedBiosUpgradeMode'] = 0,
        ['BiosActiveCondition'] = 'PowerOff'
    }
}

local TeeOSFwInfoTable = {
    ['table_name'] = 't_teeos_fw_info',
    ['prop_configs'] = {
        ['Id'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['default'] = 'TeeOS',
            ['validator'] = tee_os_fw_info_table_class_types.Id
        },
        ['Name'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['default'] = 'TeeOS',
            ['validator'] = tee_os_fw_info_table_class_types.Name
        },
        ['Version'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['default'] = '0.00',
            ['validator'] = tee_os_fw_info_table_class_types.Version
        },
        ['BuildNum'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['default'] = '',
            ['validator'] = tee_os_fw_info_table_class_types.BuildNum
        },
        ['ReleaseDate'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['default'] = '',
            ['validator'] = tee_os_fw_info_table_class_types.ReleaseDate
        },
        ['LowestSupportedVersion'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['default'] = '',
            ['validator'] = tee_os_fw_info_table_class_types.LowestSupportedVersion
        },
        ['SoftwareId'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['default'] = 'TeeOS-TeeOS',
            ['validator'] = tee_os_fw_info_table_class_types.SoftwareId
        },
        ['Manufacturer'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['default'] = 'Huawei',
            ['validator'] = tee_os_fw_info_table_class_types.Manufacturer
        },
        ['Updateable'] = {
            ['baseType'] = 'Boolean',
            ['usage'] = {'PoweroffPer'},
            ['default'] = true,
            ['validator'] = tee_os_fw_info_table_class_types.Updateable
        },
        ['Location'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['default'] = 'U75',
            ['validator'] = tee_os_fw_info_table_class_types.Location
        },
        ['Capability'] = {
            ['baseType'] = 'U16',
            ['usage'] = {'PoweroffPer'},
            ['default'] = 5,
            ['validator'] = tee_os_fw_info_table_class_types.Capability
        },
        ['State'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['default'] = 'Enabled',
            ['validator'] = tee_os_fw_info_table_class_types.State
        },
        ['ActiveMode'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['default'] = '',
            ['validator'] = tee_os_fw_info_table_class_types.ActiveMode
        },
        ['ActiveModeSupported'] = {
            ['baseType'] = 'Boolean',
            ['usage'] = {'PoweroffPer'},
            ['default'] = true,
            ['validator'] = tee_os_fw_info_table_class_types.ActiveModeSupported
        },
        ['ActiveModeEnabled'] = {
            ['baseType'] = 'Boolean',
            ['usage'] = {'PoweroffPer'},
            ['default'] = true,
            ['validator'] = tee_os_fw_info_table_class_types.ActiveModeEnabled
        }
    },
    ['default_props'] = {
        ['Id'] = 'TeeOS',
        ['Name'] = 'TeeOS',
        ['Version'] = '0.00',
        ['BuildNum'] = '',
        ['ReleaseDate'] = '',
        ['LowestSupportedVersion'] = '',
        ['SoftwareId'] = 'TeeOS-TeeOS',
        ['Manufacturer'] = 'Huawei',
        ['Updateable'] = true,
        ['Location'] = 'U75',
        ['Capability'] = 5,
        ['State'] = 'Enabled',
        ['ActiveMode'] = '',
        ['ActiveModeSupported'] = true,
        ['ActiveModeEnabled'] = true
    }
}

local SystemFirmwareProgress = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.SystemFirmwareProgress.Status'] = {
            ['KBCError'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR'},
                ['validator'] = system_firmware_progress_status_intf_types.KBCError
            },
            ['VideoError'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR'},
                ['validator'] = system_firmware_progress_status_intf_types.VideoError
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/SystemFirmwareProgress'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.SystemFirmwareProgress.Status'] = {
            ['property_defaults'] = {
                ['KBCError'] = system_firmware_progress_status_intf_types.KBCError.default[1],
                ['VideoError'] = system_firmware_progress_status_intf_types.VideoError.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = system_firmware_progress_status_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = properties_intf_types
        }
    })
}

local BIOSIPMIChannelConfig = {
    ['prop_configs'] = {
        ['Maps'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Array',
            ['items'] = {['baseType'] = 'Struct', ['$ref'] = 'types.json#/defs/IPMIChannelConfig'},
            ['validator'] = biosipmi_channel_config_class_types.Maps
        }
    },
    ['default_props'] = {['Maps'] = biosipmi_channel_config_class_types.Maps.default[1]}
}

local SPIRate = {
    ['prop_configs'] = {
        ['Rate'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = spi_rate_class_types.Rate
        }
    },
    ['default_props'] = {['Rate'] = 0}
}

local BIOSMultihostConfig = {
    ['prop_configs'] = {
        ['Maps'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Array',
            ['items'] = {['baseType'] = 'Struct', ['$ref'] = 'types.json#/defs/MultihostConfig'},
            ['validator'] = bios_multihost_config_class_types.Maps
        }
    },
    ['default_props'] = {['Maps'] = bios_multihost_config_class_types.Maps.default[1]}
}

local CPUDie = {
    ['prop_configs'] = {
        ['IdRange'] = {['baseType'] = 'U8[]', ['usage'] = {'CSR'}, ['validator'] = cpu_die_class_types.IdRange},
        ['NameRange'] = {['baseType'] = 'String[]', ['usage'] = {'CSR'}, ['validator'] = cpu_die_class_types.NameRange}
    },
    ['default_props'] = {
        ['IdRange'] = cpu_die_class_types.IdRange.default[1],
        ['NameRange'] = cpu_die_class_types.NameRange.default[1]
    }
}

local BiosFirmwareCustomConfig = {
    ['prop_configs'] = {
        ['CMSSignEnable'] = {
            ['baseType'] = 'Boolean',
            ['default'] = true,
            ['usage'] = {'CSR'},
            ['validator'] = bios_firmware_custom_config_class_types.CMSSignEnable
        }
    },
    ['default_props'] = {['CMSSignEnable'] = true}
}

local MemorySilk = {
    ['prop_configs'] = {
        ['DimmName'] = {['baseType'] = 'String', ['usage'] = {'CSR'}, ['validator'] = memory_silk_class_types.DimmName},
        ['CpuId'] = {['baseType'] = 'U8', ['usage'] = {'CSR'}, ['validator'] = memory_silk_class_types.CpuId},
        ['ChannelId'] = {['baseType'] = 'U8', ['usage'] = {'CSR'}, ['validator'] = memory_silk_class_types.ChannelId},
        ['LogicalChannelId'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['validator'] = memory_silk_class_types.LogicalChannelId
        },
        ['DimmId'] = {['baseType'] = 'U8', ['usage'] = {'CSR'}, ['validator'] = memory_silk_class_types.DimmId}
    },
    ['default_props'] = {
        ['DimmName'] = memory_silk_class_types.DimmName.default[1],
        ['CpuId'] = memory_silk_class_types.CpuId.default[1],
        ['ChannelId'] = memory_silk_class_types.ChannelId.default[1],
        ['LogicalChannelId'] = memory_silk_class_types.LogicalChannelId.default[1],
        ['DimmId'] = memory_silk_class_types.DimmId.default[1]
    }
}

local AllowedBiosUpgradeTable = {
    ['table_name'] = 't_allowed_bios_upgrade_info',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['default'] = 1,
            ['validator'] = allowed_bios_upgrade_table_class_types.Id
        },
        ['PackageStatus'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = allowed_bios_upgrade_table_class_types.PackageStatus
        },
        ['AllowedPackageType'] = {
            ['baseType'] = 'U8',
            ['validator'] = allowed_bios_upgrade_table_class_types.AllowedPackageType
        }
    },
    ['default_props'] = {
        ['Id'] = 1,
        ['PackageStatus'] = 0,
        ['AllowedPackageType'] = allowed_bios_upgrade_table_class_types.AllowedPackageType.default[1]
    }
}

local BaseOSBoot = {
    ['table_name'] = 't_base_os_boot',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['primaryKey'] = true,
            ['usage'] = {'CSR'},
            ['validator'] = base_os_boot_class_types.Id
        }
    },
    ['default_props'] = {['Id'] = 1},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.IPMIEvent'] = {
            ['SensorType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['default'] = 31,
                ['validator'] = ipmi_event_intf_types.SensorType
            },
            ['ReadingType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR', 'ResetPer'},
                ['default'] = 111,
                ['validator'] = ipmi_event_intf_types.ReadingType
            },
            ['EventData'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'ResetPer'},
                ['default'] = 4294967295,
                ['validator'] = ipmi_event_intf_types.EventData
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/EventEntries/BaseOSBoot'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.IPMIEvent'] = {
            ['property_defaults'] = {['SensorType'] = 31, ['ReadingType'] = 111, ['EventData'] = 4294967295},
            ['interface_types'] = ipmi_event_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['interface_types'] = properties_intf_types
        }
    })
}

local SystemInfoTable = {
    ['table_name'] = 't_system_info',
    ['prop_configs'] = {
        ['SystemId'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['validator'] = system_info_table_class_types.SystemId
        },
        ['SystemFirmwareVersion'] = {
            ['baseType'] = 'String',
            ['validator'] = system_info_table_class_types.SystemFirmwareVersion
        },
        ['SystemName'] = {['baseType'] = 'String', ['validator'] = system_info_table_class_types.SystemName},
        ['PrimaryOperatingSystemName'] = {
            ['baseType'] = 'String',
            ['validator'] = system_info_table_class_types.PrimaryOperatingSystemName
        },
        ['OperatingSystemName'] = {
            ['baseType'] = 'String',
            ['validator'] = system_info_table_class_types.OperatingSystemName
        },
        ['PresentOSVersionNumber'] = {
            ['baseType'] = 'String',
            ['validator'] = system_info_table_class_types.PresentOSVersionNumber
        },
        ['BMCUrl'] = {['baseType'] = 'String', ['validator'] = system_info_table_class_types.BMCUrl},
        ['BaseOsUrlForManageability'] = {
            ['baseType'] = 'String',
            ['validator'] = system_info_table_class_types.BaseOsUrlForManageability
        }
    },
    ['default_props'] = {
        ['SystemId'] = system_info_table_class_types.SystemId.default[1],
        ['SystemFirmwareVersion'] = system_info_table_class_types.SystemFirmwareVersion.default[1],
        ['SystemName'] = system_info_table_class_types.SystemName.default[1],
        ['PrimaryOperatingSystemName'] = system_info_table_class_types.PrimaryOperatingSystemName.default[1],
        ['OperatingSystemName'] = system_info_table_class_types.OperatingSystemName.default[1],
        ['PresentOSVersionNumber'] = system_info_table_class_types.PresentOSVersionNumber.default[1],
        ['BMCUrl'] = system_info_table_class_types.BMCUrl.default[1],
        ['BaseOsUrlForManageability'] = system_info_table_class_types.BaseOsUrlForManageability.default[1]
    }
}

local M = {}

function M.init(bus)
    class('Bios', Bios):set_bus(bus)
    class('SmBios', SmBios):set_bus(bus)
    class('SPIChannel', SPIChannel):set_bus(bus)
    class('BootOptions', BootOptions):set_bus(bus)
    class('SecureBootOptions', SecureBootOptions):set_bus(bus)
    class('BiosFwInfoTable', BiosFwInfoTable):set_bus(bus)
    class('BiosBootOptionTable', BiosBootOptionTable):set_bus(bus)
    class('BiosBootTable', BiosBootTable):set_bus(bus)
    class('BiosInfoTable', BiosInfoTable):set_bus(bus)
    class('BiosUpdateCfgTable', BiosUpdateCfgTable):set_bus(bus)
    class('SmBiosInfoTable', SmBiosInfoTable):set_bus(bus)
    class('CertInfoTable', CertInfoTable):set_bus(bus)
    class('BiosConfigTable', BiosConfigTable):set_bus(bus)
    class('EventMsg', EventMsg):set_bus(bus)
    class('BiosUpgradeService', BiosUpgradeService):set_bus(bus)
    class('CachedBiosUpgradeTable', CachedBiosUpgradeTable):set_bus(bus)
    class('TeeOSFwInfoTable', TeeOSFwInfoTable):set_bus(bus)
    class('SystemFirmwareProgress', SystemFirmwareProgress):set_bus(bus)
    class('BIOSIPMIChannelConfig', BIOSIPMIChannelConfig):set_bus(bus)
    class('SPIRate', SPIRate):set_bus(bus)
    class('BIOSMultihostConfig', BIOSMultihostConfig):set_bus(bus)
    class('CPUDie', CPUDie):set_bus(bus)
    class('BiosFirmwareCustomConfig', BiosFirmwareCustomConfig):set_bus(bus)
    class('MemorySilk', MemorySilk):set_bus(bus)
    class('AllowedBiosUpgradeTable', AllowedBiosUpgradeTable):set_bus(bus)
    class('BaseOSBoot', BaseOSBoot):set_bus(bus)
    class('SystemInfoTable', SystemInfoTable):set_bus(bus)
end

-- The callback needs to be registered during app initialization
function M.ImplBiosBiosClearCmos(cb)
    class('Bios')['bmc.kepler.Systems.Bios'].ClearCmos = function(obj, ctx, ...)
        local req = bios_intf_types.ClearCmosReq.new(...):validate(nil, nil, true)
        local rsp = bios_intf_types.ClearCmosRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBiosBiosResetSetupConfig(cb)
    class('Bios')['bmc.kepler.Systems.Bios'].ResetSetupConfig = function(obj, ctx, ...)
        local req = bios_intf_types.ResetSetupConfigReq.new(...):validate(nil, nil, true)
        local rsp = bios_intf_types.ResetSetupConfigRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBiosBiosChangePassword(cb)
    class('Bios')['bmc.kepler.Systems.Bios'].ChangePassword = function(obj, ctx, ...)
        local req = bios_intf_types.ChangePasswordReq.new(...):validate(nil, nil, true)
        local rsp = bios_intf_types.ChangePasswordRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBiosBiosImportBiosSetup(cb)
    class('Bios')['bmc.kepler.Systems.Bios'].ImportBiosSetup = function(obj, ctx, ...)
        local req = bios_intf_types.ImportBiosSetupReq.new(...):validate(nil, nil, true)
        local rsp = bios_intf_types.ImportBiosSetupRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBiosBiosGetCurrentValueSetting(cb)
    class('Bios')['bmc.kepler.Systems.Bios'].GetCurrentValueSetting = function(obj, ctx, ...)
        local req = bios_intf_types.GetCurrentValueSettingReq.new(...):validate(nil, nil, true)
        local rsp = bios_intf_types.GetCurrentValueSettingRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBiosBiosRemoveCachedSettings(cb)
    class('Bios')['bmc.kepler.Systems.Bios'].RemoveCachedSettings = function(obj, ctx, ...)
        local req = bios_intf_types.RemoveCachedSettingsReq.new(...):validate(nil, nil, true)
        local rsp = bios_intf_types.RemoveCachedSettingsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBiosBiosExportFirmware(cb)
    class('Bios')['bmc.kepler.Systems.Bios'].ExportFirmware = function(obj, ctx, ...)
        local req = bios_intf_types.ExportFirmwareReq.new(...):validate(nil, nil, true)
        local rsp = bios_intf_types.ExportFirmwareRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBiosBiosSetBiosConfigActiveMode(cb)
    class('Bios')['bmc.kepler.Systems.Bios'].SetBiosConfigActiveMode = function(obj, ctx, ...)
        local req = bios_intf_types.SetBiosConfigActiveModeReq.new(...):validate(nil, nil, true)
        local rsp = bios_intf_types.SetBiosConfigActiveModeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBiosBiosSetBiosLogEnabled(cb)
    class('Bios')['bmc.kepler.Systems.Bios'].SetBiosLogEnabled = function(obj, ctx, ...)
        local req = bios_intf_types.SetBiosLogEnabledReq.new(...):validate(nil, nil, true)
        local rsp = bios_intf_types.SetBiosLogEnabledRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBiosBiosExportBiosSetup(cb)
    class('Bios')['bmc.kepler.Systems.Bios'].ExportBiosSetup = function(obj, ctx, ...)
        local req = bios_intf_types.ExportBiosSetupReq.new(...):validate(nil, nil, true)
        local rsp = bios_intf_types.ExportBiosSetupRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBiosRetirementDataWipe(cb)
    class('Bios')['bmc.kepler.LifeCycle.Retirement'].DataWipe = function(obj, ctx, ...)
        local req = retirement_intf_types.DataWipeReq.new(...):validate(nil, nil, true)
        local rsp = retirement_intf_types.DataWipeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBiosRetirementGetReport(cb)
    class('Bios')['bmc.kepler.LifeCycle.Retirement'].GetReport = function(obj, ctx, ...)
        local req = retirement_intf_types.GetReportReq.new(...):validate(nil, nil, true)
        local rsp = retirement_intf_types.GetReportRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBootOptionsBootOptionsShieldIpmiModifyBootModeSupport(cb)
    class('BootOptions')['bmc.kepler.Systems.BootOptions'].ShieldIpmiModifyBootModeSupport = function(obj, ctx, ...)
        local req = boot_options_intf_types.ShieldIpmiModifyBootModeSupportReq.new(...):validate(nil, nil, true)
        local rsp =
            boot_options_intf_types.ShieldIpmiModifyBootModeSupportRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBootOptionsBootOptionsImportCertificate(cb)
    class('BootOptions')['bmc.kepler.Systems.BootOptions'].ImportCertificate = function(obj, ctx, ...)
        local req = boot_options_intf_types.ImportCertificateReq.new(...):validate(nil, nil, true)
        local rsp = boot_options_intf_types.ImportCertificateRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBootOptionsBootOptionsImportCrl(cb)
    class('BootOptions')['bmc.kepler.Systems.BootOptions'].ImportCrl = function(obj, ctx, ...)
        local req = boot_options_intf_types.ImportCrlReq.new(...):validate(nil, nil, true)
        local rsp = boot_options_intf_types.ImportCrlRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBootOptionsBootOptionsResetCrl(cb)
    class('BootOptions')['bmc.kepler.Systems.BootOptions'].ResetCrl = function(obj, ctx, ...)
        local req = boot_options_intf_types.ResetCrlReq.new(...):validate(nil, nil, true)
        local rsp = boot_options_intf_types.ResetCrlRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBootOptionsBootOptionsResetCertificate(cb)
    class('BootOptions')['bmc.kepler.Systems.BootOptions'].ResetCertificate = function(obj, ctx, ...)
        local req = boot_options_intf_types.ResetCertificateReq.new(...):validate(nil, nil, true)
        local rsp = boot_options_intf_types.ResetCertificateRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBootOptionsBootOptionsSetBootOrder(cb)
    class('BootOptions')['bmc.kepler.Systems.BootOptions'].SetBootOrder = function(obj, ctx, ...)
        local req = boot_options_intf_types.SetBootOrderReq.new(...):validate(nil, nil, true)
        local rsp = boot_options_intf_types.SetBootOrderRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBootOptionsBootOptionsSetStartOption(cb)
    class('BootOptions')['bmc.kepler.Systems.BootOptions'].SetStartOption = function(obj, ctx, ...)
        local req = boot_options_intf_types.SetStartOptionReq.new(...):validate(nil, nil, true)
        local rsp = boot_options_intf_types.SetStartOptionRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBootOptionsBootOptionsSetStartOptionFlag(cb)
    class('BootOptions')['bmc.kepler.Systems.BootOptions'].SetStartOptionFlag = function(obj, ctx, ...)
        local req = boot_options_intf_types.SetStartOptionFlagReq.new(...):validate(nil, nil, true)
        local rsp = boot_options_intf_types.SetStartOptionFlagRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBootOptionsBootOptionsSetBootMode(cb)
    class('BootOptions')['bmc.kepler.Systems.BootOptions'].SetBootMode = function(obj, ctx, ...)
        local req = boot_options_intf_types.SetBootModeReq.new(...):validate(nil, nil, true)
        local rsp = boot_options_intf_types.SetBootModeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBootOptionsBootOptionsGetCertificate(cb)
    class('BootOptions')['bmc.kepler.Systems.BootOptions'].GetCertificate = function(obj, ctx, ...)
        local req = boot_options_intf_types.GetCertificateReq.new(...):validate(nil, nil, true)
        local rsp = boot_options_intf_types.GetCertificateRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSecureBootOptionsSecureBootOptionsImportCertificate(cb)
    class('SecureBootOptions')['bmc.kepler.Systems.SecureBootOptions'].ImportCertificate = function(obj, ctx, ...)
        local req = secure_boot_options_intf_types.ImportCertificateReq.new(...):validate(nil, nil, true)
        local rsp = secure_boot_options_intf_types.ImportCertificateRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSecureBootOptionsSecureBootOptionsResetCertificate(cb)
    class('SecureBootOptions')['bmc.kepler.Systems.SecureBootOptions'].ResetCertificate = function(obj, ctx, ...)
        local req = secure_boot_options_intf_types.ResetCertificateReq.new(...):validate(nil, nil, true)
        local rsp = secure_boot_options_intf_types.ResetCertificateRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSecureBootOptionsSecureBootOptionsGetCertificate(cb)
    class('SecureBootOptions')['bmc.kepler.Systems.SecureBootOptions'].GetCertificate = function(obj, ctx, ...)
        local req = secure_boot_options_intf_types.GetCertificateReq.new(...):validate(nil, nil, true)
        local rsp = secure_boot_options_intf_types.GetCertificateRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBiosUpgradeServiceBiosUpgradeServiceActivateFirmware(cb)
    class('BiosUpgradeService')['bmc.kepler.Systems.BiosUpgradeService'].ActivateFirmware = function(obj, ctx, ...)
        local req = bios_upgrade_service_intf_types.ActivateFirmwareReq.new(...):validate(nil, nil, true)
        local rsp = bios_upgrade_service_intf_types.ActivateFirmwareRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBiosUpgradeServiceBiosUpgradeServiceExportBiosFirmware(cb)
    class('BiosUpgradeService')['bmc.kepler.Systems.BiosUpgradeService'].ExportBiosFirmware = function(obj, ctx, ...)
        local req = bios_upgrade_service_intf_types.ExportBiosFirmwareReq.new(...):validate(nil, nil, true)
        local rsp = bios_upgrade_service_intf_types.ExportBiosFirmwareRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBiosUpgradeServiceBiosUpgradeServiceGetFirmwareInfo(cb)
    class('BiosUpgradeService')['bmc.kepler.Systems.BiosUpgradeService'].GetFirmwareInfo = function(obj, ctx, ...)
        local req = bios_upgrade_service_intf_types.GetFirmwareInfoReq.new(...):validate(nil, nil, true)
        local rsp = bios_upgrade_service_intf_types.GetFirmwareInfoRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

return M
