-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Ums = {}

---@class Ums.Enabled
---@field Enabled boolean
local TEnabled = {}
TEnabled.__index = TEnabled
TEnabled.group = {}

local function TEnabled_from_obj(obj)
    return setmetatable(obj, TEnabled)
end

function TEnabled.new(Enabled)
    return TEnabled_from_obj({Enabled = Enabled})
end
---@param obj Ums.Enabled
function TEnabled:init_from_obj(obj)
    self.Enabled = obj.Enabled
end

function TEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnabled.group)
end

TEnabled.from_obj = TEnabled_from_obj

TEnabled.proto_property = {'Enabled'}

TEnabled.default = {false}

TEnabled.struct = {{name = 'Enabled', is_array = false, struct = nil}}

function TEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Enabled', self.Enabled, 'bool', false, errs, need_convert)

    TEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnabled.proto_property, errs, need_convert)
    return self
end

function TEnabled:unpack(_)
    return self.Enabled
end

Ums.Enabled = TEnabled

---@class Ums.ConnectState
---@field ConnectState integer
local TConnectState = {}
TConnectState.__index = TConnectState
TConnectState.group = {}

local function TConnectState_from_obj(obj)
    return setmetatable(obj, TConnectState)
end

function TConnectState.new(ConnectState)
    return TConnectState_from_obj({ConnectState = ConnectState})
end
---@param obj Ums.ConnectState
function TConnectState:init_from_obj(obj)
    self.ConnectState = obj.ConnectState
end

function TConnectState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConnectState.group)
end

TConnectState.from_obj = TConnectState_from_obj

TConnectState.proto_property = {'ConnectState'}

TConnectState.default = {0}

TConnectState.struct = {{name = 'ConnectState', is_array = false, struct = nil}}

function TConnectState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ConnectState', self.ConnectState, 'uint32', true, errs, need_convert)

    TConnectState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConnectState.proto_property, errs, need_convert)
    return self
end

function TConnectState:unpack(_)
    return self.ConnectState
end

Ums.ConnectState = TConnectState

---@class Ums.DisconnectRsp
local TDisconnectRsp = {}
TDisconnectRsp.__index = TDisconnectRsp
TDisconnectRsp.group = {}

local function TDisconnectRsp_from_obj(obj)
    return setmetatable(obj, TDisconnectRsp)
end

function TDisconnectRsp.new()
    return TDisconnectRsp_from_obj({})
end
---@param obj Ums.DisconnectRsp
function TDisconnectRsp:init_from_obj(obj)

end

function TDisconnectRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDisconnectRsp.group)
end

TDisconnectRsp.from_obj = TDisconnectRsp_from_obj

TDisconnectRsp.proto_property = {}

TDisconnectRsp.default = {}

TDisconnectRsp.struct = {}

function TDisconnectRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDisconnectRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDisconnectRsp.proto_property, errs, need_convert)
    return self
end

function TDisconnectRsp:unpack(_)
end

Ums.DisconnectRsp = TDisconnectRsp

---@class Ums.DisconnectReq
local TDisconnectReq = {}
TDisconnectReq.__index = TDisconnectReq
TDisconnectReq.group = {}

local function TDisconnectReq_from_obj(obj)
    return setmetatable(obj, TDisconnectReq)
end

function TDisconnectReq.new()
    return TDisconnectReq_from_obj({})
end
---@param obj Ums.DisconnectReq
function TDisconnectReq:init_from_obj(obj)

end

function TDisconnectReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDisconnectReq.group)
end

TDisconnectReq.from_obj = TDisconnectReq_from_obj

TDisconnectReq.proto_property = {}

TDisconnectReq.default = {}

TDisconnectReq.struct = {}

function TDisconnectReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDisconnectReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDisconnectReq.proto_property, errs, need_convert)
    return self
end

function TDisconnectReq:unpack(_)
end

Ums.DisconnectReq = TDisconnectReq

---@class Ums.ConnectRsp
---@field UsbId integer
---@field FuncId integer
local TConnectRsp = {}
TConnectRsp.__index = TConnectRsp
TConnectRsp.group = {}

local function TConnectRsp_from_obj(obj)
    return setmetatable(obj, TConnectRsp)
end

function TConnectRsp.new(UsbId, FuncId)
    return TConnectRsp_from_obj({UsbId = UsbId, FuncId = FuncId})
end
---@param obj Ums.ConnectRsp
function TConnectRsp:init_from_obj(obj)
    self.UsbId = obj.UsbId
    self.FuncId = obj.FuncId
end

function TConnectRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConnectRsp.group)
end

TConnectRsp.from_obj = TConnectRsp_from_obj

TConnectRsp.proto_property = {'UsbId', 'FuncId'}

TConnectRsp.default = {0, 0}

TConnectRsp.struct = {
    {name = 'UsbId', is_array = false, struct = nil}, {name = 'FuncId', is_array = false, struct = nil}
}

function TConnectRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UsbId', self.UsbId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'FuncId', self.FuncId, 'uint32', false, errs, need_convert)

    TConnectRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConnectRsp.proto_property, errs, need_convert)
    return self
end

function TConnectRsp:unpack(_)
    return self.UsbId, self.FuncId
end

Ums.ConnectRsp = TConnectRsp

---@class Ums.ConnectReq
---@field FlashDev string
local TConnectReq = {}
TConnectReq.__index = TConnectReq
TConnectReq.group = {}

local function TConnectReq_from_obj(obj)
    return setmetatable(obj, TConnectReq)
end

function TConnectReq.new(FlashDev)
    return TConnectReq_from_obj({FlashDev = FlashDev})
end
---@param obj Ums.ConnectReq
function TConnectReq:init_from_obj(obj)
    self.FlashDev = obj.FlashDev
end

function TConnectReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConnectReq.group)
end

TConnectReq.from_obj = TConnectReq_from_obj

TConnectReq.proto_property = {'FlashDev'}

TConnectReq.default = {''}

TConnectReq.struct = {{name = 'FlashDev', is_array = false, struct = nil}}

function TConnectReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FlashDev', self.FlashDev, 'string', false, errs, need_convert)

    TConnectReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConnectReq.proto_property, errs, need_convert)
    return self
end

function TConnectReq:unpack(_)
    return self.FlashDev
end

Ums.ConnectReq = TConnectReq

Ums.interface = mdb.register_interface('bmc.kepler.Managers.UsbDevice.Ums', {
    ConnectState = {'u', nil, true, nil, false},
    Enabled = {'b', nil, false, nil, false}
}, {Connect = {'a{ss}s', 'uu', TConnectReq, TConnectRsp}, Disconnect = {'a{ss}', '', TDisconnectReq, TDisconnectRsp}},
    {})

return Ums
