-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'
local create_enum_type = require 'mc.enum'

local SystemControl = {}

---@class SystemControl.LockCause: Enum
local ELockCause = create_enum_type('LockCause')
ELockCause.default = ELockCause.new('')
ELockCause.struct = nil
ELockCause.Default = ELockCause.new('The current status does not support the reset operation')
ELockCause.BiosDuringPost = ELockCause.new('BIOS POST stage does not support the reset operation')

SystemControl.LockCause = ELockCause

---@class SystemControl.ResetLockStatus
---@field ResetLockStatus string
local TResetLockStatus = {}
TResetLockStatus.__index = TResetLockStatus
TResetLockStatus.group = {}

local function TResetLockStatus_from_obj(obj)
    return setmetatable(obj, TResetLockStatus)
end

function TResetLockStatus.new(ResetLockStatus)
    return TResetLockStatus_from_obj({ResetLockStatus = ResetLockStatus})
end
---@param obj SystemControl.ResetLockStatus
function TResetLockStatus:init_from_obj(obj)
    self.ResetLockStatus = obj.ResetLockStatus
end

function TResetLockStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetLockStatus.group)
end

TResetLockStatus.from_obj = TResetLockStatus_from_obj

TResetLockStatus.proto_property = {'ResetLockStatus'}

TResetLockStatus.default = {''}

TResetLockStatus.struct = {{name = 'ResetLockStatus', is_array = false, struct = nil}}

function TResetLockStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResetLockStatus', self.ResetLockStatus, 'string', true, errs, need_convert)

    TResetLockStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetLockStatus.proto_property, errs, need_convert)
    return self
end

function TResetLockStatus:unpack(_)
    return self.ResetLockStatus
end

SystemControl.ResetLockStatus = TResetLockStatus

---@class SystemControl.SetResetLockStatusRsp
local TSetResetLockStatusRsp = {}
TSetResetLockStatusRsp.__index = TSetResetLockStatusRsp
TSetResetLockStatusRsp.group = {}

local function TSetResetLockStatusRsp_from_obj(obj)
    return setmetatable(obj, TSetResetLockStatusRsp)
end

function TSetResetLockStatusRsp.new()
    return TSetResetLockStatusRsp_from_obj({})
end
---@param obj SystemControl.SetResetLockStatusRsp
function TSetResetLockStatusRsp:init_from_obj(obj)

end

function TSetResetLockStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetResetLockStatusRsp.group)
end

TSetResetLockStatusRsp.from_obj = TSetResetLockStatusRsp_from_obj

TSetResetLockStatusRsp.proto_property = {}

TSetResetLockStatusRsp.default = {}

TSetResetLockStatusRsp.struct = {}

function TSetResetLockStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetResetLockStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetResetLockStatusRsp.proto_property, errs, need_convert)
    return self
end

function TSetResetLockStatusRsp:unpack(_)
end

SystemControl.SetResetLockStatusRsp = TSetResetLockStatusRsp

---@class SystemControl.SetResetLockStatusReq
---@field ResetMode string
---@field OperationType string
---@field TimeoutSeconds integer
---@field LockCause SystemControl.LockCause
local TSetResetLockStatusReq = {}
TSetResetLockStatusReq.__index = TSetResetLockStatusReq
TSetResetLockStatusReq.group = {}

local function TSetResetLockStatusReq_from_obj(obj)
    obj.LockCause = obj.LockCause and SystemControl.LockCause.new(obj.LockCause)
    return setmetatable(obj, TSetResetLockStatusReq)
end

function TSetResetLockStatusReq.new(ResetMode, OperationType, TimeoutSeconds, LockCause)
    return TSetResetLockStatusReq_from_obj({
        ResetMode = ResetMode,
        OperationType = OperationType,
        TimeoutSeconds = TimeoutSeconds,
        LockCause = LockCause
    })
end
---@param obj SystemControl.SetResetLockStatusReq
function TSetResetLockStatusReq:init_from_obj(obj)
    self.ResetMode = obj.ResetMode
    self.OperationType = obj.OperationType
    self.TimeoutSeconds = obj.TimeoutSeconds
    self.LockCause = obj.LockCause
end

function TSetResetLockStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetResetLockStatusReq.group)
end

TSetResetLockStatusReq.from_obj = TSetResetLockStatusReq_from_obj

TSetResetLockStatusReq.proto_property = {'ResetMode', 'OperationType', 'TimeoutSeconds', 'LockCause'}

TSetResetLockStatusReq.default = {'', '', 0, SystemControl.LockCause.default}

TSetResetLockStatusReq.struct = {
    {name = 'ResetMode', is_array = false, struct = nil}, {name = 'OperationType', is_array = false, struct = nil},
    {name = 'TimeoutSeconds', is_array = false, struct = nil},
    {name = 'LockCause', is_array = false, struct = SystemControl.LockCause.struct}
}

function TSetResetLockStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResetMode', self.ResetMode, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'OperationType', self.OperationType, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'TimeoutSeconds', self.TimeoutSeconds, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'LockCause', self.LockCause, 'SystemControl.LockCause', false, errs, need_convert)

    TSetResetLockStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetResetLockStatusReq.proto_property, errs, need_convert)
    return self
end

function TSetResetLockStatusReq:unpack(raw)
    local LockCause = utils.unpack_enum(raw, self.LockCause)
    return self.ResetMode, self.OperationType, self.TimeoutSeconds, LockCause
end

SystemControl.SetResetLockStatusReq = TSetResetLockStatusReq

---@class SystemControl.WarmResetRsp
local TWarmResetRsp = {}
TWarmResetRsp.__index = TWarmResetRsp
TWarmResetRsp.group = {}

local function TWarmResetRsp_from_obj(obj)
    return setmetatable(obj, TWarmResetRsp)
end

function TWarmResetRsp.new()
    return TWarmResetRsp_from_obj({})
end
---@param obj SystemControl.WarmResetRsp
function TWarmResetRsp:init_from_obj(obj)

end

function TWarmResetRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWarmResetRsp.group)
end

TWarmResetRsp.from_obj = TWarmResetRsp_from_obj

TWarmResetRsp.proto_property = {}

TWarmResetRsp.default = {}

TWarmResetRsp.struct = {}

function TWarmResetRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TWarmResetRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWarmResetRsp.proto_property, errs, need_convert)
    return self
end

function TWarmResetRsp:unpack(_)
end

SystemControl.WarmResetRsp = TWarmResetRsp

---@class SystemControl.WarmResetReq
local TWarmResetReq = {}
TWarmResetReq.__index = TWarmResetReq
TWarmResetReq.group = {}

local function TWarmResetReq_from_obj(obj)
    return setmetatable(obj, TWarmResetReq)
end

function TWarmResetReq.new()
    return TWarmResetReq_from_obj({})
end
---@param obj SystemControl.WarmResetReq
function TWarmResetReq:init_from_obj(obj)

end

function TWarmResetReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWarmResetReq.group)
end

TWarmResetReq.from_obj = TWarmResetReq_from_obj

TWarmResetReq.proto_property = {}

TWarmResetReq.default = {}

TWarmResetReq.struct = {}

function TWarmResetReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TWarmResetReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWarmResetReq.proto_property, errs, need_convert)
    return self
end

function TWarmResetReq:unpack(_)
end

SystemControl.WarmResetReq = TWarmResetReq

---@class SystemControl.GracefulResetRsp
---@field OutData integer
local TGracefulResetRsp = {}
TGracefulResetRsp.__index = TGracefulResetRsp
TGracefulResetRsp.group = {}

local function TGracefulResetRsp_from_obj(obj)
    return setmetatable(obj, TGracefulResetRsp)
end

function TGracefulResetRsp.new(OutData)
    return TGracefulResetRsp_from_obj({OutData = OutData})
end
---@param obj SystemControl.GracefulResetRsp
function TGracefulResetRsp:init_from_obj(obj)
    self.OutData = obj.OutData
end

function TGracefulResetRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGracefulResetRsp.group)
end

TGracefulResetRsp.from_obj = TGracefulResetRsp_from_obj

TGracefulResetRsp.proto_property = {'OutData'}

TGracefulResetRsp.default = {0}

TGracefulResetRsp.struct = {{name = 'OutData', is_array = false, struct = nil}}

function TGracefulResetRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OutData', self.OutData, 'int32', false, errs, need_convert)

    TGracefulResetRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGracefulResetRsp.proto_property, errs, need_convert)
    return self
end

function TGracefulResetRsp:unpack(_)
    return self.OutData
end

SystemControl.GracefulResetRsp = TGracefulResetRsp

---@class SystemControl.GracefulResetReq
---@field ResetType integer
local TGracefulResetReq = {}
TGracefulResetReq.__index = TGracefulResetReq
TGracefulResetReq.group = {}

local function TGracefulResetReq_from_obj(obj)
    return setmetatable(obj, TGracefulResetReq)
end

function TGracefulResetReq.new(ResetType)
    return TGracefulResetReq_from_obj({ResetType = ResetType})
end
---@param obj SystemControl.GracefulResetReq
function TGracefulResetReq:init_from_obj(obj)
    self.ResetType = obj.ResetType
end

function TGracefulResetReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGracefulResetReq.group)
end

TGracefulResetReq.from_obj = TGracefulResetReq_from_obj

TGracefulResetReq.proto_property = {'ResetType'}

TGracefulResetReq.default = {0}

TGracefulResetReq.struct = {{name = 'ResetType', is_array = false, struct = nil}}

function TGracefulResetReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResetType', self.ResetType, 'uint8', false, errs, need_convert)

    TGracefulResetReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGracefulResetReq.proto_property, errs, need_convert)
    return self
end

function TGracefulResetReq:unpack(_)
    return self.ResetType
end

SystemControl.GracefulResetReq = TGracefulResetReq

---@class SystemControl.ForceResetRsp
local TForceResetRsp = {}
TForceResetRsp.__index = TForceResetRsp
TForceResetRsp.group = {}

local function TForceResetRsp_from_obj(obj)
    return setmetatable(obj, TForceResetRsp)
end

function TForceResetRsp.new()
    return TForceResetRsp_from_obj({})
end
---@param obj SystemControl.ForceResetRsp
function TForceResetRsp:init_from_obj(obj)

end

function TForceResetRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TForceResetRsp.group)
end

TForceResetRsp.from_obj = TForceResetRsp_from_obj

TForceResetRsp.proto_property = {}

TForceResetRsp.default = {}

TForceResetRsp.struct = {}

function TForceResetRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TForceResetRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TForceResetRsp.proto_property, errs, need_convert)
    return self
end

function TForceResetRsp:unpack(_)
end

SystemControl.ForceResetRsp = TForceResetRsp

---@class SystemControl.ForceResetReq
---@field ResetType integer
local TForceResetReq = {}
TForceResetReq.__index = TForceResetReq
TForceResetReq.group = {}

local function TForceResetReq_from_obj(obj)
    return setmetatable(obj, TForceResetReq)
end

function TForceResetReq.new(ResetType)
    return TForceResetReq_from_obj({ResetType = ResetType})
end
---@param obj SystemControl.ForceResetReq
function TForceResetReq:init_from_obj(obj)
    self.ResetType = obj.ResetType
end

function TForceResetReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TForceResetReq.group)
end

TForceResetReq.from_obj = TForceResetReq_from_obj

TForceResetReq.proto_property = {'ResetType'}

TForceResetReq.default = {0}

TForceResetReq.struct = {{name = 'ResetType', is_array = false, struct = nil}}

function TForceResetReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResetType', self.ResetType, 'uint8', false, errs, need_convert)

    TForceResetReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TForceResetReq.proto_property, errs, need_convert)
    return self
end

function TForceResetReq:unpack(_)
    return self.ResetType
end

SystemControl.ForceResetReq = TForceResetReq

SystemControl.interface = mdb.register_interface('bmc.kepler.SystemControl',
    {ResetLockStatus = {'s', nil, true, nil, false}}, {
        ForceReset = {'a{ss}y', '', TForceResetReq, TForceResetRsp},
        GracefulReset = {'a{ss}y', 'i', TGracefulResetReq, TGracefulResetRsp},
        WarmReset = {'a{ss}', '', TWarmResetReq, TWarmResetRsp},
        SetResetLockStatus = {'a{ss}ssus', '', TSetResetLockStatusReq, TSetResetLockStatusRsp}
    }, {})

return SystemControl
