-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local SecureBootOptions = {}

---@class SecureBootOptions.CertificateExpired
---@field CertificateExpired integer
local TCertificateExpired = {}
TCertificateExpired.__index = TCertificateExpired
TCertificateExpired.group = {}

local function TCertificateExpired_from_obj(obj)
    return setmetatable(obj, TCertificateExpired)
end

function TCertificateExpired.new(CertificateExpired)
    return TCertificateExpired_from_obj({CertificateExpired = CertificateExpired or 0})
end
---@param obj SecureBootOptions.CertificateExpired
function TCertificateExpired:init_from_obj(obj)
    self.CertificateExpired = obj.CertificateExpired or 0
end

function TCertificateExpired:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCertificateExpired.group)
end

TCertificateExpired.from_obj = TCertificateExpired_from_obj

TCertificateExpired.proto_property = {'CertificateExpired'}

TCertificateExpired.default = {0}

TCertificateExpired.struct = {{name = 'CertificateExpired', is_array = false, struct = nil}}

function TCertificateExpired:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CertificateExpired', self.CertificateExpired, 'uint8', true, errs, need_convert)

    TCertificateExpired:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCertificateExpired.proto_property, errs, need_convert)
    return self
end

function TCertificateExpired:unpack(_)
    return self.CertificateExpired
end

SecureBootOptions.CertificateExpired = TCertificateExpired

---@class SecureBootOptions.SystemId
---@field SystemId integer
local TSystemId = {}
TSystemId.__index = TSystemId
TSystemId.group = {}

local function TSystemId_from_obj(obj)
    return setmetatable(obj, TSystemId)
end

function TSystemId.new(SystemId)
    return TSystemId_from_obj({SystemId = SystemId})
end
---@param obj SecureBootOptions.SystemId
function TSystemId:init_from_obj(obj)
    self.SystemId = obj.SystemId
end

function TSystemId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemId.group)
end

TSystemId.from_obj = TSystemId_from_obj

TSystemId.proto_property = {'SystemId'}

TSystemId.default = {0}

TSystemId.struct = {{name = 'SystemId', is_array = false, struct = nil}}

function TSystemId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'uint8', true, errs, need_convert)

    TSystemId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemId.proto_property, errs, need_convert)
    return self
end

function TSystemId:unpack(_)
    return self.SystemId
end

SecureBootOptions.SystemId = TSystemId

---@class SecureBootOptions.GetCertificateRsp
---@field CertInfo string
local TGetCertificateRsp = {}
TGetCertificateRsp.__index = TGetCertificateRsp
TGetCertificateRsp.group = {}

local function TGetCertificateRsp_from_obj(obj)
    return setmetatable(obj, TGetCertificateRsp)
end

function TGetCertificateRsp.new(CertInfo)
    return TGetCertificateRsp_from_obj({CertInfo = CertInfo})
end
---@param obj SecureBootOptions.GetCertificateRsp
function TGetCertificateRsp:init_from_obj(obj)
    self.CertInfo = obj.CertInfo
end

function TGetCertificateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCertificateRsp.group)
end

TGetCertificateRsp.from_obj = TGetCertificateRsp_from_obj

TGetCertificateRsp.proto_property = {'CertInfo'}

TGetCertificateRsp.default = {''}

TGetCertificateRsp.struct = {{name = 'CertInfo', is_array = false, struct = nil}}

function TGetCertificateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CertInfo', self.CertInfo, 'string', false, errs, need_convert)

    TGetCertificateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCertificateRsp.proto_property, errs, need_convert)
    return self
end

function TGetCertificateRsp:unpack(_)
    return self.CertInfo
end

SecureBootOptions.GetCertificateRsp = TGetCertificateRsp

---@class SecureBootOptions.GetCertificateReq
local TGetCertificateReq = {}
TGetCertificateReq.__index = TGetCertificateReq
TGetCertificateReq.group = {}

local function TGetCertificateReq_from_obj(obj)
    return setmetatable(obj, TGetCertificateReq)
end

function TGetCertificateReq.new()
    return TGetCertificateReq_from_obj({})
end
---@param obj SecureBootOptions.GetCertificateReq
function TGetCertificateReq:init_from_obj(obj)

end

function TGetCertificateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCertificateReq.group)
end

TGetCertificateReq.from_obj = TGetCertificateReq_from_obj

TGetCertificateReq.proto_property = {}

TGetCertificateReq.default = {}

TGetCertificateReq.struct = {}

function TGetCertificateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetCertificateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCertificateReq.proto_property, errs, need_convert)
    return self
end

function TGetCertificateReq:unpack(_)
end

SecureBootOptions.GetCertificateReq = TGetCertificateReq

---@class SecureBootOptions.ResetCertificateRsp
local TResetCertificateRsp = {}
TResetCertificateRsp.__index = TResetCertificateRsp
TResetCertificateRsp.group = {}

local function TResetCertificateRsp_from_obj(obj)
    return setmetatable(obj, TResetCertificateRsp)
end

function TResetCertificateRsp.new()
    return TResetCertificateRsp_from_obj({})
end
---@param obj SecureBootOptions.ResetCertificateRsp
function TResetCertificateRsp:init_from_obj(obj)

end

function TResetCertificateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetCertificateRsp.group)
end

TResetCertificateRsp.from_obj = TResetCertificateRsp_from_obj

TResetCertificateRsp.proto_property = {}

TResetCertificateRsp.default = {}

TResetCertificateRsp.struct = {}

function TResetCertificateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TResetCertificateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetCertificateRsp.proto_property, errs, need_convert)
    return self
end

function TResetCertificateRsp:unpack(_)
end

SecureBootOptions.ResetCertificateRsp = TResetCertificateRsp

---@class SecureBootOptions.ResetCertificateReq
---@field DatabseType string
---@field ResetType string
local TResetCertificateReq = {}
TResetCertificateReq.__index = TResetCertificateReq
TResetCertificateReq.group = {}

local function TResetCertificateReq_from_obj(obj)
    return setmetatable(obj, TResetCertificateReq)
end

function TResetCertificateReq.new(DatabseType, ResetType)
    return TResetCertificateReq_from_obj({DatabseType = DatabseType, ResetType = ResetType})
end
---@param obj SecureBootOptions.ResetCertificateReq
function TResetCertificateReq:init_from_obj(obj)
    self.DatabseType = obj.DatabseType
    self.ResetType = obj.ResetType
end

function TResetCertificateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetCertificateReq.group)
end

TResetCertificateReq.from_obj = TResetCertificateReq_from_obj

TResetCertificateReq.proto_property = {'DatabseType', 'ResetType'}

TResetCertificateReq.default = {'', ''}

TResetCertificateReq.struct = {
    {name = 'DatabseType', is_array = false, struct = nil}, {name = 'ResetType', is_array = false, struct = nil}
}

function TResetCertificateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DatabseType', self.DatabseType, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'ResetType', self.ResetType, 'string', false, errs, need_convert)

    TResetCertificateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetCertificateReq.proto_property, errs, need_convert)
    return self
end

function TResetCertificateReq:unpack(_)
    return self.DatabseType, self.ResetType
end

SecureBootOptions.ResetCertificateReq = TResetCertificateReq

---@class SecureBootOptions.ImportCertificateRsp
local TImportCertificateRsp = {}
TImportCertificateRsp.__index = TImportCertificateRsp
TImportCertificateRsp.group = {}

local function TImportCertificateRsp_from_obj(obj)
    return setmetatable(obj, TImportCertificateRsp)
end

function TImportCertificateRsp.new()
    return TImportCertificateRsp_from_obj({})
end
---@param obj SecureBootOptions.ImportCertificateRsp
function TImportCertificateRsp:init_from_obj(obj)

end

function TImportCertificateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportCertificateRsp.group)
end

TImportCertificateRsp.from_obj = TImportCertificateRsp_from_obj

TImportCertificateRsp.proto_property = {}

TImportCertificateRsp.default = {}

TImportCertificateRsp.struct = {}

function TImportCertificateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TImportCertificateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportCertificateRsp.proto_property, errs, need_convert)
    return self
end

function TImportCertificateRsp:unpack(_)
end

SecureBootOptions.ImportCertificateRsp = TImportCertificateRsp

---@class SecureBootOptions.ImportCertificateReq
---@field DatabseType string
---@field CertString string
---@field CertType string
local TImportCertificateReq = {}
TImportCertificateReq.__index = TImportCertificateReq
TImportCertificateReq.group = {}

local function TImportCertificateReq_from_obj(obj)
    return setmetatable(obj, TImportCertificateReq)
end

function TImportCertificateReq.new(DatabseType, CertString, CertType)
    return TImportCertificateReq_from_obj({DatabseType = DatabseType, CertString = CertString, CertType = CertType})
end
---@param obj SecureBootOptions.ImportCertificateReq
function TImportCertificateReq:init_from_obj(obj)
    self.DatabseType = obj.DatabseType
    self.CertString = obj.CertString
    self.CertType = obj.CertType
end

function TImportCertificateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportCertificateReq.group)
end

TImportCertificateReq.from_obj = TImportCertificateReq_from_obj

TImportCertificateReq.proto_property = {'DatabseType', 'CertString', 'CertType'}

TImportCertificateReq.default = {'', '', ''}

TImportCertificateReq.struct = {
    {name = 'DatabseType', is_array = false, struct = nil}, {name = 'CertString', is_array = false, struct = nil},
    {name = 'CertType', is_array = false, struct = nil}
}

function TImportCertificateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DatabseType', self.DatabseType, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'CertString', self.CertString, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'CertType', self.CertType, 'string', false, errs, need_convert)

    TImportCertificateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportCertificateReq.proto_property, errs, need_convert)
    return self
end

function TImportCertificateReq:unpack(_)
    return self.DatabseType, self.CertString, self.CertType
end

SecureBootOptions.ImportCertificateReq = TImportCertificateReq

SecureBootOptions.interface = mdb.register_interface('bmc.kepler.Systems.SecureBootOptions', {
    SystemId = {'y', nil, true, nil, false},
    CertificateExpired = {'y', nil, true, 0, false}
}, {
    ImportCertificate = {'a{ss}sss', '', TImportCertificateReq, TImportCertificateRsp},
    ResetCertificate = {'a{ss}ss', '', TResetCertificateReq, TResetCertificateRsp},
    GetCertificate = {'a{ss}', 's', TGetCertificateReq, TGetCertificateRsp}
}, {})

return SecureBootOptions
