-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local SecureBoot = {}

---@class SecureBoot.VerificationEnabled
---@field VerificationEnabled boolean
local TVerificationEnabled = {}
TVerificationEnabled.__index = TVerificationEnabled
TVerificationEnabled.group = {}

local function TVerificationEnabled_from_obj(obj)
    return setmetatable(obj, TVerificationEnabled)
end

function TVerificationEnabled.new(VerificationEnabled)
    return TVerificationEnabled_from_obj({
        VerificationEnabled = VerificationEnabled or false
    })
end
---@param obj SecureBoot.VerificationEnabled
function TVerificationEnabled:init_from_obj(obj)
    self.VerificationEnabled = obj.VerificationEnabled or false
end

function TVerificationEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVerificationEnabled.group)
end

TVerificationEnabled.from_obj = TVerificationEnabled_from_obj

TVerificationEnabled.proto_property = {'VerificationEnabled'}

TVerificationEnabled.default = {false}

TVerificationEnabled.struct = {
    {name = 'VerificationEnabled', is_array = false, struct = nil}
}

function TVerificationEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VerificationEnabled', self.VerificationEnabled,
                      "bool", true, errs, need_convert)

    TVerificationEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVerificationEnabled.proto_property,
                                 errs, need_convert)
    return self
end

function TVerificationEnabled:unpack(_) return self.VerificationEnabled end

SecureBoot.VerificationEnabled = TVerificationEnabled

---@class SecureBoot.SetBiosSignatureRsp
local TSetBiosSignatureRsp = {}
TSetBiosSignatureRsp.__index = TSetBiosSignatureRsp
TSetBiosSignatureRsp.group = {}

local function TSetBiosSignatureRsp_from_obj(obj)
    return setmetatable(obj, TSetBiosSignatureRsp)
end

function TSetBiosSignatureRsp.new() return TSetBiosSignatureRsp_from_obj({}) end
---@param obj SecureBoot.SetBiosSignatureRsp
function TSetBiosSignatureRsp:init_from_obj(obj) end

function TSetBiosSignatureRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBiosSignatureRsp.group)
end

TSetBiosSignatureRsp.from_obj = TSetBiosSignatureRsp_from_obj

TSetBiosSignatureRsp.proto_property = {}

TSetBiosSignatureRsp.default = {}

TSetBiosSignatureRsp.struct = {}

function TSetBiosSignatureRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetBiosSignatureRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBiosSignatureRsp.proto_property,
                                 errs, need_convert)
    return self
end

function TSetBiosSignatureRsp:unpack(_) end

SecureBoot.SetBiosSignatureRsp = TSetBiosSignatureRsp

---@class SecureBoot.SetBiosSignatureReq
---@field SystemId integer
---@field Signature string
local TSetBiosSignatureReq = {}
TSetBiosSignatureReq.__index = TSetBiosSignatureReq
TSetBiosSignatureReq.group = {}

local function TSetBiosSignatureReq_from_obj(obj)
    return setmetatable(obj, TSetBiosSignatureReq)
end

function TSetBiosSignatureReq.new(SystemId, Signature)
    return TSetBiosSignatureReq_from_obj({
        SystemId = SystemId,
        Signature = Signature
    })
end
---@param obj SecureBoot.SetBiosSignatureReq
function TSetBiosSignatureReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.Signature = obj.Signature
end

function TSetBiosSignatureReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBiosSignatureReq.group)
end

TSetBiosSignatureReq.from_obj = TSetBiosSignatureReq_from_obj

TSetBiosSignatureReq.proto_property = {'SystemId', 'Signature'}

TSetBiosSignatureReq.default = {0, ''}

TSetBiosSignatureReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'Signature', is_array = false, struct = nil}
}

function TSetBiosSignatureReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, "uint8", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'Signature', self.Signature, "string", false,
                      errs, need_convert)

    if self.Signature ~= nil then
        validate.lens(prefix .. 'Signature', self.Signature, 64, 64, errs,
                      need_convert)
    end

    TSetBiosSignatureReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBiosSignatureReq.proto_property,
                                 errs, need_convert)
    return self
end

function TSetBiosSignatureReq:unpack(_) return self.SystemId, self.Signature end

SecureBoot.SetBiosSignatureReq = TSetBiosSignatureReq

SecureBoot.interface = mdb.register_interface('bmc.kepler.Managers.SecureBoot',
                                              {
    VerificationEnabled = {'b', {}, true, false, false}
}, {
    SetBiosSignature = {
        'a{ss}ys', '', TSetBiosSignatureReq, TSetBiosSignatureRsp
    }
}, {})

return SecureBoot
