-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Memory = {}

---@class Memory.ErrorCorrection
---@field ErrorCorrection string
local TErrorCorrection = {}
TErrorCorrection.__index = TErrorCorrection
TErrorCorrection.group = {}

local function TErrorCorrection_from_obj(obj)
    return setmetatable(obj, TErrorCorrection)
end

function TErrorCorrection.new(ErrorCorrection)
    return TErrorCorrection_from_obj({ErrorCorrection = ErrorCorrection})
end
---@param obj Memory.ErrorCorrection
function TErrorCorrection:init_from_obj(obj)
    self.ErrorCorrection = obj.ErrorCorrection
end

function TErrorCorrection:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TErrorCorrection.group)
end

TErrorCorrection.from_obj = TErrorCorrection_from_obj

TErrorCorrection.proto_property = {'ErrorCorrection'}

TErrorCorrection.default = {''}

TErrorCorrection.struct = {{name = 'ErrorCorrection', is_array = false, struct = nil}}

function TErrorCorrection:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ErrorCorrection', self.ErrorCorrection, 'string', true, errs, need_convert)

    TErrorCorrection:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TErrorCorrection.proto_property, errs, need_convert)
    return self
end

function TErrorCorrection:unpack(_)
    return self.ErrorCorrection
end

Memory.ErrorCorrection = TErrorCorrection

---@class Memory.SilkText
---@field SilkText string
local TSilkText = {}
TSilkText.__index = TSilkText
TSilkText.group = {}

local function TSilkText_from_obj(obj)
    return setmetatable(obj, TSilkText)
end

function TSilkText.new(SilkText)
    return TSilkText_from_obj({SilkText = SilkText})
end
---@param obj Memory.SilkText
function TSilkText:init_from_obj(obj)
    self.SilkText = obj.SilkText
end

function TSilkText:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSilkText.group)
end

TSilkText.from_obj = TSilkText_from_obj

TSilkText.proto_property = {'SilkText'}

TSilkText.default = {''}

TSilkText.struct = {{name = 'SilkText', is_array = false, struct = nil}}

function TSilkText:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SilkText', self.SilkText, 'string', true, errs, need_convert)

    TSilkText:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSilkText.proto_property, errs, need_convert)
    return self
end

function TSilkText:unpack(_)
    return self.SilkText
end

Memory.SilkText = TSilkText

---@class Memory.TemperatureCelsius
---@field TemperatureCelsius number
local TTemperatureCelsius = {}
TTemperatureCelsius.__index = TTemperatureCelsius
TTemperatureCelsius.group = {}

local function TTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TTemperatureCelsius)
end

function TTemperatureCelsius.new(TemperatureCelsius)
    return TTemperatureCelsius_from_obj({TemperatureCelsius = TemperatureCelsius})
end
---@param obj Memory.TemperatureCelsius
function TTemperatureCelsius:init_from_obj(obj)
    self.TemperatureCelsius = obj.TemperatureCelsius
end

function TTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTemperatureCelsius.group)
end

TTemperatureCelsius.from_obj = TTemperatureCelsius_from_obj

TTemperatureCelsius.proto_property = {'TemperatureCelsius'}

TTemperatureCelsius.default = {0}

TTemperatureCelsius.struct = {{name = 'TemperatureCelsius', is_array = false, struct = nil}}

function TTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TemperatureCelsius', self.TemperatureCelsius, 'double', true, errs, need_convert)

    TTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TTemperatureCelsius:unpack(_)
    return self.TemperatureCelsius
end

Memory.TemperatureCelsius = TTemperatureCelsius

---@class Memory.ChipBitWidth
---@field ChipBitWidth string
local TChipBitWidth = {}
TChipBitWidth.__index = TChipBitWidth
TChipBitWidth.group = {}

local function TChipBitWidth_from_obj(obj)
    return setmetatable(obj, TChipBitWidth)
end

function TChipBitWidth.new(ChipBitWidth)
    return TChipBitWidth_from_obj({ChipBitWidth = ChipBitWidth})
end
---@param obj Memory.ChipBitWidth
function TChipBitWidth:init_from_obj(obj)
    self.ChipBitWidth = obj.ChipBitWidth
end

function TChipBitWidth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChipBitWidth.group)
end

TChipBitWidth.from_obj = TChipBitWidth_from_obj

TChipBitWidth.proto_property = {'ChipBitWidth'}

TChipBitWidth.default = {''}

TChipBitWidth.struct = {{name = 'ChipBitWidth', is_array = false, struct = nil}}

function TChipBitWidth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChipBitWidth', self.ChipBitWidth, 'string', true, errs, need_convert)

    TChipBitWidth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChipBitWidth.proto_property, errs, need_convert)
    return self
end

function TChipBitWidth:unpack(_)
    return self.ChipBitWidth
end

Memory.ChipBitWidth = TChipBitWidth

---@class Memory.ManufacturingLocation
---@field ManufacturingLocation string
local TManufacturingLocation = {}
TManufacturingLocation.__index = TManufacturingLocation
TManufacturingLocation.group = {}

local function TManufacturingLocation_from_obj(obj)
    return setmetatable(obj, TManufacturingLocation)
end

function TManufacturingLocation.new(ManufacturingLocation)
    return TManufacturingLocation_from_obj({ManufacturingLocation = ManufacturingLocation})
end
---@param obj Memory.ManufacturingLocation
function TManufacturingLocation:init_from_obj(obj)
    self.ManufacturingLocation = obj.ManufacturingLocation
end

function TManufacturingLocation:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManufacturingLocation.group)
end

TManufacturingLocation.from_obj = TManufacturingLocation_from_obj

TManufacturingLocation.proto_property = {'ManufacturingLocation'}

TManufacturingLocation.default = {''}

TManufacturingLocation.struct = {{name = 'ManufacturingLocation', is_array = false, struct = nil}}

function TManufacturingLocation:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturingLocation', self.ManufacturingLocation, 'string', true, errs, need_convert)

    TManufacturingLocation:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManufacturingLocation.proto_property, errs, need_convert)
    return self
end

function TManufacturingLocation:unpack(_)
    return self.ManufacturingLocation
end

Memory.ManufacturingLocation = TManufacturingLocation

---@class Memory.ManufacturingDate
---@field ManufacturingDate string
local TManufacturingDate = {}
TManufacturingDate.__index = TManufacturingDate
TManufacturingDate.group = {}

local function TManufacturingDate_from_obj(obj)
    return setmetatable(obj, TManufacturingDate)
end

function TManufacturingDate.new(ManufacturingDate)
    return TManufacturingDate_from_obj({ManufacturingDate = ManufacturingDate})
end
---@param obj Memory.ManufacturingDate
function TManufacturingDate:init_from_obj(obj)
    self.ManufacturingDate = obj.ManufacturingDate
end

function TManufacturingDate:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManufacturingDate.group)
end

TManufacturingDate.from_obj = TManufacturingDate_from_obj

TManufacturingDate.proto_property = {'ManufacturingDate'}

TManufacturingDate.default = {''}

TManufacturingDate.struct = {{name = 'ManufacturingDate', is_array = false, struct = nil}}

function TManufacturingDate:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturingDate', self.ManufacturingDate, 'string', true, errs, need_convert)

    TManufacturingDate:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManufacturingDate.proto_property, errs, need_convert)
    return self
end

function TManufacturingDate:unpack(_)
    return self.ManufacturingDate
end

Memory.ManufacturingDate = TManufacturingDate

---@class Memory.ManufacturerID
---@field ManufacturerID string
local TManufacturerID = {}
TManufacturerID.__index = TManufacturerID
TManufacturerID.group = {}

local function TManufacturerID_from_obj(obj)
    return setmetatable(obj, TManufacturerID)
end

function TManufacturerID.new(ManufacturerID)
    return TManufacturerID_from_obj({ManufacturerID = ManufacturerID})
end
---@param obj Memory.ManufacturerID
function TManufacturerID:init_from_obj(obj)
    self.ManufacturerID = obj.ManufacturerID
end

function TManufacturerID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManufacturerID.group)
end

TManufacturerID.from_obj = TManufacturerID_from_obj

TManufacturerID.proto_property = {'ManufacturerID'}

TManufacturerID.default = {''}

TManufacturerID.struct = {{name = 'ManufacturerID', is_array = false, struct = nil}}

function TManufacturerID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerID', self.ManufacturerID, 'string', true, errs, need_convert)

    TManufacturerID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManufacturerID.proto_property, errs, need_convert)
    return self
end

function TManufacturerID:unpack(_)
    return self.ManufacturerID
end

Memory.ManufacturerID = TManufacturerID

---@class Memory.BOM
---@field BOM string
local TBOM = {}
TBOM.__index = TBOM
TBOM.group = {}

local function TBOM_from_obj(obj)
    return setmetatable(obj, TBOM)
end

function TBOM.new(BOM)
    return TBOM_from_obj({BOM = BOM})
end
---@param obj Memory.BOM
function TBOM:init_from_obj(obj)
    self.BOM = obj.BOM
end

function TBOM:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBOM.group)
end

TBOM.from_obj = TBOM_from_obj

TBOM.proto_property = {'BOM'}

TBOM.default = {''}

TBOM.struct = {{name = 'BOM', is_array = false, struct = nil}}

function TBOM:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BOM', self.BOM, 'string', true, errs, need_convert)

    TBOM:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBOM.proto_property, errs, need_convert)
    return self
end

function TBOM:unpack(_)
    return self.BOM
end

Memory.BOM = TBOM

---@class Memory.DimmNum
---@field DimmNum integer
local TDimmNum = {}
TDimmNum.__index = TDimmNum
TDimmNum.group = {}

local function TDimmNum_from_obj(obj)
    return setmetatable(obj, TDimmNum)
end

function TDimmNum.new(DimmNum)
    return TDimmNum_from_obj({DimmNum = DimmNum})
end
---@param obj Memory.DimmNum
function TDimmNum:init_from_obj(obj)
    self.DimmNum = obj.DimmNum
end

function TDimmNum:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDimmNum.group)
end

TDimmNum.from_obj = TDimmNum_from_obj

TDimmNum.proto_property = {'DimmNum'}

TDimmNum.default = {0}

TDimmNum.struct = {{name = 'DimmNum', is_array = false, struct = nil}}

function TDimmNum:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DimmNum', self.DimmNum, 'uint8', true, errs, need_convert)

    TDimmNum:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDimmNum.proto_property, errs, need_convert)
    return self
end

function TDimmNum:unpack(_)
    return self.DimmNum
end

Memory.DimmNum = TDimmNum

---@class Memory.Health
---@field Health integer
local THealth = {}
THealth.__index = THealth
THealth.group = {}

local function THealth_from_obj(obj)
    return setmetatable(obj, THealth)
end

function THealth.new(Health)
    return THealth_from_obj({Health = Health})
end
---@param obj Memory.Health
function THealth:init_from_obj(obj)
    self.Health = obj.Health
end

function THealth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THealth.group)
end

THealth.from_obj = THealth_from_obj

THealth.proto_property = {'Health'}

THealth.default = {0}

THealth.struct = {{name = 'Health', is_array = false, struct = nil}}

function THealth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Health', self.Health, 'uint8', true, errs, need_convert)

    THealth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THealth.proto_property, errs, need_convert)
    return self
end

function THealth:unpack(_)
    return self.Health
end

Memory.Health = THealth

---@class Memory.DeviceLocator
---@field DeviceLocator string
local TDeviceLocator = {}
TDeviceLocator.__index = TDeviceLocator
TDeviceLocator.group = {}

local function TDeviceLocator_from_obj(obj)
    return setmetatable(obj, TDeviceLocator)
end

function TDeviceLocator.new(DeviceLocator)
    return TDeviceLocator_from_obj({DeviceLocator = DeviceLocator})
end
---@param obj Memory.DeviceLocator
function TDeviceLocator:init_from_obj(obj)
    self.DeviceLocator = obj.DeviceLocator
end

function TDeviceLocator:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceLocator.group)
end

TDeviceLocator.from_obj = TDeviceLocator_from_obj

TDeviceLocator.proto_property = {'DeviceLocator'}

TDeviceLocator.default = {''}

TDeviceLocator.struct = {{name = 'DeviceLocator', is_array = false, struct = nil}}

function TDeviceLocator:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeviceLocator', self.DeviceLocator, 'string', true, errs, need_convert)

    TDeviceLocator:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceLocator.proto_property, errs, need_convert)
    return self
end

function TDeviceLocator:unpack(_)
    return self.DeviceLocator
end

Memory.DeviceLocator = TDeviceLocator

---@class Memory.PredictiveFault
---@field PredictiveFault integer
local TPredictiveFault = {}
TPredictiveFault.__index = TPredictiveFault
TPredictiveFault.group = {}

local function TPredictiveFault_from_obj(obj)
    return setmetatable(obj, TPredictiveFault)
end

function TPredictiveFault.new(PredictiveFault)
    return TPredictiveFault_from_obj({PredictiveFault = PredictiveFault or 0})
end
---@param obj Memory.PredictiveFault
function TPredictiveFault:init_from_obj(obj)
    self.PredictiveFault = obj.PredictiveFault or 0
end

function TPredictiveFault:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPredictiveFault.group)
end

TPredictiveFault.from_obj = TPredictiveFault_from_obj

TPredictiveFault.proto_property = {'PredictiveFault'}

TPredictiveFault.default = {0}

TPredictiveFault.struct = {{name = 'PredictiveFault', is_array = false, struct = nil}}

function TPredictiveFault:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PredictiveFault', self.PredictiveFault, 'uint8', true, errs, need_convert)

    TPredictiveFault:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPredictiveFault.proto_property, errs, need_convert)
    return self
end

function TPredictiveFault:unpack(_)
    return self.PredictiveFault
end

Memory.PredictiveFault = TPredictiveFault

---@class Memory.DiagnosticFault
---@field DiagnosticFault integer
local TDiagnosticFault = {}
TDiagnosticFault.__index = TDiagnosticFault
TDiagnosticFault.group = {}

local function TDiagnosticFault_from_obj(obj)
    return setmetatable(obj, TDiagnosticFault)
end

function TDiagnosticFault.new(DiagnosticFault)
    return TDiagnosticFault_from_obj({DiagnosticFault = DiagnosticFault or 0})
end
---@param obj Memory.DiagnosticFault
function TDiagnosticFault:init_from_obj(obj)
    self.DiagnosticFault = obj.DiagnosticFault or 0
end

function TDiagnosticFault:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDiagnosticFault.group)
end

TDiagnosticFault.from_obj = TDiagnosticFault_from_obj

TDiagnosticFault.proto_property = {'DiagnosticFault'}

TDiagnosticFault.default = {0}

TDiagnosticFault.struct = {{name = 'DiagnosticFault', is_array = false, struct = nil}}

function TDiagnosticFault:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DiagnosticFault', self.DiagnosticFault, 'uint8', false, errs, need_convert)

    TDiagnosticFault:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDiagnosticFault.proto_property, errs, need_convert)
    return self
end

function TDiagnosticFault:unpack(_)
    return self.DiagnosticFault
end

Memory.DiagnosticFault = TDiagnosticFault

---@class Memory.Position
---@field Position string
local TPosition = {}
TPosition.__index = TPosition
TPosition.group = {}

local function TPosition_from_obj(obj)
    return setmetatable(obj, TPosition)
end

function TPosition.new(Position)
    return TPosition_from_obj({Position = Position})
end
---@param obj Memory.Position
function TPosition:init_from_obj(obj)
    self.Position = obj.Position
end

function TPosition:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPosition.group)
end

TPosition.from_obj = TPosition_from_obj

TPosition.proto_property = {'Position'}

TPosition.default = {''}

TPosition.struct = {{name = 'Position', is_array = false, struct = nil}}

function TPosition:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Position', self.Position, 'string', true, errs, need_convert)

    TPosition:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPosition.proto_property, errs, need_convert)
    return self
end

function TPosition:unpack(_)
    return self.Position
end

Memory.Position = TPosition

---@class Memory.MinVoltageMillivolt
---@field MinVoltageMillivolt integer
local TMinVoltageMillivolt = {}
TMinVoltageMillivolt.__index = TMinVoltageMillivolt
TMinVoltageMillivolt.group = {}

local function TMinVoltageMillivolt_from_obj(obj)
    return setmetatable(obj, TMinVoltageMillivolt)
end

function TMinVoltageMillivolt.new(MinVoltageMillivolt)
    return TMinVoltageMillivolt_from_obj({MinVoltageMillivolt = MinVoltageMillivolt})
end
---@param obj Memory.MinVoltageMillivolt
function TMinVoltageMillivolt:init_from_obj(obj)
    self.MinVoltageMillivolt = obj.MinVoltageMillivolt
end

function TMinVoltageMillivolt:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMinVoltageMillivolt.group)
end

TMinVoltageMillivolt.from_obj = TMinVoltageMillivolt_from_obj

TMinVoltageMillivolt.proto_property = {'MinVoltageMillivolt'}

TMinVoltageMillivolt.default = {0}

TMinVoltageMillivolt.struct = {{name = 'MinVoltageMillivolt', is_array = false, struct = nil}}

function TMinVoltageMillivolt:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MinVoltageMillivolt', self.MinVoltageMillivolt, 'uint32', true, errs, need_convert)

    TMinVoltageMillivolt:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMinVoltageMillivolt.proto_property, errs, need_convert)
    return self
end

function TMinVoltageMillivolt:unpack(_)
    return self.MinVoltageMillivolt
end

Memory.MinVoltageMillivolt = TMinVoltageMillivolt

---@class Memory.SerialNumber
---@field SerialNumber string
local TSerialNumber = {}
TSerialNumber.__index = TSerialNumber
TSerialNumber.group = {}

local function TSerialNumber_from_obj(obj)
    return setmetatable(obj, TSerialNumber)
end

function TSerialNumber.new(SerialNumber)
    return TSerialNumber_from_obj({SerialNumber = SerialNumber})
end
---@param obj Memory.SerialNumber
function TSerialNumber:init_from_obj(obj)
    self.SerialNumber = obj.SerialNumber
end

function TSerialNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSerialNumber.group)
end

TSerialNumber.from_obj = TSerialNumber_from_obj

TSerialNumber.proto_property = {'SerialNumber'}

TSerialNumber.default = {''}

TSerialNumber.struct = {{name = 'SerialNumber', is_array = false, struct = nil}}

function TSerialNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SerialNumber', self.SerialNumber, 'string', true, errs, need_convert)

    TSerialNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSerialNumber.proto_property, errs, need_convert)
    return self
end

function TSerialNumber:unpack(_)
    return self.SerialNumber
end

Memory.SerialNumber = TSerialNumber

---@class Memory.RankCount
---@field RankCount integer
local TRankCount = {}
TRankCount.__index = TRankCount
TRankCount.group = {}

local function TRankCount_from_obj(obj)
    return setmetatable(obj, TRankCount)
end

function TRankCount.new(RankCount)
    return TRankCount_from_obj({RankCount = RankCount})
end
---@param obj Memory.RankCount
function TRankCount:init_from_obj(obj)
    self.RankCount = obj.RankCount
end

function TRankCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRankCount.group)
end

TRankCount.from_obj = TRankCount_from_obj

TRankCount.proto_property = {'RankCount'}

TRankCount.default = {0}

TRankCount.struct = {{name = 'RankCount', is_array = false, struct = nil}}

function TRankCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RankCount', self.RankCount, 'uint32', true, errs, need_convert)

    TRankCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRankCount.proto_property, errs, need_convert)
    return self
end

function TRankCount:unpack(_)
    return self.RankCount
end

Memory.RankCount = TRankCount

---@class Memory.OriginalPartNumber
---@field OriginalPartNumber string
local TOriginalPartNumber = {}
TOriginalPartNumber.__index = TOriginalPartNumber
TOriginalPartNumber.group = {}

local function TOriginalPartNumber_from_obj(obj)
    return setmetatable(obj, TOriginalPartNumber)
end

function TOriginalPartNumber.new(OriginalPartNumber)
    return TOriginalPartNumber_from_obj({OriginalPartNumber = OriginalPartNumber})
end
---@param obj Memory.OriginalPartNumber
function TOriginalPartNumber:init_from_obj(obj)
    self.OriginalPartNumber = obj.OriginalPartNumber
end

function TOriginalPartNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOriginalPartNumber.group)
end

TOriginalPartNumber.from_obj = TOriginalPartNumber_from_obj

TOriginalPartNumber.proto_property = {'OriginalPartNumber'}

TOriginalPartNumber.default = {''}

TOriginalPartNumber.struct = {{name = 'OriginalPartNumber', is_array = false, struct = nil}}

function TOriginalPartNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OriginalPartNumber', self.OriginalPartNumber, 'string', true, errs, need_convert)

    TOriginalPartNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOriginalPartNumber.proto_property, errs, need_convert)
    return self
end

function TOriginalPartNumber:unpack(_)
    return self.OriginalPartNumber
end

Memory.OriginalPartNumber = TOriginalPartNumber

---@class Memory.PartNumber
---@field PartNumber string
local TPartNumber = {}
TPartNumber.__index = TPartNumber
TPartNumber.group = {}

local function TPartNumber_from_obj(obj)
    return setmetatable(obj, TPartNumber)
end

function TPartNumber.new(PartNumber)
    return TPartNumber_from_obj({PartNumber = PartNumber})
end
---@param obj Memory.PartNumber
function TPartNumber:init_from_obj(obj)
    self.PartNumber = obj.PartNumber
end

function TPartNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPartNumber.group)
end

TPartNumber.from_obj = TPartNumber_from_obj

TPartNumber.proto_property = {'PartNumber'}

TPartNumber.default = {''}

TPartNumber.struct = {{name = 'PartNumber', is_array = false, struct = nil}}

function TPartNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PartNumber', self.PartNumber, 'string', true, errs, need_convert)

    TPartNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPartNumber.proto_property, errs, need_convert)
    return self
end

function TPartNumber:unpack(_)
    return self.PartNumber
end

Memory.PartNumber = TPartNumber

---@class Memory.OperatingSpeedMhz
---@field OperatingSpeedMhz integer
local TOperatingSpeedMhz = {}
TOperatingSpeedMhz.__index = TOperatingSpeedMhz
TOperatingSpeedMhz.group = {}

local function TOperatingSpeedMhz_from_obj(obj)
    return setmetatable(obj, TOperatingSpeedMhz)
end

function TOperatingSpeedMhz.new(OperatingSpeedMhz)
    return TOperatingSpeedMhz_from_obj({OperatingSpeedMhz = OperatingSpeedMhz})
end
---@param obj Memory.OperatingSpeedMhz
function TOperatingSpeedMhz:init_from_obj(obj)
    self.OperatingSpeedMhz = obj.OperatingSpeedMhz
end

function TOperatingSpeedMhz:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOperatingSpeedMhz.group)
end

TOperatingSpeedMhz.from_obj = TOperatingSpeedMhz_from_obj

TOperatingSpeedMhz.proto_property = {'OperatingSpeedMhz'}

TOperatingSpeedMhz.default = {0}

TOperatingSpeedMhz.struct = {{name = 'OperatingSpeedMhz', is_array = false, struct = nil}}

function TOperatingSpeedMhz:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OperatingSpeedMhz', self.OperatingSpeedMhz, 'uint32', true, errs, need_convert)

    TOperatingSpeedMhz:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOperatingSpeedMhz.proto_property, errs, need_convert)
    return self
end

function TOperatingSpeedMhz:unpack(_)
    return self.OperatingSpeedMhz
end

Memory.OperatingSpeedMhz = TOperatingSpeedMhz

---@class Memory.MemoryType
---@field MemoryType string
local TMemoryType = {}
TMemoryType.__index = TMemoryType
TMemoryType.group = {}

local function TMemoryType_from_obj(obj)
    return setmetatable(obj, TMemoryType)
end

function TMemoryType.new(MemoryType)
    return TMemoryType_from_obj({MemoryType = MemoryType})
end
---@param obj Memory.MemoryType
function TMemoryType:init_from_obj(obj)
    self.MemoryType = obj.MemoryType
end

function TMemoryType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMemoryType.group)
end

TMemoryType.from_obj = TMemoryType_from_obj

TMemoryType.proto_property = {'MemoryType'}

TMemoryType.default = {''}

TMemoryType.struct = {{name = 'MemoryType', is_array = false, struct = nil}}

function TMemoryType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MemoryType', self.MemoryType, 'string', true, errs, need_convert)

    TMemoryType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMemoryType.proto_property, errs, need_convert)
    return self
end

function TMemoryType:unpack(_)
    return self.MemoryType
end

Memory.MemoryType = TMemoryType

---@class Memory.MemorySubsystemControllerProductID
---@field MemorySubsystemControllerProductID string
local TMemorySubsystemControllerProductID = {}
TMemorySubsystemControllerProductID.__index = TMemorySubsystemControllerProductID
TMemorySubsystemControllerProductID.group = {}

local function TMemorySubsystemControllerProductID_from_obj(obj)
    return setmetatable(obj, TMemorySubsystemControllerProductID)
end

function TMemorySubsystemControllerProductID.new(MemorySubsystemControllerProductID)
    return TMemorySubsystemControllerProductID_from_obj({
        MemorySubsystemControllerProductID = MemorySubsystemControllerProductID
    })
end
---@param obj Memory.MemorySubsystemControllerProductID
function TMemorySubsystemControllerProductID:init_from_obj(obj)
    self.MemorySubsystemControllerProductID = obj.MemorySubsystemControllerProductID
end

function TMemorySubsystemControllerProductID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMemorySubsystemControllerProductID.group)
end

TMemorySubsystemControllerProductID.from_obj = TMemorySubsystemControllerProductID_from_obj

TMemorySubsystemControllerProductID.proto_property = {'MemorySubsystemControllerProductID'}

TMemorySubsystemControllerProductID.default = {''}

TMemorySubsystemControllerProductID.struct = {
    {name = 'MemorySubsystemControllerProductID', is_array = false, struct = nil}
}

function TMemorySubsystemControllerProductID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MemorySubsystemControllerProductID', self.MemorySubsystemControllerProductID, 'string',
        true, errs, need_convert)

    TMemorySubsystemControllerProductID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMemorySubsystemControllerProductID.proto_property, errs, need_convert)
    return self
end

function TMemorySubsystemControllerProductID:unpack(_)
    return self.MemorySubsystemControllerProductID
end

Memory.MemorySubsystemControllerProductID = TMemorySubsystemControllerProductID

---@class Memory.MemorySubsystemControllerManufacturerID
---@field MemorySubsystemControllerManufacturerID string
local TMemorySubsystemControllerManufacturerID = {}
TMemorySubsystemControllerManufacturerID.__index = TMemorySubsystemControllerManufacturerID
TMemorySubsystemControllerManufacturerID.group = {}

local function TMemorySubsystemControllerManufacturerID_from_obj(obj)
    return setmetatable(obj, TMemorySubsystemControllerManufacturerID)
end

function TMemorySubsystemControllerManufacturerID.new(MemorySubsystemControllerManufacturerID)
    return TMemorySubsystemControllerManufacturerID_from_obj({
        MemorySubsystemControllerManufacturerID = MemorySubsystemControllerManufacturerID
    })
end
---@param obj Memory.MemorySubsystemControllerManufacturerID
function TMemorySubsystemControllerManufacturerID:init_from_obj(obj)
    self.MemorySubsystemControllerManufacturerID = obj.MemorySubsystemControllerManufacturerID
end

function TMemorySubsystemControllerManufacturerID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMemorySubsystemControllerManufacturerID.group)
end

TMemorySubsystemControllerManufacturerID.from_obj = TMemorySubsystemControllerManufacturerID_from_obj

TMemorySubsystemControllerManufacturerID.proto_property = {'MemorySubsystemControllerManufacturerID'}

TMemorySubsystemControllerManufacturerID.default = {''}

TMemorySubsystemControllerManufacturerID.struct = {
    {name = 'MemorySubsystemControllerManufacturerID', is_array = false, struct = nil}
}

function TMemorySubsystemControllerManufacturerID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MemorySubsystemControllerManufacturerID', self.MemorySubsystemControllerManufacturerID,
        'string', true, errs, need_convert)

    TMemorySubsystemControllerManufacturerID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMemorySubsystemControllerManufacturerID.proto_property, errs, need_convert)
    return self
end

function TMemorySubsystemControllerManufacturerID:unpack(_)
    return self.MemorySubsystemControllerManufacturerID
end

Memory.MemorySubsystemControllerManufacturerID = TMemorySubsystemControllerManufacturerID

---@class Memory.MemoryDeviceType
---@field MemoryDeviceType string
local TMemoryDeviceType = {}
TMemoryDeviceType.__index = TMemoryDeviceType
TMemoryDeviceType.group = {}

local function TMemoryDeviceType_from_obj(obj)
    return setmetatable(obj, TMemoryDeviceType)
end

function TMemoryDeviceType.new(MemoryDeviceType)
    return TMemoryDeviceType_from_obj({MemoryDeviceType = MemoryDeviceType})
end
---@param obj Memory.MemoryDeviceType
function TMemoryDeviceType:init_from_obj(obj)
    self.MemoryDeviceType = obj.MemoryDeviceType
end

function TMemoryDeviceType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMemoryDeviceType.group)
end

TMemoryDeviceType.from_obj = TMemoryDeviceType_from_obj

TMemoryDeviceType.proto_property = {'MemoryDeviceType'}

TMemoryDeviceType.default = {''}

TMemoryDeviceType.struct = {{name = 'MemoryDeviceType', is_array = false, struct = nil}}

function TMemoryDeviceType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MemoryDeviceType', self.MemoryDeviceType, 'string', true, errs, need_convert)

    TMemoryDeviceType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMemoryDeviceType.proto_property, errs, need_convert)
    return self
end

function TMemoryDeviceType:unpack(_)
    return self.MemoryDeviceType
end

Memory.MemoryDeviceType = TMemoryDeviceType

---@class Memory.Manufacturer
---@field Manufacturer string
local TManufacturer = {}
TManufacturer.__index = TManufacturer
TManufacturer.group = {}

local function TManufacturer_from_obj(obj)
    return setmetatable(obj, TManufacturer)
end

function TManufacturer.new(Manufacturer)
    return TManufacturer_from_obj({Manufacturer = Manufacturer})
end
---@param obj Memory.Manufacturer
function TManufacturer:init_from_obj(obj)
    self.Manufacturer = obj.Manufacturer
end

function TManufacturer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManufacturer.group)
end

TManufacturer.from_obj = TManufacturer_from_obj

TManufacturer.proto_property = {'Manufacturer'}

TManufacturer.default = {''}

TManufacturer.struct = {{name = 'Manufacturer', is_array = false, struct = nil}}

function TManufacturer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Manufacturer', self.Manufacturer, 'string', true, errs, need_convert)

    TManufacturer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManufacturer.proto_property, errs, need_convert)
    return self
end

function TManufacturer:unpack(_)
    return self.Manufacturer
end

Memory.Manufacturer = TManufacturer

---@class Memory.FirmwareRevision
---@field FirmwareRevision string
local TFirmwareRevision = {}
TFirmwareRevision.__index = TFirmwareRevision
TFirmwareRevision.group = {}

local function TFirmwareRevision_from_obj(obj)
    return setmetatable(obj, TFirmwareRevision)
end

function TFirmwareRevision.new(FirmwareRevision)
    return TFirmwareRevision_from_obj({FirmwareRevision = FirmwareRevision})
end
---@param obj Memory.FirmwareRevision
function TFirmwareRevision:init_from_obj(obj)
    self.FirmwareRevision = obj.FirmwareRevision
end

function TFirmwareRevision:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFirmwareRevision.group)
end

TFirmwareRevision.from_obj = TFirmwareRevision_from_obj

TFirmwareRevision.proto_property = {'FirmwareRevision'}

TFirmwareRevision.default = {''}

TFirmwareRevision.struct = {{name = 'FirmwareRevision', is_array = false, struct = nil}}

function TFirmwareRevision:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirmwareRevision', self.FirmwareRevision, 'string', true, errs, need_convert)

    TFirmwareRevision:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFirmwareRevision.proto_property, errs, need_convert)
    return self
end

function TFirmwareRevision:unpack(_)
    return self.FirmwareRevision
end

Memory.FirmwareRevision = TFirmwareRevision

---@class Memory.DataWidthBits
---@field DataWidthBits integer
local TDataWidthBits = {}
TDataWidthBits.__index = TDataWidthBits
TDataWidthBits.group = {}

local function TDataWidthBits_from_obj(obj)
    return setmetatable(obj, TDataWidthBits)
end

function TDataWidthBits.new(DataWidthBits)
    return TDataWidthBits_from_obj({DataWidthBits = DataWidthBits})
end
---@param obj Memory.DataWidthBits
function TDataWidthBits:init_from_obj(obj)
    self.DataWidthBits = obj.DataWidthBits
end

function TDataWidthBits:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDataWidthBits.group)
end

TDataWidthBits.from_obj = TDataWidthBits_from_obj

TDataWidthBits.proto_property = {'DataWidthBits'}

TDataWidthBits.default = {0}

TDataWidthBits.struct = {{name = 'DataWidthBits', is_array = false, struct = nil}}

function TDataWidthBits:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DataWidthBits', self.DataWidthBits, 'uint32', true, errs, need_convert)

    TDataWidthBits:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDataWidthBits.proto_property, errs, need_convert)
    return self
end

function TDataWidthBits:unpack(_)
    return self.DataWidthBits
end

Memory.DataWidthBits = TDataWidthBits

---@class Memory.CapacityMiB
---@field CapacityMiB integer
local TCapacityMiB = {}
TCapacityMiB.__index = TCapacityMiB
TCapacityMiB.group = {}

local function TCapacityMiB_from_obj(obj)
    return setmetatable(obj, TCapacityMiB)
end

function TCapacityMiB.new(CapacityMiB)
    return TCapacityMiB_from_obj({CapacityMiB = CapacityMiB})
end
---@param obj Memory.CapacityMiB
function TCapacityMiB:init_from_obj(obj)
    self.CapacityMiB = obj.CapacityMiB
end

function TCapacityMiB:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCapacityMiB.group)
end

TCapacityMiB.from_obj = TCapacityMiB_from_obj

TCapacityMiB.proto_property = {'CapacityMiB'}

TCapacityMiB.default = {0}

TCapacityMiB.struct = {{name = 'CapacityMiB', is_array = false, struct = nil}}

function TCapacityMiB:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CapacityMiB', self.CapacityMiB, 'uint32', true, errs, need_convert)

    TCapacityMiB:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCapacityMiB.proto_property, errs, need_convert)
    return self
end

function TCapacityMiB:unpack(_)
    return self.CapacityMiB
end

Memory.CapacityMiB = TCapacityMiB

---@class Memory.BaseModuleType
---@field BaseModuleType string
local TBaseModuleType = {}
TBaseModuleType.__index = TBaseModuleType
TBaseModuleType.group = {}

local function TBaseModuleType_from_obj(obj)
    return setmetatable(obj, TBaseModuleType)
end

function TBaseModuleType.new(BaseModuleType)
    return TBaseModuleType_from_obj({BaseModuleType = BaseModuleType})
end
---@param obj Memory.BaseModuleType
function TBaseModuleType:init_from_obj(obj)
    self.BaseModuleType = obj.BaseModuleType
end

function TBaseModuleType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBaseModuleType.group)
end

TBaseModuleType.from_obj = TBaseModuleType_from_obj

TBaseModuleType.proto_property = {'BaseModuleType'}

TBaseModuleType.default = {''}

TBaseModuleType.struct = {{name = 'BaseModuleType', is_array = false, struct = nil}}

function TBaseModuleType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BaseModuleType', self.BaseModuleType, 'string', true, errs, need_convert)

    TBaseModuleType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBaseModuleType.proto_property, errs, need_convert)
    return self
end

function TBaseModuleType:unpack(_)
    return self.BaseModuleType
end

Memory.BaseModuleType = TBaseModuleType

---@class Memory.AllowedSpeedsMHz
---@field AllowedSpeedsMHz integer
local TAllowedSpeedsMHz = {}
TAllowedSpeedsMHz.__index = TAllowedSpeedsMHz
TAllowedSpeedsMHz.group = {}

local function TAllowedSpeedsMHz_from_obj(obj)
    return setmetatable(obj, TAllowedSpeedsMHz)
end

function TAllowedSpeedsMHz.new(AllowedSpeedsMHz)
    return TAllowedSpeedsMHz_from_obj({AllowedSpeedsMHz = AllowedSpeedsMHz})
end
---@param obj Memory.AllowedSpeedsMHz
function TAllowedSpeedsMHz:init_from_obj(obj)
    self.AllowedSpeedsMHz = obj.AllowedSpeedsMHz
end

function TAllowedSpeedsMHz:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAllowedSpeedsMHz.group)
end

TAllowedSpeedsMHz.from_obj = TAllowedSpeedsMHz_from_obj

TAllowedSpeedsMHz.proto_property = {'AllowedSpeedsMHz'}

TAllowedSpeedsMHz.default = {0}

TAllowedSpeedsMHz.struct = {{name = 'AllowedSpeedsMHz', is_array = false, struct = nil}}

function TAllowedSpeedsMHz:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AllowedSpeedsMHz', self.AllowedSpeedsMHz, 'uint32', true, errs, need_convert)

    TAllowedSpeedsMHz:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAllowedSpeedsMHz.proto_property, errs, need_convert)
    return self
end

function TAllowedSpeedsMHz:unpack(_)
    return self.AllowedSpeedsMHz
end

Memory.AllowedSpeedsMHz = TAllowedSpeedsMHz

---@class Memory.DimmId
---@field DimmId integer
local TDimmId = {}
TDimmId.__index = TDimmId
TDimmId.group = {}

local function TDimmId_from_obj(obj)
    return setmetatable(obj, TDimmId)
end

function TDimmId.new(DimmId)
    return TDimmId_from_obj({DimmId = DimmId})
end
---@param obj Memory.DimmId
function TDimmId:init_from_obj(obj)
    self.DimmId = obj.DimmId
end

function TDimmId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDimmId.group)
end

TDimmId.from_obj = TDimmId_from_obj

TDimmId.proto_property = {'DimmId'}

TDimmId.default = {0}

TDimmId.struct = {{name = 'DimmId', is_array = false, struct = nil}}

function TDimmId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DimmId', self.DimmId, 'uint8', true, errs, need_convert)

    TDimmId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDimmId.proto_property, errs, need_convert)
    return self
end

function TDimmId:unpack(_)
    return self.DimmId
end

Memory.DimmId = TDimmId

---@class Memory.LogicalChannelId
---@field LogicalChannelId integer
local TLogicalChannelId = {}
TLogicalChannelId.__index = TLogicalChannelId
TLogicalChannelId.group = {}

local function TLogicalChannelId_from_obj(obj)
    return setmetatable(obj, TLogicalChannelId)
end

function TLogicalChannelId.new(LogicalChannelId)
    return TLogicalChannelId_from_obj({LogicalChannelId = LogicalChannelId})
end
---@param obj Memory.LogicalChannelId
function TLogicalChannelId:init_from_obj(obj)
    self.LogicalChannelId = obj.LogicalChannelId
end

function TLogicalChannelId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLogicalChannelId.group)
end

TLogicalChannelId.from_obj = TLogicalChannelId_from_obj

TLogicalChannelId.proto_property = {'LogicalChannelId'}

TLogicalChannelId.default = {0}

TLogicalChannelId.struct = {{name = 'LogicalChannelId', is_array = false, struct = nil}}

function TLogicalChannelId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LogicalChannelId', self.LogicalChannelId, 'uint8', true, errs, need_convert)

    TLogicalChannelId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLogicalChannelId.proto_property, errs, need_convert)
    return self
end

function TLogicalChannelId:unpack(_)
    return self.LogicalChannelId
end

Memory.LogicalChannelId = TLogicalChannelId

---@class Memory.ChannelId
---@field ChannelId integer
local TChannelId = {}
TChannelId.__index = TChannelId
TChannelId.group = {}

local function TChannelId_from_obj(obj)
    return setmetatable(obj, TChannelId)
end

function TChannelId.new(ChannelId)
    return TChannelId_from_obj({ChannelId = ChannelId})
end
---@param obj Memory.ChannelId
function TChannelId:init_from_obj(obj)
    self.ChannelId = obj.ChannelId
end

function TChannelId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChannelId.group)
end

TChannelId.from_obj = TChannelId_from_obj

TChannelId.proto_property = {'ChannelId'}

TChannelId.default = {0}

TChannelId.struct = {{name = 'ChannelId', is_array = false, struct = nil}}

function TChannelId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChannelId', self.ChannelId, 'uint8', true, errs, need_convert)

    TChannelId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChannelId.proto_property, errs, need_convert)
    return self
end

function TChannelId:unpack(_)
    return self.ChannelId
end

Memory.ChannelId = TChannelId

---@class Memory.NodeId
---@field NodeId integer
local TNodeId = {}
TNodeId.__index = TNodeId
TNodeId.group = {}

local function TNodeId_from_obj(obj)
    return setmetatable(obj, TNodeId)
end

function TNodeId.new(NodeId)
    return TNodeId_from_obj({NodeId = NodeId})
end
---@param obj Memory.NodeId
function TNodeId:init_from_obj(obj)
    self.NodeId = obj.NodeId
end

function TNodeId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNodeId.group)
end

TNodeId.from_obj = TNodeId_from_obj

TNodeId.proto_property = {'NodeId'}

TNodeId.default = {0}

TNodeId.struct = {{name = 'NodeId', is_array = false, struct = nil}}

function TNodeId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NodeId', self.NodeId, 'uint8', true, errs, need_convert)

    TNodeId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNodeId.proto_property, errs, need_convert)
    return self
end

function TNodeId:unpack(_)
    return self.NodeId
end

Memory.NodeId = TNodeId

---@class Memory.CpuId
---@field CpuId integer
local TCpuId = {}
TCpuId.__index = TCpuId
TCpuId.group = {}

local function TCpuId_from_obj(obj)
    return setmetatable(obj, TCpuId)
end

function TCpuId.new(CpuId)
    return TCpuId_from_obj({CpuId = CpuId})
end
---@param obj Memory.CpuId
function TCpuId:init_from_obj(obj)
    self.CpuId = obj.CpuId
end

function TCpuId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpuId.group)
end

TCpuId.from_obj = TCpuId_from_obj

TCpuId.proto_property = {'CpuId'}

TCpuId.default = {0}

TCpuId.struct = {{name = 'CpuId', is_array = false, struct = nil}}

function TCpuId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CpuId', self.CpuId, 'uint8', true, errs, need_convert)

    TCpuId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpuId.proto_property, errs, need_convert)
    return self
end

function TCpuId:unpack(_)
    return self.CpuId
end

Memory.CpuId = TCpuId

---@class Memory.Presence
---@field Presence integer
local TPresence = {}
TPresence.__index = TPresence
TPresence.group = {}

local function TPresence_from_obj(obj)
    return setmetatable(obj, TPresence)
end

function TPresence.new(Presence)
    return TPresence_from_obj({Presence = Presence})
end
---@param obj Memory.Presence
function TPresence:init_from_obj(obj)
    self.Presence = obj.Presence
end

function TPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPresence.group)
end

TPresence.from_obj = TPresence_from_obj

TPresence.proto_property = {'Presence'}

TPresence.default = {0}

TPresence.struct = {{name = 'Presence', is_array = false, struct = nil}}

function TPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Presence', self.Presence, 'uint8', true, errs, need_convert)

    TPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPresence.proto_property, errs, need_convert)
    return self
end

function TPresence:unpack(_)
    return self.Presence
end

Memory.Presence = TPresence

---@class Memory.DimmName
---@field DimmName string
local TDimmName = {}
TDimmName.__index = TDimmName
TDimmName.group = {}

local function TDimmName_from_obj(obj)
    return setmetatable(obj, TDimmName)
end

function TDimmName.new(DimmName)
    return TDimmName_from_obj({DimmName = DimmName})
end
---@param obj Memory.DimmName
function TDimmName:init_from_obj(obj)
    self.DimmName = obj.DimmName
end

function TDimmName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDimmName.group)
end

TDimmName.from_obj = TDimmName_from_obj

TDimmName.proto_property = {'DimmName'}

TDimmName.default = {''}

TDimmName.struct = {{name = 'DimmName', is_array = false, struct = nil}}

function TDimmName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DimmName', self.DimmName, 'string', true, errs, need_convert)

    TDimmName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDimmName.proto_property, errs, need_convert)
    return self
end

function TDimmName:unpack(_)
    return self.DimmName
end

Memory.DimmName = TDimmName

---@class Memory.Name
---@field Name string
local TName = {}
TName.__index = TName
TName.group = {}

local function TName_from_obj(obj)
    return setmetatable(obj, TName)
end

function TName.new(Name)
    return TName_from_obj({Name = Name})
end
---@param obj Memory.Name
function TName:init_from_obj(obj)
    self.Name = obj.Name
end

function TName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TName.group)
end

TName.from_obj = TName_from_obj

TName.proto_property = {'Name'}

TName.default = {''}

TName.struct = {{name = 'Name', is_array = false, struct = nil}}

function TName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Name', self.Name, 'string', true, errs, need_convert)

    TName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TName.proto_property, errs, need_convert)
    return self
end

function TName:unpack(_)
    return self.Name
end

Memory.Name = TName

---@class Memory.SystemId
---@field SystemId integer
local TSystemId = {}
TSystemId.__index = TSystemId
TSystemId.group = {}

local function TSystemId_from_obj(obj)
    return setmetatable(obj, TSystemId)
end

function TSystemId.new(SystemId)
    return TSystemId_from_obj({SystemId = SystemId})
end
---@param obj Memory.SystemId
function TSystemId:init_from_obj(obj)
    self.SystemId = obj.SystemId
end

function TSystemId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemId.group)
end

TSystemId.from_obj = TSystemId_from_obj

TSystemId.proto_property = {'SystemId'}

TSystemId.default = {0}

TSystemId.struct = {{name = 'SystemId', is_array = false, struct = nil}}

function TSystemId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'uint8', true, errs, need_convert)

    TSystemId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemId.proto_property, errs, need_convert)
    return self
end

function TSystemId:unpack(_)
    return self.SystemId
end

Memory.SystemId = TSystemId

Memory.interface = mdb.register_interface('bmc.kepler.Systems.Memory', {
    SystemId = {'y', nil, true, nil, false},
    Name = {'s', nil, true, nil, false},
    DimmName = {'s', nil, true, nil, false},
    Presence = {'y', nil, true, nil, false},
    CpuId = {'y', nil, true, nil, false},
    NodeId = {'y', nil, true, nil, false},
    ChannelId = {'y', nil, true, nil, false},
    LogicalChannelId = {'y', nil, true, nil, false},
    DimmId = {'y', nil, true, nil, false},
    AllowedSpeedsMHz = {'u', {'EMIT_CHANGE'}, true, nil, false},
    BaseModuleType = {'s', nil, true, nil, false},
    CapacityMiB = {'u', nil, true, nil, false},
    DataWidthBits = {'u', nil, true, nil, false},
    FirmwareRevision = {'s', nil, true, nil, false},
    Manufacturer = {'s', nil, true, nil, false},
    MemoryDeviceType = {'s', nil, true, nil, false},
    MemorySubsystemControllerManufacturerID = {'s', nil, true, nil, false},
    MemorySubsystemControllerProductID = {'s', nil, true, nil, false},
    MemoryType = {'s', nil, true, nil, false},
    OperatingSpeedMhz = {'u', nil, true, nil, false},
    PartNumber = {'s', nil, true, nil, false},
    OriginalPartNumber = {'s', nil, true, nil, false},
    RankCount = {'u', nil, true, nil, false},
    SerialNumber = {'s', nil, true, nil, false},
    MinVoltageMillivolt = {'u', nil, true, nil, false},
    Position = {'s', nil, true, nil, false},
    DiagnosticFault = {'y', nil, false, 0, false},
    PredictiveFault = {'y', nil, true, 0, false},
    DeviceLocator = {'s', nil, true, nil, false},
    Health = {'y', nil, true, nil, false},
    DimmNum = {'y', nil, true, nil, false},
    BOM = {'s', nil, true, nil, false},
    ManufacturerID = {'s', nil, true, nil, false},
    ManufacturingDate = {'s', nil, true, nil, false},
    ManufacturingLocation = {'s', {'EMIT_CHANGE'}, true, nil, false},
    ChipBitWidth = {'s', nil, true, nil, false},
    TemperatureCelsius = {'d', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    SilkText = {'s', {}, true, nil, false},
    ErrorCorrection = {'s', {}, true, nil, false}
}, {}, {})

return Memory
