-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local FirmwareMatchRules = {}

---@class FirmwareMatchRules.KeyValueTable
---@field key string
---@field value string
local TKeyValueTable = {}
TKeyValueTable.__index = TKeyValueTable
TKeyValueTable.group = {}

local function TKeyValueTable_from_obj(obj)
    return setmetatable(obj, TKeyValueTable)
end

function TKeyValueTable.new(dict)
    return TKeyValueTable_from_obj(dict)
end

---@param obj FirmwareMatchRules.KeyValueTable
function TKeyValueTable:init_from_obj(obj)
    self = obj
end

function TKeyValueTable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TKeyValueTable.group)
end

TKeyValueTable.from_obj = TKeyValueTable_from_obj

TKeyValueTable.proto_property = {}

TKeyValueTable.default = {}

TKeyValueTable.struct = {}

function TKeyValueTable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TKeyValueTable:remove_error_props(errs, self)
    return self
end

function TKeyValueTable:unpack(_)
    return self
end

FirmwareMatchRules.KeyValueTable = TKeyValueTable

---@class FirmwareMatchRules.GetMatchRulesRsp
---@field Rules FirmwareMatchRules.KeyValueTable
local TGetMatchRulesRsp = {}
TGetMatchRulesRsp.__index = TGetMatchRulesRsp
TGetMatchRulesRsp.group = {}

local function TGetMatchRulesRsp_from_obj(obj)
    return setmetatable(obj, TGetMatchRulesRsp)
end

function TGetMatchRulesRsp.new(Rules)
    return TGetMatchRulesRsp_from_obj({Rules = Rules})
end
---@param obj FirmwareMatchRules.GetMatchRulesRsp
function TGetMatchRulesRsp:init_from_obj(obj)
    self.Rules = obj.Rules
end

function TGetMatchRulesRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetMatchRulesRsp.group)
end

TGetMatchRulesRsp.from_obj = TGetMatchRulesRsp_from_obj

TGetMatchRulesRsp.proto_property = {'Rules'}

TGetMatchRulesRsp.default = {FirmwareMatchRules.KeyValueTable.default}

TGetMatchRulesRsp.struct = {{name = 'Rules', is_array = false, struct = FirmwareMatchRules.KeyValueTable.struct}}

function TGetMatchRulesRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    FirmwareMatchRules.KeyValueTable.new(self.Rules):validate(prefix, errs, need_convert)

    TGetMatchRulesRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetMatchRulesRsp.proto_property, errs, need_convert)
    return self
end

function TGetMatchRulesRsp:unpack(_)
    return self.Rules
end

FirmwareMatchRules.GetMatchRulesRsp = TGetMatchRulesRsp

---@class FirmwareMatchRules.GetMatchRulesReq
local TGetMatchRulesReq = {}
TGetMatchRulesReq.__index = TGetMatchRulesReq
TGetMatchRulesReq.group = {}

local function TGetMatchRulesReq_from_obj(obj)
    return setmetatable(obj, TGetMatchRulesReq)
end

function TGetMatchRulesReq.new()
    return TGetMatchRulesReq_from_obj({})
end
---@param obj FirmwareMatchRules.GetMatchRulesReq
function TGetMatchRulesReq:init_from_obj(obj)

end

function TGetMatchRulesReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetMatchRulesReq.group)
end

TGetMatchRulesReq.from_obj = TGetMatchRulesReq_from_obj

TGetMatchRulesReq.proto_property = {}

TGetMatchRulesReq.default = {}

TGetMatchRulesReq.struct = {}

function TGetMatchRulesReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetMatchRulesReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetMatchRulesReq.proto_property, errs, need_convert)
    return self
end

function TGetMatchRulesReq:unpack(_)
end

FirmwareMatchRules.GetMatchRulesReq = TGetMatchRulesReq

---@class FirmwareMatchRules.DeleteMatchRulesRsp
local TDeleteMatchRulesRsp = {}
TDeleteMatchRulesRsp.__index = TDeleteMatchRulesRsp
TDeleteMatchRulesRsp.group = {}

local function TDeleteMatchRulesRsp_from_obj(obj)
    return setmetatable(obj, TDeleteMatchRulesRsp)
end

function TDeleteMatchRulesRsp.new()
    return TDeleteMatchRulesRsp_from_obj({})
end
---@param obj FirmwareMatchRules.DeleteMatchRulesRsp
function TDeleteMatchRulesRsp:init_from_obj(obj)

end

function TDeleteMatchRulesRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteMatchRulesRsp.group)
end

TDeleteMatchRulesRsp.from_obj = TDeleteMatchRulesRsp_from_obj

TDeleteMatchRulesRsp.proto_property = {}

TDeleteMatchRulesRsp.default = {}

TDeleteMatchRulesRsp.struct = {}

function TDeleteMatchRulesRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDeleteMatchRulesRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteMatchRulesRsp.proto_property, errs, need_convert)
    return self
end

function TDeleteMatchRulesRsp:unpack(_)
end

FirmwareMatchRules.DeleteMatchRulesRsp = TDeleteMatchRulesRsp

---@class FirmwareMatchRules.DeleteMatchRulesReq
---@field RuleKeys string[]
local TDeleteMatchRulesReq = {}
TDeleteMatchRulesReq.__index = TDeleteMatchRulesReq
TDeleteMatchRulesReq.group = {}

local function TDeleteMatchRulesReq_from_obj(obj)
    return setmetatable(obj, TDeleteMatchRulesReq)
end

function TDeleteMatchRulesReq.new(RuleKeys)
    return TDeleteMatchRulesReq_from_obj({RuleKeys = RuleKeys})
end
---@param obj FirmwareMatchRules.DeleteMatchRulesReq
function TDeleteMatchRulesReq:init_from_obj(obj)
    self.RuleKeys = obj.RuleKeys
end

function TDeleteMatchRulesReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteMatchRulesReq.group)
end

TDeleteMatchRulesReq.from_obj = TDeleteMatchRulesReq_from_obj

TDeleteMatchRulesReq.proto_property = {'RuleKeys'}

TDeleteMatchRulesReq.default = {{}}

TDeleteMatchRulesReq.struct = {{name = 'RuleKeys', is_array = true, struct = nil}}

function TDeleteMatchRulesReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RuleKeys', self.RuleKeys, 'string', false, errs, need_convert)

    TDeleteMatchRulesReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteMatchRulesReq.proto_property, errs, need_convert)
    return self
end

function TDeleteMatchRulesReq:unpack(_)
    return self.RuleKeys
end

FirmwareMatchRules.DeleteMatchRulesReq = TDeleteMatchRulesReq

---@class FirmwareMatchRules.AddMatchRulesRsp
local TAddMatchRulesRsp = {}
TAddMatchRulesRsp.__index = TAddMatchRulesRsp
TAddMatchRulesRsp.group = {}

local function TAddMatchRulesRsp_from_obj(obj)
    return setmetatable(obj, TAddMatchRulesRsp)
end

function TAddMatchRulesRsp.new()
    return TAddMatchRulesRsp_from_obj({})
end
---@param obj FirmwareMatchRules.AddMatchRulesRsp
function TAddMatchRulesRsp:init_from_obj(obj)

end

function TAddMatchRulesRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddMatchRulesRsp.group)
end

TAddMatchRulesRsp.from_obj = TAddMatchRulesRsp_from_obj

TAddMatchRulesRsp.proto_property = {}

TAddMatchRulesRsp.default = {}

TAddMatchRulesRsp.struct = {}

function TAddMatchRulesRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TAddMatchRulesRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddMatchRulesRsp.proto_property, errs, need_convert)
    return self
end

function TAddMatchRulesRsp:unpack(_)
end

FirmwareMatchRules.AddMatchRulesRsp = TAddMatchRulesRsp

---@class FirmwareMatchRules.AddMatchRulesReq
---@field Rules FirmwareMatchRules.KeyValueTable
local TAddMatchRulesReq = {}
TAddMatchRulesReq.__index = TAddMatchRulesReq
TAddMatchRulesReq.group = {}

local function TAddMatchRulesReq_from_obj(obj)
    return setmetatable(obj, TAddMatchRulesReq)
end

function TAddMatchRulesReq.new(Rules)
    return TAddMatchRulesReq_from_obj({Rules = Rules})
end
---@param obj FirmwareMatchRules.AddMatchRulesReq
function TAddMatchRulesReq:init_from_obj(obj)
    self.Rules = obj.Rules
end

function TAddMatchRulesReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddMatchRulesReq.group)
end

TAddMatchRulesReq.from_obj = TAddMatchRulesReq_from_obj

TAddMatchRulesReq.proto_property = {'Rules'}

TAddMatchRulesReq.default = {FirmwareMatchRules.KeyValueTable.default}

TAddMatchRulesReq.struct = {{name = 'Rules', is_array = false, struct = FirmwareMatchRules.KeyValueTable.struct}}

function TAddMatchRulesReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    FirmwareMatchRules.KeyValueTable.new(self.Rules):validate(prefix, errs, need_convert)

    TAddMatchRulesReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddMatchRulesReq.proto_property, errs, need_convert)
    return self
end

function TAddMatchRulesReq:unpack(_)
    return self.Rules
end

FirmwareMatchRules.AddMatchRulesReq = TAddMatchRulesReq

FirmwareMatchRules.interface = mdb.register_interface('bmc.kepler.UpdateService.FirmwareMatchRules', {}, {
    AddMatchRules = {'a{ss}a{ss}', '', TAddMatchRulesReq, TAddMatchRulesRsp},
    DeleteMatchRules = {'a{ss}as', '', TDeleteMatchRulesReq, TDeleteMatchRulesRsp},
    GetMatchRules = {'a{ss}', 'a{ss}', TGetMatchRulesReq, TGetMatchRulesRsp}
}, {})

return FirmwareMatchRules
