-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local BootOptions = {}

---@class BootOptions.PreviousBootSourceOverrideTarget
---@field PreviousBootSourceOverrideTarget string
local TPreviousBootSourceOverrideTarget = {}
TPreviousBootSourceOverrideTarget.__index = TPreviousBootSourceOverrideTarget
TPreviousBootSourceOverrideTarget.group = {}

local function TPreviousBootSourceOverrideTarget_from_obj(obj)
    return setmetatable(obj, TPreviousBootSourceOverrideTarget)
end

function TPreviousBootSourceOverrideTarget.new(PreviousBootSourceOverrideTarget)
    return TPreviousBootSourceOverrideTarget_from_obj({
        PreviousBootSourceOverrideTarget = PreviousBootSourceOverrideTarget or
            [=[]=]
    })
end
---@param obj BootOptions.PreviousBootSourceOverrideTarget
function TPreviousBootSourceOverrideTarget:init_from_obj(obj)
    self.PreviousBootSourceOverrideTarget =
        obj.PreviousBootSourceOverrideTarget or [=[]=]
end

function TPreviousBootSourceOverrideTarget:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs,
                                    TPreviousBootSourceOverrideTarget.group)
end

TPreviousBootSourceOverrideTarget.from_obj =
    TPreviousBootSourceOverrideTarget_from_obj

TPreviousBootSourceOverrideTarget.proto_property = {
    'PreviousBootSourceOverrideTarget'
}

TPreviousBootSourceOverrideTarget.default = {''}

TPreviousBootSourceOverrideTarget.struct = {
    {name = 'PreviousBootSourceOverrideTarget', is_array = false, struct = nil}
}

function TPreviousBootSourceOverrideTarget:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PreviousBootSourceOverrideTarget',
                      self.PreviousBootSourceOverrideTarget, "string", true,
                      errs, need_convert)

    TPreviousBootSourceOverrideTarget:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self,
                                 TPreviousBootSourceOverrideTarget.proto_property,
                                 errs, need_convert)
    return self
end

function TPreviousBootSourceOverrideTarget:unpack(_)
    return self.PreviousBootSourceOverrideTarget
end

BootOptions.PreviousBootSourceOverrideTarget = TPreviousBootSourceOverrideTarget

---@class BootOptions.BootOptionPolicy
---@field BootOptionPolicy integer
local TBootOptionPolicy = {}
TBootOptionPolicy.__index = TBootOptionPolicy
TBootOptionPolicy.group = {}

local function TBootOptionPolicy_from_obj(obj)
    return setmetatable(obj, TBootOptionPolicy)
end

function TBootOptionPolicy.new(BootOptionPolicy)
    return
        TBootOptionPolicy_from_obj({BootOptionPolicy = BootOptionPolicy or 0})
end
---@param obj BootOptions.BootOptionPolicy
function TBootOptionPolicy:init_from_obj(obj)
    self.BootOptionPolicy = obj.BootOptionPolicy or 0
end

function TBootOptionPolicy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootOptionPolicy.group)
end

TBootOptionPolicy.from_obj = TBootOptionPolicy_from_obj

TBootOptionPolicy.proto_property = {'BootOptionPolicy'}

TBootOptionPolicy.default = {0}

TBootOptionPolicy.struct = {
    {name = 'BootOptionPolicy', is_array = false, struct = nil}
}

function TBootOptionPolicy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootOptionPolicy', self.BootOptionPolicy,
                      "uint8", false, errs, need_convert)

    TBootOptionPolicy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootOptionPolicy.proto_property, errs,
                                 need_convert)
    return self
end

function TBootOptionPolicy:unpack(_) return self.BootOptionPolicy end

BootOptions.BootOptionPolicy = TBootOptionPolicy

---@class BootOptions.BootModeIpmiSettable
---@field BootModeIpmiSettable boolean
local TBootModeIpmiSettable = {}
TBootModeIpmiSettable.__index = TBootModeIpmiSettable
TBootModeIpmiSettable.group = {}

local function TBootModeIpmiSettable_from_obj(obj)
    return setmetatable(obj, TBootModeIpmiSettable)
end

function TBootModeIpmiSettable.new(BootModeIpmiSettable)
    return TBootModeIpmiSettable_from_obj({
        BootModeIpmiSettable = BootModeIpmiSettable == nil and true or BootModeIpmiSettable
    })
end
---@param obj BootOptions.BootModeIpmiSettable
function TBootModeIpmiSettable:init_from_obj(obj)
    self.BootModeIpmiSettable = obj.BootModeIpmiSettable == nil and true or obj.BootModeIpmiSettable
end

function TBootModeIpmiSettable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootModeIpmiSettable.group)
end

TBootModeIpmiSettable.from_obj = TBootModeIpmiSettable_from_obj

TBootModeIpmiSettable.proto_property = {'BootModeIpmiSettable'}

TBootModeIpmiSettable.default = {false}

TBootModeIpmiSettable.struct = {{name = 'BootModeIpmiSettable', is_array = false, struct = nil}}

function TBootModeIpmiSettable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootModeIpmiSettable', self.BootModeIpmiSettable, 'bool', true, errs, need_convert)

    TBootModeIpmiSettable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootModeIpmiSettable.proto_property, errs, need_convert)
    return self
end

function TBootModeIpmiSettable:unpack(_)
    return self.BootModeIpmiSettable
end

BootOptions.BootModeIpmiSettable = TBootModeIpmiSettable

---@class BootOptions.BootModeSupport
---@field BootModeSupport boolean
local TBootModeSupport = {}
TBootModeSupport.__index = TBootModeSupport
TBootModeSupport.group = {}

local function TBootModeSupport_from_obj(obj)
    return setmetatable(obj, TBootModeSupport)
end

function TBootModeSupport.new(BootModeSupport)
    return TBootModeSupport_from_obj({BootModeSupport = BootModeSupport == nil and true or BootModeSupport})
end
---@param obj BootOptions.BootModeSupport
function TBootModeSupport:init_from_obj(obj)
    self.BootModeSupport = obj.BootModeSupport == nil and true or obj.BootModeSupport
end

function TBootModeSupport:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootModeSupport.group)
end

TBootModeSupport.from_obj = TBootModeSupport_from_obj

TBootModeSupport.proto_property = {'BootModeSupport'}

TBootModeSupport.default = {false}

TBootModeSupport.struct = {{name = 'BootModeSupport', is_array = false, struct = nil}}

function TBootModeSupport:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootModeSupport', self.BootModeSupport, 'bool', true, errs, need_convert)

    TBootModeSupport:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootModeSupport.proto_property, errs, need_convert)
    return self
end

function TBootModeSupport:unpack(_)
    return self.BootModeSupport
end

BootOptions.BootModeSupport = TBootModeSupport

---@class BootOptions.BootOrder
---@field BootOrder string[]
local TBootOrder = {}
TBootOrder.__index = TBootOrder
TBootOrder.group = {}

local function TBootOrder_from_obj(obj)
    return setmetatable(obj, TBootOrder)
end

function TBootOrder.new(BootOrder)
    return TBootOrder_from_obj({BootOrder = BootOrder})
end
---@param obj BootOptions.BootOrder
function TBootOrder:init_from_obj(obj)
    self.BootOrder = obj.BootOrder
end

function TBootOrder:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootOrder.group)
end

TBootOrder.from_obj = TBootOrder_from_obj

TBootOrder.proto_property = {'BootOrder'}

TBootOrder.default = {{}}

TBootOrder.struct = {{name = 'BootOrder', is_array = true, struct = nil}}

function TBootOrder:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'BootOrder', self.BootOrder, 'string', true, errs, need_convert)

    TBootOrder:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootOrder.proto_property, errs, need_convert)
    return self
end

function TBootOrder:unpack(_)
    return self.BootOrder
end

BootOptions.BootOrder = TBootOrder

---@class BootOptions.BootOptionReference
---@field BootOptionReference string[]
local TBootOptionReference = {}
TBootOptionReference.__index = TBootOptionReference
TBootOptionReference.group = {}

local function TBootOptionReference_from_obj(obj)
    return setmetatable(obj, TBootOptionReference)
end

function TBootOptionReference.new(BootOptionReference)
    return TBootOptionReference_from_obj({BootOptionReference = BootOptionReference})
end
---@param obj BootOptions.BootOptionReference
function TBootOptionReference:init_from_obj(obj)
    self.BootOptionReference = obj.BootOptionReference
end

function TBootOptionReference:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootOptionReference.group)
end

TBootOptionReference.from_obj = TBootOptionReference_from_obj

TBootOptionReference.proto_property = {'BootOptionReference'}

TBootOptionReference.default = {{}}

TBootOptionReference.struct = {{name = 'BootOptionReference', is_array = true, struct = nil}}

function TBootOptionReference:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'BootOptionReference', self.BootOptionReference, 'string', true, errs, need_convert)

    TBootOptionReference:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootOptionReference.proto_property, errs, need_convert)
    return self
end

function TBootOptionReference:unpack(_)
    return self.BootOptionReference
end

BootOptions.BootOptionReference = TBootOptionReference

---@class BootOptions.BootSourceOverrideTarget
---@field BootSourceOverrideTarget string
local TBootSourceOverrideTarget = {}
TBootSourceOverrideTarget.__index = TBootSourceOverrideTarget
TBootSourceOverrideTarget.group = {}

local function TBootSourceOverrideTarget_from_obj(obj)
    return setmetatable(obj, TBootSourceOverrideTarget)
end

function TBootSourceOverrideTarget.new(BootSourceOverrideTarget)
    return TBootSourceOverrideTarget_from_obj({BootSourceOverrideTarget = BootSourceOverrideTarget or [=[HDD]=]})
end
---@param obj BootOptions.BootSourceOverrideTarget
function TBootSourceOverrideTarget:init_from_obj(obj)
    self.BootSourceOverrideTarget = obj.BootSourceOverrideTarget or [=[HDD]=]
end

function TBootSourceOverrideTarget:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootSourceOverrideTarget.group)
end

TBootSourceOverrideTarget.from_obj = TBootSourceOverrideTarget_from_obj

TBootSourceOverrideTarget.proto_property = {'BootSourceOverrideTarget'}

TBootSourceOverrideTarget.default = {''}

TBootSourceOverrideTarget.struct = {{name = 'BootSourceOverrideTarget', is_array = false, struct = nil}}

function TBootSourceOverrideTarget:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootSourceOverrideTarget', self.BootSourceOverrideTarget, 'string', true, errs,
        need_convert)

    TBootSourceOverrideTarget:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootSourceOverrideTarget.proto_property, errs, need_convert)
    return self
end

function TBootSourceOverrideTarget:unpack(_)
    return self.BootSourceOverrideTarget
end

BootOptions.BootSourceOverrideTarget = TBootSourceOverrideTarget

---@class BootOptions.BootSourceOverrideEnabled
---@field BootSourceOverrideEnabled string
local TBootSourceOverrideEnabled = {}
TBootSourceOverrideEnabled.__index = TBootSourceOverrideEnabled
TBootSourceOverrideEnabled.group = {}

local function TBootSourceOverrideEnabled_from_obj(obj)
    return setmetatable(obj, TBootSourceOverrideEnabled)
end

function TBootSourceOverrideEnabled.new(BootSourceOverrideEnabled)
    return
        TBootSourceOverrideEnabled_from_obj({BootSourceOverrideEnabled = BootSourceOverrideEnabled or [=[Disabled]=]})
end
---@param obj BootOptions.BootSourceOverrideEnabled
function TBootSourceOverrideEnabled:init_from_obj(obj)
    self.BootSourceOverrideEnabled = obj.BootSourceOverrideEnabled or [=[Disabled]=]
end

function TBootSourceOverrideEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootSourceOverrideEnabled.group)
end

TBootSourceOverrideEnabled.from_obj = TBootSourceOverrideEnabled_from_obj

TBootSourceOverrideEnabled.proto_property = {'BootSourceOverrideEnabled'}

TBootSourceOverrideEnabled.default = {''}

TBootSourceOverrideEnabled.struct = {{name = 'BootSourceOverrideEnabled', is_array = false, struct = nil}}

function TBootSourceOverrideEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootSourceOverrideEnabled', self.BootSourceOverrideEnabled, 'string', true, errs,
        need_convert)

    TBootSourceOverrideEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootSourceOverrideEnabled.proto_property, errs, need_convert)
    return self
end

function TBootSourceOverrideEnabled:unpack(_)
    return self.BootSourceOverrideEnabled
end

BootOptions.BootSourceOverrideEnabled = TBootSourceOverrideEnabled

---@class BootOptions.BootSourceOverrideMode
---@field BootSourceOverrideMode string
local TBootSourceOverrideMode = {}
TBootSourceOverrideMode.__index = TBootSourceOverrideMode
TBootSourceOverrideMode.group = {}

local function TBootSourceOverrideMode_from_obj(obj)
    return setmetatable(obj, TBootSourceOverrideMode)
end

function TBootSourceOverrideMode.new(BootSourceOverrideMode)
    return TBootSourceOverrideMode_from_obj({BootSourceOverrideMode = BootSourceOverrideMode or [=[UEFI]=]})
end
---@param obj BootOptions.BootSourceOverrideMode
function TBootSourceOverrideMode:init_from_obj(obj)
    self.BootSourceOverrideMode = obj.BootSourceOverrideMode or [=[UEFI]=]
end

function TBootSourceOverrideMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootSourceOverrideMode.group)
end

TBootSourceOverrideMode.from_obj = TBootSourceOverrideMode_from_obj

TBootSourceOverrideMode.proto_property = {'BootSourceOverrideMode'}

TBootSourceOverrideMode.default = {''}

TBootSourceOverrideMode.struct = {{name = 'BootSourceOverrideMode', is_array = false, struct = nil}}

function TBootSourceOverrideMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootSourceOverrideMode', self.BootSourceOverrideMode, 'string', true, errs,
        need_convert)

    TBootSourceOverrideMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootSourceOverrideMode.proto_property, errs, need_convert)
    return self
end

function TBootSourceOverrideMode:unpack(_)
    return self.BootSourceOverrideMode
end

BootOptions.BootSourceOverrideMode = TBootSourceOverrideMode

---@class BootOptions.GetCertificateRsp
---@field CertInfo string
local TGetCertificateRsp = {}
TGetCertificateRsp.__index = TGetCertificateRsp
TGetCertificateRsp.group = {}

local function TGetCertificateRsp_from_obj(obj)
    return setmetatable(obj, TGetCertificateRsp)
end

function TGetCertificateRsp.new(CertInfo)
    return TGetCertificateRsp_from_obj({CertInfo = CertInfo})
end
---@param obj BootOptions.GetCertificateRsp
function TGetCertificateRsp:init_from_obj(obj)
    self.CertInfo = obj.CertInfo
end

function TGetCertificateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCertificateRsp.group)
end

TGetCertificateRsp.from_obj = TGetCertificateRsp_from_obj

TGetCertificateRsp.proto_property = {'CertInfo'}

TGetCertificateRsp.default = {''}

TGetCertificateRsp.struct = {{name = 'CertInfo', is_array = false, struct = nil}}

function TGetCertificateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CertInfo', self.CertInfo, 'string', false, errs, need_convert)

    TGetCertificateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCertificateRsp.proto_property, errs, need_convert)
    return self
end

function TGetCertificateRsp:unpack(_)
    return self.CertInfo
end

BootOptions.GetCertificateRsp = TGetCertificateRsp

---@class BootOptions.GetCertificateReq
local TGetCertificateReq = {}
TGetCertificateReq.__index = TGetCertificateReq
TGetCertificateReq.group = {}

local function TGetCertificateReq_from_obj(obj)
    return setmetatable(obj, TGetCertificateReq)
end

function TGetCertificateReq.new()
    return TGetCertificateReq_from_obj({})
end
---@param obj BootOptions.GetCertificateReq
function TGetCertificateReq:init_from_obj(obj)

end

function TGetCertificateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCertificateReq.group)
end

TGetCertificateReq.from_obj = TGetCertificateReq_from_obj

TGetCertificateReq.proto_property = {}

TGetCertificateReq.default = {}

TGetCertificateReq.struct = {}

function TGetCertificateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetCertificateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCertificateReq.proto_property, errs, need_convert)
    return self
end

function TGetCertificateReq:unpack(_)
end

BootOptions.GetCertificateReq = TGetCertificateReq

---@class BootOptions.SetBootModeRsp
---@field RespCode integer
local TSetBootModeRsp = {}
TSetBootModeRsp.__index = TSetBootModeRsp
TSetBootModeRsp.group = {}

local function TSetBootModeRsp_from_obj(obj)
    return setmetatable(obj, TSetBootModeRsp)
end

function TSetBootModeRsp.new(RespCode)
    return TSetBootModeRsp_from_obj({RespCode = RespCode})
end
---@param obj BootOptions.SetBootModeRsp
function TSetBootModeRsp:init_from_obj(obj)
    self.RespCode = obj.RespCode
end

function TSetBootModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootModeRsp.group)
end

TSetBootModeRsp.from_obj = TSetBootModeRsp_from_obj

TSetBootModeRsp.proto_property = {'RespCode'}

TSetBootModeRsp.default = {0}

TSetBootModeRsp.struct = {{name = 'RespCode', is_array = false, struct = nil}}

function TSetBootModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RespCode', self.RespCode, 'int32', false, errs, need_convert)

    TSetBootModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootModeRsp.proto_property, errs, need_convert)
    return self
end

function TSetBootModeRsp:unpack(_)
    return self.RespCode
end

BootOptions.SetBootModeRsp = TSetBootModeRsp

---@class BootOptions.SetBootModeReq
---@field mode string
local TSetBootModeReq = {}
TSetBootModeReq.__index = TSetBootModeReq
TSetBootModeReq.group = {}

local function TSetBootModeReq_from_obj(obj)
    return setmetatable(obj, TSetBootModeReq)
end

function TSetBootModeReq.new(mode)
    return TSetBootModeReq_from_obj({mode = mode})
end
---@param obj BootOptions.SetBootModeReq
function TSetBootModeReq:init_from_obj(obj)
    self.mode = obj.mode
end

function TSetBootModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootModeReq.group)
end

TSetBootModeReq.from_obj = TSetBootModeReq_from_obj

TSetBootModeReq.proto_property = {'mode'}

TSetBootModeReq.default = {''}

TSetBootModeReq.struct = {{name = 'mode', is_array = false, struct = nil}}

function TSetBootModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'mode', self.mode, 'string', false, errs, need_convert)

    TSetBootModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootModeReq.proto_property, errs, need_convert)
    return self
end

function TSetBootModeReq:unpack(_)
    return self.mode
end

BootOptions.SetBootModeReq = TSetBootModeReq

---@class BootOptions.SetStartOptionFlagRsp
---@field Result integer
local TSetStartOptionFlagRsp = {}
TSetStartOptionFlagRsp.__index = TSetStartOptionFlagRsp
TSetStartOptionFlagRsp.group = {}

local function TSetStartOptionFlagRsp_from_obj(obj)
    return setmetatable(obj, TSetStartOptionFlagRsp)
end

function TSetStartOptionFlagRsp.new(Result)
    return TSetStartOptionFlagRsp_from_obj({Result = Result})
end
---@param obj BootOptions.SetStartOptionFlagRsp
function TSetStartOptionFlagRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TSetStartOptionFlagRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetStartOptionFlagRsp.group)
end

TSetStartOptionFlagRsp.from_obj = TSetStartOptionFlagRsp_from_obj

TSetStartOptionFlagRsp.proto_property = {'Result'}

TSetStartOptionFlagRsp.default = {0}

TSetStartOptionFlagRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TSetStartOptionFlagRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TSetStartOptionFlagRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetStartOptionFlagRsp.proto_property, errs, need_convert)
    return self
end

function TSetStartOptionFlagRsp:unpack(_)
    return self.Result
end

BootOptions.SetStartOptionFlagRsp = TSetStartOptionFlagRsp

---@class BootOptions.SetStartOptionFlagReq
---@field StartOptionFlag string
local TSetStartOptionFlagReq = {}
TSetStartOptionFlagReq.__index = TSetStartOptionFlagReq
TSetStartOptionFlagReq.group = {}

local function TSetStartOptionFlagReq_from_obj(obj)
    return setmetatable(obj, TSetStartOptionFlagReq)
end

function TSetStartOptionFlagReq.new(StartOptionFlag)
    return TSetStartOptionFlagReq_from_obj({StartOptionFlag = StartOptionFlag})
end
---@param obj BootOptions.SetStartOptionFlagReq
function TSetStartOptionFlagReq:init_from_obj(obj)
    self.StartOptionFlag = obj.StartOptionFlag
end

function TSetStartOptionFlagReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetStartOptionFlagReq.group)
end

TSetStartOptionFlagReq.from_obj = TSetStartOptionFlagReq_from_obj

TSetStartOptionFlagReq.proto_property = {'StartOptionFlag'}

TSetStartOptionFlagReq.default = {''}

TSetStartOptionFlagReq.struct = {{name = 'StartOptionFlag', is_array = false, struct = nil}}

function TSetStartOptionFlagReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'StartOptionFlag', self.StartOptionFlag, 'string', false, errs, need_convert)

    TSetStartOptionFlagReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetStartOptionFlagReq.proto_property, errs, need_convert)
    return self
end

function TSetStartOptionFlagReq:unpack(_)
    return self.StartOptionFlag
end

BootOptions.SetStartOptionFlagReq = TSetStartOptionFlagReq

---@class BootOptions.SetStartOptionRsp
---@field Result integer
local TSetStartOptionRsp = {}
TSetStartOptionRsp.__index = TSetStartOptionRsp
TSetStartOptionRsp.group = {}

local function TSetStartOptionRsp_from_obj(obj)
    return setmetatable(obj, TSetStartOptionRsp)
end

function TSetStartOptionRsp.new(Result)
    return TSetStartOptionRsp_from_obj({Result = Result})
end
---@param obj BootOptions.SetStartOptionRsp
function TSetStartOptionRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TSetStartOptionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetStartOptionRsp.group)
end

TSetStartOptionRsp.from_obj = TSetStartOptionRsp_from_obj

TSetStartOptionRsp.proto_property = {'Result'}

TSetStartOptionRsp.default = {0}

TSetStartOptionRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TSetStartOptionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TSetStartOptionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetStartOptionRsp.proto_property, errs, need_convert)
    return self
end

function TSetStartOptionRsp:unpack(_)
    return self.Result
end

BootOptions.SetStartOptionRsp = TSetStartOptionRsp

---@class BootOptions.SetStartOptionReq
---@field StartOption string
local TSetStartOptionReq = {}
TSetStartOptionReq.__index = TSetStartOptionReq
TSetStartOptionReq.group = {}

local function TSetStartOptionReq_from_obj(obj)
    return setmetatable(obj, TSetStartOptionReq)
end

function TSetStartOptionReq.new(StartOption)
    return TSetStartOptionReq_from_obj({StartOption = StartOption})
end
---@param obj BootOptions.SetStartOptionReq
function TSetStartOptionReq:init_from_obj(obj)
    self.StartOption = obj.StartOption
end

function TSetStartOptionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetStartOptionReq.group)
end

TSetStartOptionReq.from_obj = TSetStartOptionReq_from_obj

TSetStartOptionReq.proto_property = {'StartOption'}

TSetStartOptionReq.default = {''}

TSetStartOptionReq.struct = {{name = 'StartOption', is_array = false, struct = nil}}

function TSetStartOptionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'StartOption', self.StartOption, 'string', false, errs, need_convert)

    TSetStartOptionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetStartOptionReq.proto_property, errs, need_convert)
    return self
end

function TSetStartOptionReq:unpack(_)
    return self.StartOption
end

BootOptions.SetStartOptionReq = TSetStartOptionReq

---@class BootOptions.SetBootOrderRsp
---@field OutCode integer
---@field ErrName string
---@field ErrValue string
local TSetBootOrderRsp = {}
TSetBootOrderRsp.__index = TSetBootOrderRsp
TSetBootOrderRsp.group = {}

local function TSetBootOrderRsp_from_obj(obj)
    return setmetatable(obj, TSetBootOrderRsp)
end

function TSetBootOrderRsp.new(OutCode, ErrName, ErrValue)
    return TSetBootOrderRsp_from_obj({OutCode = OutCode, ErrName = ErrName, ErrValue = ErrValue})
end
---@param obj BootOptions.SetBootOrderRsp
function TSetBootOrderRsp:init_from_obj(obj)
    self.OutCode = obj.OutCode
    self.ErrName = obj.ErrName
    self.ErrValue = obj.ErrValue
end

function TSetBootOrderRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootOrderRsp.group)
end

TSetBootOrderRsp.from_obj = TSetBootOrderRsp_from_obj

TSetBootOrderRsp.proto_property = {'OutCode', 'ErrName', 'ErrValue'}

TSetBootOrderRsp.default = {0, '', ''}

TSetBootOrderRsp.struct = {
    {name = 'OutCode', is_array = false, struct = nil}, {name = 'ErrName', is_array = false, struct = nil},
    {name = 'ErrValue', is_array = false, struct = nil}
}

function TSetBootOrderRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OutCode', self.OutCode, 'int32', false, errs, need_convert)
    validate.Optional(prefix .. 'ErrName', self.ErrName, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'ErrValue', self.ErrValue, 'string', false, errs, need_convert)

    TSetBootOrderRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootOrderRsp.proto_property, errs, need_convert)
    return self
end

function TSetBootOrderRsp:unpack(_)
    return self.OutCode, self.ErrName, self.ErrValue
end

BootOptions.SetBootOrderRsp = TSetBootOrderRsp

---@class BootOptions.SetBootOrderReq
---@field BootOrderJson string
local TSetBootOrderReq = {}
TSetBootOrderReq.__index = TSetBootOrderReq
TSetBootOrderReq.group = {}

local function TSetBootOrderReq_from_obj(obj)
    return setmetatable(obj, TSetBootOrderReq)
end

function TSetBootOrderReq.new(BootOrderJson)
    return TSetBootOrderReq_from_obj({BootOrderJson = BootOrderJson})
end
---@param obj BootOptions.SetBootOrderReq
function TSetBootOrderReq:init_from_obj(obj)
    self.BootOrderJson = obj.BootOrderJson
end

function TSetBootOrderReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootOrderReq.group)
end

TSetBootOrderReq.from_obj = TSetBootOrderReq_from_obj

TSetBootOrderReq.proto_property = {'BootOrderJson'}

TSetBootOrderReq.default = {''}

TSetBootOrderReq.struct = {{name = 'BootOrderJson', is_array = false, struct = nil}}

function TSetBootOrderReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootOrderJson', self.BootOrderJson, 'string', false, errs, need_convert)

    TSetBootOrderReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootOrderReq.proto_property, errs, need_convert)
    return self
end

function TSetBootOrderReq:unpack(_)
    return self.BootOrderJson
end

BootOptions.SetBootOrderReq = TSetBootOrderReq

---@class BootOptions.ResetCertificateRsp
local TResetCertificateRsp = {}
TResetCertificateRsp.__index = TResetCertificateRsp
TResetCertificateRsp.group = {}

local function TResetCertificateRsp_from_obj(obj)
    return setmetatable(obj, TResetCertificateRsp)
end

function TResetCertificateRsp.new()
    return TResetCertificateRsp_from_obj({})
end
---@param obj BootOptions.ResetCertificateRsp
function TResetCertificateRsp:init_from_obj(obj)

end

function TResetCertificateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetCertificateRsp.group)
end

TResetCertificateRsp.from_obj = TResetCertificateRsp_from_obj

TResetCertificateRsp.proto_property = {}

TResetCertificateRsp.default = {}

TResetCertificateRsp.struct = {}

function TResetCertificateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TResetCertificateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetCertificateRsp.proto_property, errs, need_convert)
    return self
end

function TResetCertificateRsp:unpack(_)
end

BootOptions.ResetCertificateRsp = TResetCertificateRsp

---@class BootOptions.ResetCertificateReq
---@field ResetType string
local TResetCertificateReq = {}
TResetCertificateReq.__index = TResetCertificateReq
TResetCertificateReq.group = {}

local function TResetCertificateReq_from_obj(obj)
    return setmetatable(obj, TResetCertificateReq)
end

function TResetCertificateReq.new(ResetType)
    return TResetCertificateReq_from_obj({ResetType = ResetType})
end
---@param obj BootOptions.ResetCertificateReq
function TResetCertificateReq:init_from_obj(obj)
    self.ResetType = obj.ResetType
end

function TResetCertificateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetCertificateReq.group)
end

TResetCertificateReq.from_obj = TResetCertificateReq_from_obj

TResetCertificateReq.proto_property = {'ResetType'}

TResetCertificateReq.default = {''}

TResetCertificateReq.struct = {{name = 'ResetType', is_array = false, struct = nil}}

function TResetCertificateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResetType', self.ResetType, 'string', false, errs, need_convert)

    TResetCertificateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetCertificateReq.proto_property, errs, need_convert)
    return self
end

function TResetCertificateReq:unpack(_)
    return self.ResetType
end

BootOptions.ResetCertificateReq = TResetCertificateReq

---@class BootOptions.ResetCrlRsp
local TResetCrlRsp = {}
TResetCrlRsp.__index = TResetCrlRsp
TResetCrlRsp.group = {}

local function TResetCrlRsp_from_obj(obj)
    return setmetatable(obj, TResetCrlRsp)
end

function TResetCrlRsp.new()
    return TResetCrlRsp_from_obj({})
end
---@param obj BootOptions.ResetCrlRsp
function TResetCrlRsp:init_from_obj(obj)

end

function TResetCrlRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetCrlRsp.group)
end

TResetCrlRsp.from_obj = TResetCrlRsp_from_obj

TResetCrlRsp.proto_property = {}

TResetCrlRsp.default = {}

TResetCrlRsp.struct = {}

function TResetCrlRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TResetCrlRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetCrlRsp.proto_property, errs, need_convert)
    return self
end

function TResetCrlRsp:unpack(_)
end

BootOptions.ResetCrlRsp = TResetCrlRsp

---@class BootOptions.ResetCrlReq
---@field ResetType string
local TResetCrlReq = {}
TResetCrlReq.__index = TResetCrlReq
TResetCrlReq.group = {}

local function TResetCrlReq_from_obj(obj)
    return setmetatable(obj, TResetCrlReq)
end

function TResetCrlReq.new(ResetType)
    return TResetCrlReq_from_obj({ResetType = ResetType})
end
---@param obj BootOptions.ResetCrlReq
function TResetCrlReq:init_from_obj(obj)
    self.ResetType = obj.ResetType
end

function TResetCrlReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetCrlReq.group)
end

TResetCrlReq.from_obj = TResetCrlReq_from_obj

TResetCrlReq.proto_property = {'ResetType'}

TResetCrlReq.default = {''}

TResetCrlReq.struct = {{name = 'ResetType', is_array = false, struct = nil}}

function TResetCrlReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResetType', self.ResetType, 'string', false, errs, need_convert)

    TResetCrlReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetCrlReq.proto_property, errs, need_convert)
    return self
end

function TResetCrlReq:unpack(_)
    return self.ResetType
end

BootOptions.ResetCrlReq = TResetCrlReq

---@class BootOptions.ImportCrlRsp
local TImportCrlRsp = {}
TImportCrlRsp.__index = TImportCrlRsp
TImportCrlRsp.group = {}

local function TImportCrlRsp_from_obj(obj)
    return setmetatable(obj, TImportCrlRsp)
end

function TImportCrlRsp.new()
    return TImportCrlRsp_from_obj({})
end
---@param obj BootOptions.ImportCrlRsp
function TImportCrlRsp:init_from_obj(obj)

end

function TImportCrlRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportCrlRsp.group)
end

TImportCrlRsp.from_obj = TImportCrlRsp_from_obj

TImportCrlRsp.proto_property = {}

TImportCrlRsp.default = {}

TImportCrlRsp.struct = {}

function TImportCrlRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TImportCrlRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportCrlRsp.proto_property, errs, need_convert)
    return self
end

function TImportCrlRsp:unpack(_)
end

BootOptions.ImportCrlRsp = TImportCrlRsp

---@class BootOptions.ImportCrlReq
---@field CertString string
---@field CertType string
local TImportCrlReq = {}
TImportCrlReq.__index = TImportCrlReq
TImportCrlReq.group = {}

local function TImportCrlReq_from_obj(obj)
    return setmetatable(obj, TImportCrlReq)
end

function TImportCrlReq.new(CertString, CertType)
    return TImportCrlReq_from_obj({CertString = CertString, CertType = CertType})
end
---@param obj BootOptions.ImportCrlReq
function TImportCrlReq:init_from_obj(obj)
    self.CertString = obj.CertString
    self.CertType = obj.CertType
end

function TImportCrlReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportCrlReq.group)
end

TImportCrlReq.from_obj = TImportCrlReq_from_obj

TImportCrlReq.proto_property = {'CertString', 'CertType'}

TImportCrlReq.default = {'', ''}

TImportCrlReq.struct = {
    {name = 'CertString', is_array = false, struct = nil}, {name = 'CertType', is_array = false, struct = nil}
}

function TImportCrlReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CertString', self.CertString, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'CertType', self.CertType, 'string', false, errs, need_convert)

    TImportCrlReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportCrlReq.proto_property, errs, need_convert)
    return self
end

function TImportCrlReq:unpack(_)
    return self.CertString, self.CertType
end

BootOptions.ImportCrlReq = TImportCrlReq

---@class BootOptions.ImportCertificateRsp
local TImportCertificateRsp = {}
TImportCertificateRsp.__index = TImportCertificateRsp
TImportCertificateRsp.group = {}

local function TImportCertificateRsp_from_obj(obj)
    return setmetatable(obj, TImportCertificateRsp)
end

function TImportCertificateRsp.new()
    return TImportCertificateRsp_from_obj({})
end
---@param obj BootOptions.ImportCertificateRsp
function TImportCertificateRsp:init_from_obj(obj)

end

function TImportCertificateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportCertificateRsp.group)
end

TImportCertificateRsp.from_obj = TImportCertificateRsp_from_obj

TImportCertificateRsp.proto_property = {}

TImportCertificateRsp.default = {}

TImportCertificateRsp.struct = {}

function TImportCertificateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TImportCertificateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportCertificateRsp.proto_property, errs, need_convert)
    return self
end

function TImportCertificateRsp:unpack(_)
end

BootOptions.ImportCertificateRsp = TImportCertificateRsp

---@class BootOptions.ImportCertificateReq
---@field CertString string
---@field CertType string
local TImportCertificateReq = {}
TImportCertificateReq.__index = TImportCertificateReq
TImportCertificateReq.group = {}

local function TImportCertificateReq_from_obj(obj)
    return setmetatable(obj, TImportCertificateReq)
end

function TImportCertificateReq.new(CertString, CertType)
    return TImportCertificateReq_from_obj({CertString = CertString, CertType = CertType})
end
---@param obj BootOptions.ImportCertificateReq
function TImportCertificateReq:init_from_obj(obj)
    self.CertString = obj.CertString
    self.CertType = obj.CertType
end

function TImportCertificateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportCertificateReq.group)
end

TImportCertificateReq.from_obj = TImportCertificateReq_from_obj

TImportCertificateReq.proto_property = {'CertString', 'CertType'}

TImportCertificateReq.default = {'', ''}

TImportCertificateReq.struct = {
    {name = 'CertString', is_array = false, struct = nil}, {name = 'CertType', is_array = false, struct = nil}
}

function TImportCertificateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CertString', self.CertString, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'CertType', self.CertType, 'string', false, errs, need_convert)

    TImportCertificateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportCertificateReq.proto_property, errs, need_convert)
    return self
end

function TImportCertificateReq:unpack(_)
    return self.CertString, self.CertType
end

BootOptions.ImportCertificateReq = TImportCertificateReq

---@class BootOptions.ShieldIpmiModifyBootModeSupportRsp
---@field RespCode integer
local TShieldIpmiModifyBootModeSupportRsp = {}
TShieldIpmiModifyBootModeSupportRsp.__index = TShieldIpmiModifyBootModeSupportRsp
TShieldIpmiModifyBootModeSupportRsp.group = {}

local function TShieldIpmiModifyBootModeSupportRsp_from_obj(obj)
    return setmetatable(obj, TShieldIpmiModifyBootModeSupportRsp)
end

function TShieldIpmiModifyBootModeSupportRsp.new(RespCode)
    return TShieldIpmiModifyBootModeSupportRsp_from_obj({RespCode = RespCode})
end
---@param obj BootOptions.ShieldIpmiModifyBootModeSupportRsp
function TShieldIpmiModifyBootModeSupportRsp:init_from_obj(obj)
    self.RespCode = obj.RespCode
end

function TShieldIpmiModifyBootModeSupportRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TShieldIpmiModifyBootModeSupportRsp.group)
end

TShieldIpmiModifyBootModeSupportRsp.from_obj = TShieldIpmiModifyBootModeSupportRsp_from_obj

TShieldIpmiModifyBootModeSupportRsp.proto_property = {'RespCode'}

TShieldIpmiModifyBootModeSupportRsp.default = {0}

TShieldIpmiModifyBootModeSupportRsp.struct = {{name = 'RespCode', is_array = false, struct = nil}}

function TShieldIpmiModifyBootModeSupportRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RespCode', self.RespCode, 'int32', false, errs, need_convert)

    TShieldIpmiModifyBootModeSupportRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TShieldIpmiModifyBootModeSupportRsp.proto_property, errs, need_convert)
    return self
end

function TShieldIpmiModifyBootModeSupportRsp:unpack(_)
    return self.RespCode
end

BootOptions.ShieldIpmiModifyBootModeSupportRsp = TShieldIpmiModifyBootModeSupportRsp

---@class BootOptions.ShieldIpmiModifyBootModeSupportReq
---@field ModeSwitch boolean
local TShieldIpmiModifyBootModeSupportReq = {}
TShieldIpmiModifyBootModeSupportReq.__index = TShieldIpmiModifyBootModeSupportReq
TShieldIpmiModifyBootModeSupportReq.group = {}

local function TShieldIpmiModifyBootModeSupportReq_from_obj(obj)
    return setmetatable(obj, TShieldIpmiModifyBootModeSupportReq)
end

function TShieldIpmiModifyBootModeSupportReq.new(ModeSwitch)
    return TShieldIpmiModifyBootModeSupportReq_from_obj({ModeSwitch = ModeSwitch})
end
---@param obj BootOptions.ShieldIpmiModifyBootModeSupportReq
function TShieldIpmiModifyBootModeSupportReq:init_from_obj(obj)
    self.ModeSwitch = obj.ModeSwitch
end

function TShieldIpmiModifyBootModeSupportReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TShieldIpmiModifyBootModeSupportReq.group)
end

TShieldIpmiModifyBootModeSupportReq.from_obj = TShieldIpmiModifyBootModeSupportReq_from_obj

TShieldIpmiModifyBootModeSupportReq.proto_property = {'ModeSwitch'}

TShieldIpmiModifyBootModeSupportReq.default = {false}

TShieldIpmiModifyBootModeSupportReq.struct = {{name = 'ModeSwitch', is_array = false, struct = nil}}

function TShieldIpmiModifyBootModeSupportReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ModeSwitch', self.ModeSwitch, 'bool', false, errs, need_convert)

    TShieldIpmiModifyBootModeSupportReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TShieldIpmiModifyBootModeSupportReq.proto_property, errs, need_convert)
    return self
end

function TShieldIpmiModifyBootModeSupportReq:unpack(_)
    return self.ModeSwitch
end

BootOptions.ShieldIpmiModifyBootModeSupportReq = TShieldIpmiModifyBootModeSupportReq

BootOptions.interface = mdb.register_interface('bmc.kepler.Systems.BootOptions', {
    BootSourceOverrideMode = {'s', nil, true, 'UEFI', false},
    BootSourceOverrideEnabled = {'s', nil, true, 'Disabled', false},
    BootSourceOverrideTarget = {'s', nil, true, 'HDD', false},
    BootOptionReference = {'as', nil, true, nil, false},
    BootOrder = {'as', nil, true, nil, false},
    BootModeSupport = {'b', nil, true, true, false},
    BootModeIpmiSettable = {'b', nil, true, true, false},
    BootOptionPolicy = {'y', nil, false, 0, false},
    PreviousBootSourceOverrideTarget = {'s', nil, true, '', false}
}, {
    ShieldIpmiModifyBootModeSupport = {
        'a{ss}b', 'i', TShieldIpmiModifyBootModeSupportReq, TShieldIpmiModifyBootModeSupportRsp
    },
    ImportCertificate = {'a{ss}ss', '', TImportCertificateReq, TImportCertificateRsp},
    ImportCrl = {'a{ss}ss', '', TImportCrlReq, TImportCrlRsp},
    ResetCrl = {'a{ss}s', '', TResetCrlReq, TResetCrlRsp},
    ResetCertificate = {'a{ss}s', '', TResetCertificateReq, TResetCertificateRsp},
    SetBootOrder = {'a{ss}s', 'iss', TSetBootOrderReq, TSetBootOrderRsp},
    SetStartOption = {'a{ss}s', 'i', TSetStartOptionReq, TSetStartOptionRsp},
    SetStartOptionFlag = {'a{ss}s', 'i', TSetStartOptionFlagReq, TSetStartOptionFlagRsp},
    SetBootMode = {'a{ss}s', 'i', TSetBootModeReq, TSetBootModeRsp},
    GetCertificate = {'a{ss}', 's', TGetCertificateReq, TGetCertificateRsp}
}, {})

return BootOptions
