-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Bios = {}

---@class Bios.TeeOSVersion
---@field TeeOSVersion string
local TTeeOSVersion = {}
TTeeOSVersion.__index = TTeeOSVersion
TTeeOSVersion.group = {}

local function TTeeOSVersion_from_obj(obj)
    return setmetatable(obj, TTeeOSVersion)
end

function TTeeOSVersion.new(TeeOSVersion)
    return TTeeOSVersion_from_obj({TeeOSVersion = TeeOSVersion})
end
---@param obj Bios.TeeOSVersion
function TTeeOSVersion:init_from_obj(obj)
    self.TeeOSVersion = obj.TeeOSVersion
end

function TTeeOSVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTeeOSVersion.group)
end

TTeeOSVersion.from_obj = TTeeOSVersion_from_obj

TTeeOSVersion.proto_property = {'TeeOSVersion'}

TTeeOSVersion.default = {''}

TTeeOSVersion.struct = {{name = 'TeeOSVersion', is_array = false, struct = nil}}

function TTeeOSVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TeeOSVersion', self.TeeOSVersion, 'string', true, errs, need_convert)

    TTeeOSVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTeeOSVersion.proto_property, errs, need_convert)
    return self
end

function TTeeOSVersion:unpack(_)
    return self.TeeOSVersion
end

Bios.TeeOSVersion = TTeeOSVersion

---@class Bios.SettingsEffectiveStatus
---@field SettingsEffectiveStatus string
local TSettingsEffectiveStatus = {}
TSettingsEffectiveStatus.__index = TSettingsEffectiveStatus
TSettingsEffectiveStatus.group = {}

local function TSettingsEffectiveStatus_from_obj(obj)
    return setmetatable(obj, TSettingsEffectiveStatus)
end

function TSettingsEffectiveStatus.new(SettingsEffectiveStatus)
    return TSettingsEffectiveStatus_from_obj({SettingsEffectiveStatus = SettingsEffectiveStatus})
end
---@param obj Bios.SettingsEffectiveStatus
function TSettingsEffectiveStatus:init_from_obj(obj)
    self.SettingsEffectiveStatus = obj.SettingsEffectiveStatus
end

function TSettingsEffectiveStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSettingsEffectiveStatus.group)
end

TSettingsEffectiveStatus.from_obj = TSettingsEffectiveStatus_from_obj

TSettingsEffectiveStatus.proto_property = {'SettingsEffectiveStatus'}

TSettingsEffectiveStatus.default = {''}

TSettingsEffectiveStatus.struct = {{name = 'SettingsEffectiveStatus', is_array = false, struct = nil}}

function TSettingsEffectiveStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SettingsEffectiveStatus', self.SettingsEffectiveStatus, 'string', true, errs,
        need_convert)

    TSettingsEffectiveStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSettingsEffectiveStatus.proto_property, errs, need_convert)
    return self
end

function TSettingsEffectiveStatus:unpack(_)
    return self.SettingsEffectiveStatus
end

Bios.SettingsEffectiveStatus = TSettingsEffectiveStatus

---@class Bios.ResetBiosToDefaultsPending
---@field ResetBiosToDefaultsPending boolean
local TResetBiosToDefaultsPending = {}
TResetBiosToDefaultsPending.__index = TResetBiosToDefaultsPending
TResetBiosToDefaultsPending.group = {}

local function TResetBiosToDefaultsPending_from_obj(obj)
    return setmetatable(obj, TResetBiosToDefaultsPending)
end

function TResetBiosToDefaultsPending.new(ResetBiosToDefaultsPending)
    return TResetBiosToDefaultsPending_from_obj({ResetBiosToDefaultsPending = ResetBiosToDefaultsPending})
end
---@param obj Bios.ResetBiosToDefaultsPending
function TResetBiosToDefaultsPending:init_from_obj(obj)
    self.ResetBiosToDefaultsPending = obj.ResetBiosToDefaultsPending
end

function TResetBiosToDefaultsPending:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetBiosToDefaultsPending.group)
end

TResetBiosToDefaultsPending.from_obj = TResetBiosToDefaultsPending_from_obj

TResetBiosToDefaultsPending.proto_property = {'ResetBiosToDefaultsPending'}

TResetBiosToDefaultsPending.default = {false}

TResetBiosToDefaultsPending.struct = {{name = 'ResetBiosToDefaultsPending', is_array = false, struct = nil}}

function TResetBiosToDefaultsPending:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResetBiosToDefaultsPending', self.ResetBiosToDefaultsPending, 'bool', true, errs,
        need_convert)

    TResetBiosToDefaultsPending:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetBiosToDefaultsPending.proto_property, errs, need_convert)
    return self
end

function TResetBiosToDefaultsPending:unpack(_)
    return self.ResetBiosToDefaultsPending
end

Bios.ResetBiosToDefaultsPending = TResetBiosToDefaultsPending

---@class Bios.BiosConfigActiveMode
---@field BiosConfigActiveMode integer
local TBiosConfigActiveMode = {}
TBiosConfigActiveMode.__index = TBiosConfigActiveMode
TBiosConfigActiveMode.group = {}

local function TBiosConfigActiveMode_from_obj(obj)
    return setmetatable(obj, TBiosConfigActiveMode)
end

function TBiosConfigActiveMode.new(BiosConfigActiveMode)
    return TBiosConfigActiveMode_from_obj({BiosConfigActiveMode = BiosConfigActiveMode})
end
---@param obj Bios.BiosConfigActiveMode
function TBiosConfigActiveMode:init_from_obj(obj)
    self.BiosConfigActiveMode = obj.BiosConfigActiveMode
end

function TBiosConfigActiveMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBiosConfigActiveMode.group)
end

TBiosConfigActiveMode.from_obj = TBiosConfigActiveMode_from_obj

TBiosConfigActiveMode.proto_property = {'BiosConfigActiveMode'}

TBiosConfigActiveMode.default = {0}

TBiosConfigActiveMode.struct = {{name = 'BiosConfigActiveMode', is_array = false, struct = nil}}

function TBiosConfigActiveMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BiosConfigActiveMode', self.BiosConfigActiveMode, 'uint64', true, errs, need_convert)

    TBiosConfigActiveMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBiosConfigActiveMode.proto_property, errs, need_convert)
    return self
end

function TBiosConfigActiveMode:unpack(_)
    return self.BiosConfigActiveMode
end

Bios.BiosConfigActiveMode = TBiosConfigActiveMode

---@class Bios.BiosLogPrintEnabled
---@field BiosLogPrintEnabled integer
local TBiosLogPrintEnabled = {}
TBiosLogPrintEnabled.__index = TBiosLogPrintEnabled
TBiosLogPrintEnabled.group = {}

local function TBiosLogPrintEnabled_from_obj(obj)
    return setmetatable(obj, TBiosLogPrintEnabled)
end

function TBiosLogPrintEnabled.new(BiosLogPrintEnabled)
    return TBiosLogPrintEnabled_from_obj({BiosLogPrintEnabled = BiosLogPrintEnabled})
end
---@param obj Bios.BiosLogPrintEnabled
function TBiosLogPrintEnabled:init_from_obj(obj)
    self.BiosLogPrintEnabled = obj.BiosLogPrintEnabled
end

function TBiosLogPrintEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBiosLogPrintEnabled.group)
end

TBiosLogPrintEnabled.from_obj = TBiosLogPrintEnabled_from_obj

TBiosLogPrintEnabled.proto_property = {'BiosLogPrintEnabled'}

TBiosLogPrintEnabled.default = {0}

TBiosLogPrintEnabled.struct = {{name = 'BiosLogPrintEnabled', is_array = false, struct = nil}}

function TBiosLogPrintEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BiosLogPrintEnabled', self.BiosLogPrintEnabled, 'uint8', true, errs, need_convert)

    TBiosLogPrintEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBiosLogPrintEnabled.proto_property, errs, need_convert)
    return self
end

function TBiosLogPrintEnabled:unpack(_)
    return self.BiosLogPrintEnabled
end

Bios.BiosLogPrintEnabled = TBiosLogPrintEnabled

---@class Bios.RecoverFailed
---@field RecoverFailed integer
local TRecoverFailed = {}
TRecoverFailed.__index = TRecoverFailed
TRecoverFailed.group = {}

local function TRecoverFailed_from_obj(obj)
    return setmetatable(obj, TRecoverFailed)
end

function TRecoverFailed.new(RecoverFailed)
    return TRecoverFailed_from_obj({RecoverFailed = RecoverFailed})
end
---@param obj Bios.RecoverFailed
function TRecoverFailed:init_from_obj(obj)
    self.RecoverFailed = obj.RecoverFailed
end

function TRecoverFailed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRecoverFailed.group)
end

TRecoverFailed.from_obj = TRecoverFailed_from_obj

TRecoverFailed.proto_property = {'RecoverFailed'}

TRecoverFailed.default = {0}

TRecoverFailed.struct = {{name = 'RecoverFailed', is_array = false, struct = nil}}

function TRecoverFailed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RecoverFailed', self.RecoverFailed, 'uint8', true, errs, need_convert)

    TRecoverFailed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRecoverFailed.proto_property, errs, need_convert)
    return self
end

function TRecoverFailed:unpack(_)
    return self.RecoverFailed
end

Bios.RecoverFailed = TRecoverFailed

---@class Bios.UpgradeFailed
---@field UpgradeFailed integer
local TUpgradeFailed = {}
TUpgradeFailed.__index = TUpgradeFailed
TUpgradeFailed.group = {}

local function TUpgradeFailed_from_obj(obj)
    return setmetatable(obj, TUpgradeFailed)
end

function TUpgradeFailed.new(UpgradeFailed)
    return TUpgradeFailed_from_obj({UpgradeFailed = UpgradeFailed})
end
---@param obj Bios.UpgradeFailed
function TUpgradeFailed:init_from_obj(obj)
    self.UpgradeFailed = obj.UpgradeFailed
end

function TUpgradeFailed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpgradeFailed.group)
end

TUpgradeFailed.from_obj = TUpgradeFailed_from_obj

TUpgradeFailed.proto_property = {'UpgradeFailed'}

TUpgradeFailed.default = {0}

TUpgradeFailed.struct = {{name = 'UpgradeFailed', is_array = false, struct = nil}}

function TUpgradeFailed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UpgradeFailed', self.UpgradeFailed, 'uint8', true, errs, need_convert)

    TUpgradeFailed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpgradeFailed.proto_property, errs, need_convert)
    return self
end

function TUpgradeFailed:unpack(_)
    return self.UpgradeFailed
end

Bios.UpgradeFailed = TUpgradeFailed

---@class Bios.BiosBootStage
---@field BiosBootStage integer
local TBiosBootStage = {}
TBiosBootStage.__index = TBiosBootStage
TBiosBootStage.group = {}

local function TBiosBootStage_from_obj(obj)
    return setmetatable(obj, TBiosBootStage)
end

function TBiosBootStage.new(BiosBootStage)
    return TBiosBootStage_from_obj({BiosBootStage = BiosBootStage})
end
---@param obj Bios.BiosBootStage
function TBiosBootStage:init_from_obj(obj)
    self.BiosBootStage = obj.BiosBootStage
end

function TBiosBootStage:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBiosBootStage.group)
end

TBiosBootStage.from_obj = TBiosBootStage_from_obj

TBiosBootStage.proto_property = {'BiosBootStage'}

TBiosBootStage.default = {0}

TBiosBootStage.struct = {{name = 'BiosBootStage', is_array = false, struct = nil}}

function TBiosBootStage:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BiosBootStage', self.BiosBootStage, 'uint8', true, errs, need_convert)

    TBiosBootStage:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBiosBootStage.proto_property, errs, need_convert)
    return self
end

function TBiosBootStage:unpack(_)
    return self.BiosBootStage
end

Bios.BiosBootStage = TBiosBootStage

---@class Bios.OCPCardBDF
---@field OCPCardBDF integer[]
local TOCPCardBDF = {}
TOCPCardBDF.__index = TOCPCardBDF
TOCPCardBDF.group = {}

local function TOCPCardBDF_from_obj(obj)
    return setmetatable(obj, TOCPCardBDF)
end

function TOCPCardBDF.new(OCPCardBDF)
    return TOCPCardBDF_from_obj({OCPCardBDF = OCPCardBDF})
end
---@param obj Bios.OCPCardBDF
function TOCPCardBDF:init_from_obj(obj)
    self.OCPCardBDF = obj.OCPCardBDF
end

function TOCPCardBDF:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOCPCardBDF.group)
end

TOCPCardBDF.from_obj = TOCPCardBDF_from_obj

TOCPCardBDF.proto_property = {'OCPCardBDF'}

TOCPCardBDF.default = {{}}

TOCPCardBDF.struct = {{name = 'OCPCardBDF', is_array = true, struct = nil}}

function TOCPCardBDF:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'OCPCardBDF', self.OCPCardBDF, 'uint8', true, errs, need_convert)

    TOCPCardBDF:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOCPCardBDF.proto_property, errs, need_convert)
    return self
end

function TOCPCardBDF:unpack(_)
    return self.OCPCardBDF
end

Bios.OCPCardBDF = TOCPCardBDF

---@class Bios.PcieDiskBDF
---@field PcieDiskBDF integer[]
local TPcieDiskBDF = {}
TPcieDiskBDF.__index = TPcieDiskBDF
TPcieDiskBDF.group = {}

local function TPcieDiskBDF_from_obj(obj)
    return setmetatable(obj, TPcieDiskBDF)
end

function TPcieDiskBDF.new(PcieDiskBDF)
    return TPcieDiskBDF_from_obj({PcieDiskBDF = PcieDiskBDF})
end
---@param obj Bios.PcieDiskBDF
function TPcieDiskBDF:init_from_obj(obj)
    self.PcieDiskBDF = obj.PcieDiskBDF
end

function TPcieDiskBDF:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPcieDiskBDF.group)
end

TPcieDiskBDF.from_obj = TPcieDiskBDF_from_obj

TPcieDiskBDF.proto_property = {'PcieDiskBDF'}

TPcieDiskBDF.default = {{}}

TPcieDiskBDF.struct = {{name = 'PcieDiskBDF', is_array = true, struct = nil}}

function TPcieDiskBDF:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'PcieDiskBDF', self.PcieDiskBDF, 'uint8', true, errs, need_convert)

    TPcieDiskBDF:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPcieDiskBDF.proto_property, errs, need_convert)
    return self
end

function TPcieDiskBDF:unpack(_)
    return self.PcieDiskBDF
end

Bios.PcieDiskBDF = TPcieDiskBDF

---@class Bios.PcieCardBDF
---@field PcieCardBDF integer[]
local TPcieCardBDF = {}
TPcieCardBDF.__index = TPcieCardBDF
TPcieCardBDF.group = {}

local function TPcieCardBDF_from_obj(obj)
    return setmetatable(obj, TPcieCardBDF)
end

function TPcieCardBDF.new(PcieCardBDF)
    return TPcieCardBDF_from_obj({PcieCardBDF = PcieCardBDF})
end
---@param obj Bios.PcieCardBDF
function TPcieCardBDF:init_from_obj(obj)
    self.PcieCardBDF = obj.PcieCardBDF
end

function TPcieCardBDF:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPcieCardBDF.group)
end

TPcieCardBDF.from_obj = TPcieCardBDF_from_obj

TPcieCardBDF.proto_property = {'PcieCardBDF'}

TPcieCardBDF.default = {{}}

TPcieCardBDF.struct = {{name = 'PcieCardBDF', is_array = true, struct = nil}}

function TPcieCardBDF:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'PcieCardBDF', self.PcieCardBDF, 'uint8', true, errs, need_convert)

    TPcieCardBDF:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPcieCardBDF.proto_property, errs, need_convert)
    return self
end

function TPcieCardBDF:unpack(_)
    return self.PcieCardBDF
end

Bios.PcieCardBDF = TPcieCardBDF

---@class Bios.DEMTConfig
---@field DEMTConfig integer
local TDEMTConfig = {}
TDEMTConfig.__index = TDEMTConfig
TDEMTConfig.group = {}

local function TDEMTConfig_from_obj(obj)
    return setmetatable(obj, TDEMTConfig)
end

function TDEMTConfig.new(DEMTConfig)
    return TDEMTConfig_from_obj({DEMTConfig = DEMTConfig})
end
---@param obj Bios.DEMTConfig
function TDEMTConfig:init_from_obj(obj)
    self.DEMTConfig = obj.DEMTConfig
end

function TDEMTConfig:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDEMTConfig.group)
end

TDEMTConfig.from_obj = TDEMTConfig_from_obj

TDEMTConfig.proto_property = {'DEMTConfig'}

TDEMTConfig.default = {0}

TDEMTConfig.struct = {{name = 'DEMTConfig', is_array = false, struct = nil}}

function TDEMTConfig:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DEMTConfig', self.DEMTConfig, 'uint8', true, errs, need_convert)

    TDEMTConfig:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDEMTConfig.proto_property, errs, need_convert)
    return self
end

function TDEMTConfig:unpack(_)
    return self.DEMTConfig
end

Bios.DEMTConfig = TDEMTConfig

---@class Bios.RegistryVersion
---@field RegistryVersion string
local TRegistryVersion = {}
TRegistryVersion.__index = TRegistryVersion
TRegistryVersion.group = {}

local function TRegistryVersion_from_obj(obj)
    return setmetatable(obj, TRegistryVersion)
end

function TRegistryVersion.new(RegistryVersion)
    return TRegistryVersion_from_obj({RegistryVersion = RegistryVersion})
end
---@param obj Bios.RegistryVersion
function TRegistryVersion:init_from_obj(obj)
    self.RegistryVersion = obj.RegistryVersion
end

function TRegistryVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRegistryVersion.group)
end

TRegistryVersion.from_obj = TRegistryVersion_from_obj

TRegistryVersion.proto_property = {'RegistryVersion'}

TRegistryVersion.default = {''}

TRegistryVersion.struct = {{name = 'RegistryVersion', is_array = false, struct = nil}}

function TRegistryVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RegistryVersion', self.RegistryVersion, 'string', true, errs, need_convert)

    TRegistryVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRegistryVersion.proto_property, errs, need_convert)
    return self
end

function TRegistryVersion:unpack(_)
    return self.RegistryVersion
end

Bios.RegistryVersion = TRegistryVersion

---@class Bios.MenuChangeFlag
---@field MenuChangeFlag integer
local TMenuChangeFlag = {}
TMenuChangeFlag.__index = TMenuChangeFlag
TMenuChangeFlag.group = {}

local function TMenuChangeFlag_from_obj(obj)
    return setmetatable(obj, TMenuChangeFlag)
end

function TMenuChangeFlag.new(MenuChangeFlag)
    return TMenuChangeFlag_from_obj({MenuChangeFlag = MenuChangeFlag})
end
---@param obj Bios.MenuChangeFlag
function TMenuChangeFlag:init_from_obj(obj)
    self.MenuChangeFlag = obj.MenuChangeFlag
end

function TMenuChangeFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMenuChangeFlag.group)
end

TMenuChangeFlag.from_obj = TMenuChangeFlag_from_obj

TMenuChangeFlag.proto_property = {'MenuChangeFlag'}

TMenuChangeFlag.default = {0}

TMenuChangeFlag.struct = {{name = 'MenuChangeFlag', is_array = false, struct = nil}}

function TMenuChangeFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MenuChangeFlag', self.MenuChangeFlag, 'uint8', true, errs, need_convert)

    TMenuChangeFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMenuChangeFlag.proto_property, errs, need_convert)
    return self
end

function TMenuChangeFlag:unpack(_)
    return self.MenuChangeFlag
end

Bios.MenuChangeFlag = TMenuChangeFlag

---@class Bios.MenuData
---@field MenuData string
local TMenuData = {}
TMenuData.__index = TMenuData
TMenuData.group = {}

local function TMenuData_from_obj(obj)
    return setmetatable(obj, TMenuData)
end

function TMenuData.new(MenuData)
    return TMenuData_from_obj({MenuData = MenuData})
end
---@param obj Bios.MenuData
function TMenuData:init_from_obj(obj)
    self.MenuData = obj.MenuData
end

function TMenuData:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMenuData.group)
end

TMenuData.from_obj = TMenuData_from_obj

TMenuData.proto_property = {'MenuData'}

TMenuData.default = {''}

TMenuData.struct = {{name = 'MenuData', is_array = false, struct = nil}}

function TMenuData:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MenuData', self.MenuData, 'string', true, errs, need_convert)

    TMenuData:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMenuData.proto_property, errs, need_convert)
    return self
end

function TMenuData:unpack(_)
    return self.MenuData
end

Bios.MenuData = TMenuData

---@class Bios.RegistryFileName
---@field RegistryFileName string
local TRegistryFileName = {}
TRegistryFileName.__index = TRegistryFileName
TRegistryFileName.group = {}

local function TRegistryFileName_from_obj(obj)
    return setmetatable(obj, TRegistryFileName)
end

function TRegistryFileName.new(RegistryFileName)
    return TRegistryFileName_from_obj({RegistryFileName = RegistryFileName})
end
---@param obj Bios.RegistryFileName
function TRegistryFileName:init_from_obj(obj)
    self.RegistryFileName = obj.RegistryFileName
end

function TRegistryFileName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRegistryFileName.group)
end

TRegistryFileName.from_obj = TRegistryFileName_from_obj

TRegistryFileName.proto_property = {'RegistryFileName'}

TRegistryFileName.default = {''}

TRegistryFileName.struct = {{name = 'RegistryFileName', is_array = false, struct = nil}}

function TRegistryFileName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RegistryFileName', self.RegistryFileName, 'string', true, errs, need_convert)

    TRegistryFileName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRegistryFileName.proto_property, errs, need_convert)
    return self
end

function TRegistryFileName:unpack(_)
    return self.RegistryFileName
end

Bios.RegistryFileName = TRegistryFileName

---@class Bios.SettingFileName
---@field SettingFileName string
local TSettingFileName = {}
TSettingFileName.__index = TSettingFileName
TSettingFileName.group = {}

local function TSettingFileName_from_obj(obj)
    return setmetatable(obj, TSettingFileName)
end

function TSettingFileName.new(SettingFileName)
    return TSettingFileName_from_obj({SettingFileName = SettingFileName})
end
---@param obj Bios.SettingFileName
function TSettingFileName:init_from_obj(obj)
    self.SettingFileName = obj.SettingFileName
end

function TSettingFileName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSettingFileName.group)
end

TSettingFileName.from_obj = TSettingFileName_from_obj

TSettingFileName.proto_property = {'SettingFileName'}

TSettingFileName.default = {''}

TSettingFileName.struct = {{name = 'SettingFileName', is_array = false, struct = nil}}

function TSettingFileName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SettingFileName', self.SettingFileName, 'string', true, errs, need_convert)

    TSettingFileName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSettingFileName.proto_property, errs, need_convert)
    return self
end

function TSettingFileName:unpack(_)
    return self.SettingFileName
end

Bios.SettingFileName = TSettingFileName

---@class Bios.ResultFileName
---@field ResultFileName string
local TResultFileName = {}
TResultFileName.__index = TResultFileName
TResultFileName.group = {}

local function TResultFileName_from_obj(obj)
    return setmetatable(obj, TResultFileName)
end

function TResultFileName.new(ResultFileName)
    return TResultFileName_from_obj({ResultFileName = ResultFileName})
end
---@param obj Bios.ResultFileName
function TResultFileName:init_from_obj(obj)
    self.ResultFileName = obj.ResultFileName
end

function TResultFileName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResultFileName.group)
end

TResultFileName.from_obj = TResultFileName_from_obj

TResultFileName.proto_property = {'ResultFileName'}

TResultFileName.default = {''}

TResultFileName.struct = {{name = 'ResultFileName', is_array = false, struct = nil}}

function TResultFileName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResultFileName', self.ResultFileName, 'string', true, errs, need_convert)

    TResultFileName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResultFileName.proto_property, errs, need_convert)
    return self
end

function TResultFileName:unpack(_)
    return self.ResultFileName
end

Bios.ResultFileName = TResultFileName

---@class Bios.CurrentValueFileName
---@field CurrentValueFileName string
local TCurrentValueFileName = {}
TCurrentValueFileName.__index = TCurrentValueFileName
TCurrentValueFileName.group = {}

local function TCurrentValueFileName_from_obj(obj)
    return setmetatable(obj, TCurrentValueFileName)
end

function TCurrentValueFileName.new(CurrentValueFileName)
    return TCurrentValueFileName_from_obj({CurrentValueFileName = CurrentValueFileName})
end
---@param obj Bios.CurrentValueFileName
function TCurrentValueFileName:init_from_obj(obj)
    self.CurrentValueFileName = obj.CurrentValueFileName
end

function TCurrentValueFileName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCurrentValueFileName.group)
end

TCurrentValueFileName.from_obj = TCurrentValueFileName_from_obj

TCurrentValueFileName.proto_property = {'CurrentValueFileName'}

TCurrentValueFileName.default = {''}

TCurrentValueFileName.struct = {{name = 'CurrentValueFileName', is_array = false, struct = nil}}

function TCurrentValueFileName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CurrentValueFileName', self.CurrentValueFileName, 'string', true, errs, need_convert)

    TCurrentValueFileName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCurrentValueFileName.proto_property, errs, need_convert)
    return self
end

function TCurrentValueFileName:unpack(_)
    return self.CurrentValueFileName
end

Bios.CurrentValueFileName = TCurrentValueFileName

---@class Bios.BackupVersion
---@field BackupVersion string
local TBackupVersion = {}
TBackupVersion.__index = TBackupVersion
TBackupVersion.group = {}

local function TBackupVersion_from_obj(obj)
    return setmetatable(obj, TBackupVersion)
end

function TBackupVersion.new(BackupVersion)
    return TBackupVersion_from_obj({BackupVersion = BackupVersion})
end
---@param obj Bios.BackupVersion
function TBackupVersion:init_from_obj(obj)
    self.BackupVersion = obj.BackupVersion
end

function TBackupVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBackupVersion.group)
end

TBackupVersion.from_obj = TBackupVersion_from_obj

TBackupVersion.proto_property = {'BackupVersion'}

TBackupVersion.default = {''}

TBackupVersion.struct = {{name = 'BackupVersion', is_array = false, struct = nil}}

function TBackupVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BackupVersion', self.BackupVersion, 'string', true, errs, need_convert)

    TBackupVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBackupVersion.proto_property, errs, need_convert)
    return self
end

function TBackupVersion:unpack(_)
    return self.BackupVersion
end

Bios.BackupVersion = TBackupVersion

---@class Bios.Version
---@field Version string
local TVersion = {}
TVersion.__index = TVersion
TVersion.group = {}

local function TVersion_from_obj(obj)
    return setmetatable(obj, TVersion)
end

function TVersion.new(Version)
    return TVersion_from_obj({Version = Version})
end
---@param obj Bios.Version
function TVersion:init_from_obj(obj)
    self.Version = obj.Version
end

function TVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVersion.group)
end

TVersion.from_obj = TVersion_from_obj

TVersion.proto_property = {'Version'}

TVersion.default = {''}

TVersion.struct = {{name = 'Version', is_array = false, struct = nil}}

function TVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Version', self.Version, 'string', true, errs, need_convert)

    TVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVersion.proto_property, errs, need_convert)
    return self
end

function TVersion:unpack(_)
    return self.Version
end

Bios.Version = TVersion

---@class Bios.SystemId
---@field SystemId integer
local TSystemId = {}
TSystemId.__index = TSystemId
TSystemId.group = {}

local function TSystemId_from_obj(obj)
    return setmetatable(obj, TSystemId)
end

function TSystemId.new(SystemId)
    return TSystemId_from_obj({SystemId = SystemId})
end
---@param obj Bios.SystemId
function TSystemId:init_from_obj(obj)
    self.SystemId = obj.SystemId
end

function TSystemId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemId.group)
end

TSystemId.from_obj = TSystemId_from_obj

TSystemId.proto_property = {'SystemId'}

TSystemId.default = {0}

TSystemId.struct = {{name = 'SystemId', is_array = false, struct = nil}}

function TSystemId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'uint8', true, errs, need_convert)

    TSystemId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemId.proto_property, errs, need_convert)
    return self
end

function TSystemId:unpack(_)
    return self.SystemId
end

Bios.SystemId = TSystemId

---@class Bios.SystemStartupState
---@field SystemStartupState integer
local TSystemStartupState = {}
TSystemStartupState.__index = TSystemStartupState
TSystemStartupState.group = {}

local function TSystemStartupState_from_obj(obj)
    return setmetatable(obj, TSystemStartupState)
end

function TSystemStartupState.new(SystemStartupState)
    return TSystemStartupState_from_obj({SystemStartupState = SystemStartupState})
end
---@param obj Bios.SystemStartupState
function TSystemStartupState:init_from_obj(obj)
    self.SystemStartupState = obj.SystemStartupState
end

function TSystemStartupState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemStartupState.group)
end

TSystemStartupState.from_obj = TSystemStartupState_from_obj

TSystemStartupState.proto_property = {'SystemStartupState'}

TSystemStartupState.default = {0}

TSystemStartupState.struct = {{name = 'SystemStartupState', is_array = false, struct = nil}}

function TSystemStartupState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemStartupState', self.SystemStartupState, 'uint8', true, errs, need_convert)

    if self.SystemStartupState ~= nil then
        validate.Enum(prefix .. 'SystemStartupState', self.SystemStartupState, '', {0, 32, 64, 96, 99, 102, 111, 254},
            errs, need_convert)
    end

    TSystemStartupState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemStartupState.proto_property, errs, need_convert)
    return self
end

function TSystemStartupState:unpack(_)
    return self.SystemStartupState
end

Bios.SystemStartupState = TSystemStartupState

---@class Bios.ExportBiosSetupRsp
---@field Result string
local TExportBiosSetupRsp = {}
TExportBiosSetupRsp.__index = TExportBiosSetupRsp
TExportBiosSetupRsp.group = {}

local function TExportBiosSetupRsp_from_obj(obj)
    return setmetatable(obj, TExportBiosSetupRsp)
end

function TExportBiosSetupRsp.new(Result)
    return TExportBiosSetupRsp_from_obj({Result = Result})
end
---@param obj Bios.ExportBiosSetupRsp
function TExportBiosSetupRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TExportBiosSetupRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportBiosSetupRsp.group)
end

TExportBiosSetupRsp.from_obj = TExportBiosSetupRsp_from_obj

TExportBiosSetupRsp.proto_property = {'Result'}

TExportBiosSetupRsp.default = {''}

TExportBiosSetupRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TExportBiosSetupRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'string', false, errs, need_convert)

    TExportBiosSetupRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportBiosSetupRsp.proto_property, errs, need_convert)
    return self
end

function TExportBiosSetupRsp:unpack(_)
    return self.Result
end

Bios.ExportBiosSetupRsp = TExportBiosSetupRsp

---@class Bios.ExportBiosSetupReq
---@field FileType string
local TExportBiosSetupReq = {}
TExportBiosSetupReq.__index = TExportBiosSetupReq
TExportBiosSetupReq.group = {}

local function TExportBiosSetupReq_from_obj(obj)
    return setmetatable(obj, TExportBiosSetupReq)
end

function TExportBiosSetupReq.new(FileType)
    return TExportBiosSetupReq_from_obj({FileType = FileType})
end
---@param obj Bios.ExportBiosSetupReq
function TExportBiosSetupReq:init_from_obj(obj)
    self.FileType = obj.FileType
end

function TExportBiosSetupReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportBiosSetupReq.group)
end

TExportBiosSetupReq.from_obj = TExportBiosSetupReq_from_obj

TExportBiosSetupReq.proto_property = {'FileType'}

TExportBiosSetupReq.default = {''}

TExportBiosSetupReq.struct = {{name = 'FileType', is_array = false, struct = nil}}

function TExportBiosSetupReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FileType', self.FileType, 'string', false, errs, need_convert)

    TExportBiosSetupReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportBiosSetupReq.proto_property, errs, need_convert)
    return self
end

function TExportBiosSetupReq:unpack(_)
    return self.FileType
end

Bios.ExportBiosSetupReq = TExportBiosSetupReq

---@class Bios.SetBiosLogEnabledRsp
---@field Result integer
local TSetBiosLogEnabledRsp = {}
TSetBiosLogEnabledRsp.__index = TSetBiosLogEnabledRsp
TSetBiosLogEnabledRsp.group = {}

local function TSetBiosLogEnabledRsp_from_obj(obj)
    return setmetatable(obj, TSetBiosLogEnabledRsp)
end

function TSetBiosLogEnabledRsp.new(Result)
    return TSetBiosLogEnabledRsp_from_obj({Result = Result})
end
---@param obj Bios.SetBiosLogEnabledRsp
function TSetBiosLogEnabledRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TSetBiosLogEnabledRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBiosLogEnabledRsp.group)
end

TSetBiosLogEnabledRsp.from_obj = TSetBiosLogEnabledRsp_from_obj

TSetBiosLogEnabledRsp.proto_property = {'Result'}

TSetBiosLogEnabledRsp.default = {0}

TSetBiosLogEnabledRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TSetBiosLogEnabledRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TSetBiosLogEnabledRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBiosLogEnabledRsp.proto_property, errs, need_convert)
    return self
end

function TSetBiosLogEnabledRsp:unpack(_)
    return self.Result
end

Bios.SetBiosLogEnabledRsp = TSetBiosLogEnabledRsp

---@class Bios.SetBiosLogEnabledReq
---@field BiosLogPrintEnabled integer
local TSetBiosLogEnabledReq = {}
TSetBiosLogEnabledReq.__index = TSetBiosLogEnabledReq
TSetBiosLogEnabledReq.group = {}

local function TSetBiosLogEnabledReq_from_obj(obj)
    return setmetatable(obj, TSetBiosLogEnabledReq)
end

function TSetBiosLogEnabledReq.new(BiosLogPrintEnabled)
    return TSetBiosLogEnabledReq_from_obj({BiosLogPrintEnabled = BiosLogPrintEnabled})
end
---@param obj Bios.SetBiosLogEnabledReq
function TSetBiosLogEnabledReq:init_from_obj(obj)
    self.BiosLogPrintEnabled = obj.BiosLogPrintEnabled
end

function TSetBiosLogEnabledReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBiosLogEnabledReq.group)
end

TSetBiosLogEnabledReq.from_obj = TSetBiosLogEnabledReq_from_obj

TSetBiosLogEnabledReq.proto_property = {'BiosLogPrintEnabled'}

TSetBiosLogEnabledReq.default = {0}

TSetBiosLogEnabledReq.struct = {{name = 'BiosLogPrintEnabled', is_array = false, struct = nil}}

function TSetBiosLogEnabledReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BiosLogPrintEnabled', self.BiosLogPrintEnabled, 'uint8', false, errs, need_convert)

    TSetBiosLogEnabledReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBiosLogEnabledReq.proto_property, errs, need_convert)
    return self
end

function TSetBiosLogEnabledReq:unpack(_)
    return self.BiosLogPrintEnabled
end

Bios.SetBiosLogEnabledReq = TSetBiosLogEnabledReq

---@class Bios.SetBiosConfigActiveModeRsp
local TSetBiosConfigActiveModeRsp = {}
TSetBiosConfigActiveModeRsp.__index = TSetBiosConfigActiveModeRsp
TSetBiosConfigActiveModeRsp.group = {}

local function TSetBiosConfigActiveModeRsp_from_obj(obj)
    return setmetatable(obj, TSetBiosConfigActiveModeRsp)
end

function TSetBiosConfigActiveModeRsp.new()
    return TSetBiosConfigActiveModeRsp_from_obj({})
end
---@param obj Bios.SetBiosConfigActiveModeRsp
function TSetBiosConfigActiveModeRsp:init_from_obj(obj)

end

function TSetBiosConfigActiveModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBiosConfigActiveModeRsp.group)
end

TSetBiosConfigActiveModeRsp.from_obj = TSetBiosConfigActiveModeRsp_from_obj

TSetBiosConfigActiveModeRsp.proto_property = {}

TSetBiosConfigActiveModeRsp.default = {}

TSetBiosConfigActiveModeRsp.struct = {}

function TSetBiosConfigActiveModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetBiosConfigActiveModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBiosConfigActiveModeRsp.proto_property, errs, need_convert)
    return self
end

function TSetBiosConfigActiveModeRsp:unpack(_)
end

Bios.SetBiosConfigActiveModeRsp = TSetBiosConfigActiveModeRsp

---@class Bios.SetBiosConfigActiveModeReq
---@field Mode integer
local TSetBiosConfigActiveModeReq = {}
TSetBiosConfigActiveModeReq.__index = TSetBiosConfigActiveModeReq
TSetBiosConfigActiveModeReq.group = {}

local function TSetBiosConfigActiveModeReq_from_obj(obj)
    return setmetatable(obj, TSetBiosConfigActiveModeReq)
end

function TSetBiosConfigActiveModeReq.new(Mode)
    return TSetBiosConfigActiveModeReq_from_obj({Mode = Mode})
end
---@param obj Bios.SetBiosConfigActiveModeReq
function TSetBiosConfigActiveModeReq:init_from_obj(obj)
    self.Mode = obj.Mode
end

function TSetBiosConfigActiveModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBiosConfigActiveModeReq.group)
end

TSetBiosConfigActiveModeReq.from_obj = TSetBiosConfigActiveModeReq_from_obj

TSetBiosConfigActiveModeReq.proto_property = {'Mode'}

TSetBiosConfigActiveModeReq.default = {0}

TSetBiosConfigActiveModeReq.struct = {{name = 'Mode', is_array = false, struct = nil}}

function TSetBiosConfigActiveModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Mode', self.Mode, 'uint64', false, errs, need_convert)

    TSetBiosConfigActiveModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBiosConfigActiveModeReq.proto_property, errs, need_convert)
    return self
end

function TSetBiosConfigActiveModeReq:unpack(_)
    return self.Mode
end

Bios.SetBiosConfigActiveModeReq = TSetBiosConfigActiveModeReq

---@class Bios.ExportFirmwareRsp
---@field TaskId integer
local TExportFirmwareRsp = {}
TExportFirmwareRsp.__index = TExportFirmwareRsp
TExportFirmwareRsp.group = {}

local function TExportFirmwareRsp_from_obj(obj)
    return setmetatable(obj, TExportFirmwareRsp)
end

function TExportFirmwareRsp.new(TaskId)
    return TExportFirmwareRsp_from_obj({TaskId = TaskId})
end
---@param obj Bios.ExportFirmwareRsp
function TExportFirmwareRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TExportFirmwareRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportFirmwareRsp.group)
end

TExportFirmwareRsp.from_obj = TExportFirmwareRsp_from_obj

TExportFirmwareRsp.proto_property = {'TaskId'}

TExportFirmwareRsp.default = {0}

TExportFirmwareRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TExportFirmwareRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TExportFirmwareRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportFirmwareRsp.proto_property, errs, need_convert)
    return self
end

function TExportFirmwareRsp:unpack(_)
    return self.TaskId
end

Bios.ExportFirmwareRsp = TExportFirmwareRsp

---@class Bios.ExportFirmwareReq
local TExportFirmwareReq = {}
TExportFirmwareReq.__index = TExportFirmwareReq
TExportFirmwareReq.group = {}

local function TExportFirmwareReq_from_obj(obj)
    return setmetatable(obj, TExportFirmwareReq)
end

function TExportFirmwareReq.new()
    return TExportFirmwareReq_from_obj({})
end
---@param obj Bios.ExportFirmwareReq
function TExportFirmwareReq:init_from_obj(obj)

end

function TExportFirmwareReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportFirmwareReq.group)
end

TExportFirmwareReq.from_obj = TExportFirmwareReq_from_obj

TExportFirmwareReq.proto_property = {}

TExportFirmwareReq.default = {}

TExportFirmwareReq.struct = {}

function TExportFirmwareReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TExportFirmwareReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportFirmwareReq.proto_property, errs, need_convert)
    return self
end

function TExportFirmwareReq:unpack(_)
end

Bios.ExportFirmwareReq = TExportFirmwareReq

---@class Bios.RemoveCachedSettingsRsp
---@field Result integer
local TRemoveCachedSettingsRsp = {}
TRemoveCachedSettingsRsp.__index = TRemoveCachedSettingsRsp
TRemoveCachedSettingsRsp.group = {}

local function TRemoveCachedSettingsRsp_from_obj(obj)
    return setmetatable(obj, TRemoveCachedSettingsRsp)
end

function TRemoveCachedSettingsRsp.new(Result)
    return TRemoveCachedSettingsRsp_from_obj({Result = Result})
end
---@param obj Bios.RemoveCachedSettingsRsp
function TRemoveCachedSettingsRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TRemoveCachedSettingsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRemoveCachedSettingsRsp.group)
end

TRemoveCachedSettingsRsp.from_obj = TRemoveCachedSettingsRsp_from_obj

TRemoveCachedSettingsRsp.proto_property = {'Result'}

TRemoveCachedSettingsRsp.default = {0}

TRemoveCachedSettingsRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TRemoveCachedSettingsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TRemoveCachedSettingsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRemoveCachedSettingsRsp.proto_property, errs, need_convert)
    return self
end

function TRemoveCachedSettingsRsp:unpack(_)
    return self.Result
end

Bios.RemoveCachedSettingsRsp = TRemoveCachedSettingsRsp

---@class Bios.RemoveCachedSettingsReq
local TRemoveCachedSettingsReq = {}
TRemoveCachedSettingsReq.__index = TRemoveCachedSettingsReq
TRemoveCachedSettingsReq.group = {}

local function TRemoveCachedSettingsReq_from_obj(obj)
    return setmetatable(obj, TRemoveCachedSettingsReq)
end

function TRemoveCachedSettingsReq.new()
    return TRemoveCachedSettingsReq_from_obj({})
end
---@param obj Bios.RemoveCachedSettingsReq
function TRemoveCachedSettingsReq:init_from_obj(obj)

end

function TRemoveCachedSettingsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRemoveCachedSettingsReq.group)
end

TRemoveCachedSettingsReq.from_obj = TRemoveCachedSettingsReq_from_obj

TRemoveCachedSettingsReq.proto_property = {}

TRemoveCachedSettingsReq.default = {}

TRemoveCachedSettingsReq.struct = {}

function TRemoveCachedSettingsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TRemoveCachedSettingsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRemoveCachedSettingsReq.proto_property, errs, need_convert)
    return self
end

function TRemoveCachedSettingsReq:unpack(_)
end

Bios.RemoveCachedSettingsReq = TRemoveCachedSettingsReq

---@class Bios.GetCurrentValueSettingRsp
---@field RespValue string
local TGetCurrentValueSettingRsp = {}
TGetCurrentValueSettingRsp.__index = TGetCurrentValueSettingRsp
TGetCurrentValueSettingRsp.group = {}

local function TGetCurrentValueSettingRsp_from_obj(obj)
    return setmetatable(obj, TGetCurrentValueSettingRsp)
end

function TGetCurrentValueSettingRsp.new(RespValue)
    return TGetCurrentValueSettingRsp_from_obj({RespValue = RespValue})
end
---@param obj Bios.GetCurrentValueSettingRsp
function TGetCurrentValueSettingRsp:init_from_obj(obj)
    self.RespValue = obj.RespValue
end

function TGetCurrentValueSettingRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCurrentValueSettingRsp.group)
end

TGetCurrentValueSettingRsp.from_obj = TGetCurrentValueSettingRsp_from_obj

TGetCurrentValueSettingRsp.proto_property = {'RespValue'}

TGetCurrentValueSettingRsp.default = {''}

TGetCurrentValueSettingRsp.struct = {{name = 'RespValue', is_array = false, struct = nil}}

function TGetCurrentValueSettingRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RespValue', self.RespValue, 'string', false, errs, need_convert)

    TGetCurrentValueSettingRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCurrentValueSettingRsp.proto_property, errs, need_convert)
    return self
end

function TGetCurrentValueSettingRsp:unpack(_)
    return self.RespValue
end

Bios.GetCurrentValueSettingRsp = TGetCurrentValueSettingRsp

---@class Bios.GetCurrentValueSettingReq
---@field ReqKey string
local TGetCurrentValueSettingReq = {}
TGetCurrentValueSettingReq.__index = TGetCurrentValueSettingReq
TGetCurrentValueSettingReq.group = {}

local function TGetCurrentValueSettingReq_from_obj(obj)
    return setmetatable(obj, TGetCurrentValueSettingReq)
end

function TGetCurrentValueSettingReq.new(ReqKey)
    return TGetCurrentValueSettingReq_from_obj({ReqKey = ReqKey})
end
---@param obj Bios.GetCurrentValueSettingReq
function TGetCurrentValueSettingReq:init_from_obj(obj)
    self.ReqKey = obj.ReqKey
end

function TGetCurrentValueSettingReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCurrentValueSettingReq.group)
end

TGetCurrentValueSettingReq.from_obj = TGetCurrentValueSettingReq_from_obj

TGetCurrentValueSettingReq.proto_property = {'ReqKey'}

TGetCurrentValueSettingReq.default = {''}

TGetCurrentValueSettingReq.struct = {{name = 'ReqKey', is_array = false, struct = nil}}

function TGetCurrentValueSettingReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReqKey', self.ReqKey, 'string', false, errs, need_convert)

    TGetCurrentValueSettingReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCurrentValueSettingReq.proto_property, errs, need_convert)
    return self
end

function TGetCurrentValueSettingReq:unpack(_)
    return self.ReqKey
end

Bios.GetCurrentValueSettingReq = TGetCurrentValueSettingReq

---@class Bios.ImportBiosSetupRsp
---@field Result integer
local TImportBiosSetupRsp = {}
TImportBiosSetupRsp.__index = TImportBiosSetupRsp
TImportBiosSetupRsp.group = {}

local function TImportBiosSetupRsp_from_obj(obj)
    return setmetatable(obj, TImportBiosSetupRsp)
end

function TImportBiosSetupRsp.new(Result)
    return TImportBiosSetupRsp_from_obj({Result = Result})
end
---@param obj Bios.ImportBiosSetupRsp
function TImportBiosSetupRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TImportBiosSetupRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportBiosSetupRsp.group)
end

TImportBiosSetupRsp.from_obj = TImportBiosSetupRsp_from_obj

TImportBiosSetupRsp.proto_property = {'Result'}

TImportBiosSetupRsp.default = {0}

TImportBiosSetupRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TImportBiosSetupRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TImportBiosSetupRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportBiosSetupRsp.proto_property, errs, need_convert)
    return self
end

function TImportBiosSetupRsp:unpack(_)
    return self.Result
end

Bios.ImportBiosSetupRsp = TImportBiosSetupRsp

---@class Bios.ImportBiosSetupReq
---@field FileType string
---@field Content string
local TImportBiosSetupReq = {}
TImportBiosSetupReq.__index = TImportBiosSetupReq
TImportBiosSetupReq.group = {}

local function TImportBiosSetupReq_from_obj(obj)
    return setmetatable(obj, TImportBiosSetupReq)
end

function TImportBiosSetupReq.new(FileType, Content)
    return TImportBiosSetupReq_from_obj({FileType = FileType, Content = Content})
end
---@param obj Bios.ImportBiosSetupReq
function TImportBiosSetupReq:init_from_obj(obj)
    self.FileType = obj.FileType
    self.Content = obj.Content
end

function TImportBiosSetupReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportBiosSetupReq.group)
end

TImportBiosSetupReq.from_obj = TImportBiosSetupReq_from_obj

TImportBiosSetupReq.proto_property = {'FileType', 'Content'}

TImportBiosSetupReq.default = {'', ''}

TImportBiosSetupReq.struct = {
    {name = 'FileType', is_array = false, struct = nil}, {name = 'Content', is_array = false, struct = nil}
}

function TImportBiosSetupReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FileType', self.FileType, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Content', self.Content, 'string', false, errs, need_convert)

    TImportBiosSetupReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportBiosSetupReq.proto_property, errs, need_convert)
    return self
end

function TImportBiosSetupReq:unpack(_)
    return self.FileType, self.Content
end

Bios.ImportBiosSetupReq = TImportBiosSetupReq

---@class Bios.ChangePasswordRsp
---@field Result integer
local TChangePasswordRsp = {}
TChangePasswordRsp.__index = TChangePasswordRsp
TChangePasswordRsp.group = {}

local function TChangePasswordRsp_from_obj(obj)
    return setmetatable(obj, TChangePasswordRsp)
end

function TChangePasswordRsp.new(Result)
    return TChangePasswordRsp_from_obj({Result = Result})
end
---@param obj Bios.ChangePasswordRsp
function TChangePasswordRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TChangePasswordRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChangePasswordRsp.group)
end

TChangePasswordRsp.from_obj = TChangePasswordRsp_from_obj

TChangePasswordRsp.proto_property = {'Result'}

TChangePasswordRsp.default = {0}

TChangePasswordRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TChangePasswordRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TChangePasswordRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChangePasswordRsp.proto_property, errs, need_convert)
    return self
end

function TChangePasswordRsp:unpack(_)
    return self.Result
end

Bios.ChangePasswordRsp = TChangePasswordRsp

---@class Bios.ChangePasswordReq
---@field PasswordType string
---@field OldPassword string
---@field NewPassword string
local TChangePasswordReq = {}
TChangePasswordReq.__index = TChangePasswordReq
TChangePasswordReq.group = {}

local function TChangePasswordReq_from_obj(obj)
    return setmetatable(obj, TChangePasswordReq)
end

function TChangePasswordReq.new(PasswordType, OldPassword, NewPassword)
    return TChangePasswordReq_from_obj({
        PasswordType = PasswordType,
        OldPassword = OldPassword,
        NewPassword = NewPassword
    })
end
---@param obj Bios.ChangePasswordReq
function TChangePasswordReq:init_from_obj(obj)
    self.PasswordType = obj.PasswordType
    self.OldPassword = obj.OldPassword
    self.NewPassword = obj.NewPassword
end

function TChangePasswordReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChangePasswordReq.group)
end

TChangePasswordReq.from_obj = TChangePasswordReq_from_obj

TChangePasswordReq.proto_property = {'PasswordType', 'OldPassword', 'NewPassword'}

TChangePasswordReq.default = {'', '', ''}

TChangePasswordReq.struct = {
    {name = 'PasswordType', is_array = false, struct = nil}, {name = 'OldPassword', is_array = false, struct = nil},
    {name = 'NewPassword', is_array = false, struct = nil}
}

function TChangePasswordReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PasswordType', self.PasswordType, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'OldPassword', self.OldPassword, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'NewPassword', self.NewPassword, 'string', false, errs, need_convert)

    TChangePasswordReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChangePasswordReq.proto_property, errs, need_convert)
    return self
end

function TChangePasswordReq:unpack(_)
    return self.PasswordType, self.OldPassword, self.NewPassword
end

Bios.ChangePasswordReq = TChangePasswordReq

---@class Bios.ResetSetupConfigRsp
---@field Result integer
local TResetSetupConfigRsp = {}
TResetSetupConfigRsp.__index = TResetSetupConfigRsp
TResetSetupConfigRsp.group = {}

local function TResetSetupConfigRsp_from_obj(obj)
    return setmetatable(obj, TResetSetupConfigRsp)
end

function TResetSetupConfigRsp.new(Result)
    return TResetSetupConfigRsp_from_obj({Result = Result})
end
---@param obj Bios.ResetSetupConfigRsp
function TResetSetupConfigRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TResetSetupConfigRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetSetupConfigRsp.group)
end

TResetSetupConfigRsp.from_obj = TResetSetupConfigRsp_from_obj

TResetSetupConfigRsp.proto_property = {'Result'}

TResetSetupConfigRsp.default = {0}

TResetSetupConfigRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TResetSetupConfigRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TResetSetupConfigRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetSetupConfigRsp.proto_property, errs, need_convert)
    return self
end

function TResetSetupConfigRsp:unpack(_)
    return self.Result
end

Bios.ResetSetupConfigRsp = TResetSetupConfigRsp

---@class Bios.ResetSetupConfigReq
local TResetSetupConfigReq = {}
TResetSetupConfigReq.__index = TResetSetupConfigReq
TResetSetupConfigReq.group = {}

local function TResetSetupConfigReq_from_obj(obj)
    return setmetatable(obj, TResetSetupConfigReq)
end

function TResetSetupConfigReq.new()
    return TResetSetupConfigReq_from_obj({})
end
---@param obj Bios.ResetSetupConfigReq
function TResetSetupConfigReq:init_from_obj(obj)

end

function TResetSetupConfigReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetSetupConfigReq.group)
end

TResetSetupConfigReq.from_obj = TResetSetupConfigReq_from_obj

TResetSetupConfigReq.proto_property = {}

TResetSetupConfigReq.default = {}

TResetSetupConfigReq.struct = {}

function TResetSetupConfigReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TResetSetupConfigReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetSetupConfigReq.proto_property, errs, need_convert)
    return self
end

function TResetSetupConfigReq:unpack(_)
end

Bios.ResetSetupConfigReq = TResetSetupConfigReq

---@class Bios.ClearCmosRsp
---@field Result integer
local TClearCmosRsp = {}
TClearCmosRsp.__index = TClearCmosRsp
TClearCmosRsp.group = {}

local function TClearCmosRsp_from_obj(obj)
    return setmetatable(obj, TClearCmosRsp)
end

function TClearCmosRsp.new(Result)
    return TClearCmosRsp_from_obj({Result = Result})
end
---@param obj Bios.ClearCmosRsp
function TClearCmosRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TClearCmosRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClearCmosRsp.group)
end

TClearCmosRsp.from_obj = TClearCmosRsp_from_obj

TClearCmosRsp.proto_property = {'Result'}

TClearCmosRsp.default = {0}

TClearCmosRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TClearCmosRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TClearCmosRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClearCmosRsp.proto_property, errs, need_convert)
    return self
end

function TClearCmosRsp:unpack(_)
    return self.Result
end

Bios.ClearCmosRsp = TClearCmosRsp

---@class Bios.ClearCmosReq
local TClearCmosReq = {}
TClearCmosReq.__index = TClearCmosReq
TClearCmosReq.group = {}

local function TClearCmosReq_from_obj(obj)
    return setmetatable(obj, TClearCmosReq)
end

function TClearCmosReq.new()
    return TClearCmosReq_from_obj({})
end
---@param obj Bios.ClearCmosReq
function TClearCmosReq:init_from_obj(obj)

end

function TClearCmosReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClearCmosReq.group)
end

TClearCmosReq.from_obj = TClearCmosReq_from_obj

TClearCmosReq.proto_property = {}

TClearCmosReq.default = {}

TClearCmosReq.struct = {}

function TClearCmosReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TClearCmosReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClearCmosReq.proto_property, errs, need_convert)
    return self
end

function TClearCmosReq:unpack(_)
end

Bios.ClearCmosReq = TClearCmosReq

Bios.interface = mdb.register_interface('bmc.kepler.Systems.Bios', {
    SystemStartupState = {'y', nil, true, nil, false},
    SystemId = {'y', nil, true, nil, false},
    Version = {'s', nil, true, nil, false},
    BackupVersion = {'s', nil, true, nil, false},
    CurrentValueFileName = {'s', nil, true, nil, false},
    ResultFileName = {'s', nil, true, nil, false},
    SettingFileName = {'s', nil, true, nil, false},
    RegistryFileName = {'s', nil, true, nil, false},
    MenuData = {'s', nil, true, nil, false},
    MenuChangeFlag = {'y', nil, true, nil, false},
    RegistryVersion = {'s', nil, true, nil, false},
    DEMTConfig = {'y', nil, true, nil, false},
    PcieCardBDF = {'ay', nil, true, nil, false},
    PcieDiskBDF = {'ay', nil, true, nil, false},
    OCPCardBDF = {'ay', nil, true, nil, false},
    BiosBootStage = {'y', nil, true, nil, false},
    UpgradeFailed = {'y', nil, true, nil, false},
    RecoverFailed = {'y', nil, true, nil, false},
    BiosLogPrintEnabled = {'y', nil, true, nil, false},
    BiosConfigActiveMode = {'t', nil, true, nil, false},
    ResetBiosToDefaultsPending = {'b', nil, true, nil, false},
    SettingsEffectiveStatus = {'s', nil, true, nil, false},
    TeeOSVersion = {'s', nil, true, nil, false}
}, {
    ClearCmos = {'a{ss}', 'i', TClearCmosReq, TClearCmosRsp},
    ResetSetupConfig = {'a{ss}', 'i', TResetSetupConfigReq, TResetSetupConfigRsp},
    ChangePassword = {'a{ss}sss', 'i', TChangePasswordReq, TChangePasswordRsp},
    ImportBiosSetup = {'a{ss}ss', 'i', TImportBiosSetupReq, TImportBiosSetupRsp},
    GetCurrentValueSetting = {'a{ss}s', 's', TGetCurrentValueSettingReq, TGetCurrentValueSettingRsp},
    RemoveCachedSettings = {'a{ss}', 'i', TRemoveCachedSettingsReq, TRemoveCachedSettingsRsp},
    ExportFirmware = {'a{ss}', 'u', TExportFirmwareReq, TExportFirmwareRsp},
    SetBiosConfigActiveMode = {'a{ss}t', '', TSetBiosConfigActiveModeReq, TSetBiosConfigActiveModeRsp},
    SetBiosLogEnabled = {'a{ss}y', 'i', TSetBiosLogEnabledReq, TSetBiosLogEnabledRsp},
    ExportBiosSetup = {'a{ss}s', 's', TExportBiosSetupReq, TExportBiosSetupRsp}
}, {})

return Bios
