--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local WriteSmbiosData = {}

---@class BiosIpmiCmds.WriteSmbiosDataReq
---@field ManufactureId integer
---@field BiosId integer
---@field Operation integer
---@field Srcdata string
local TWriteSmbiosDataReq = {}
TWriteSmbiosDataReq.__index = TWriteSmbiosDataReq
TWriteSmbiosDataReq.group = {}

local function TWriteSmbiosDataReq_from_obj(obj)
    return setmetatable(obj, TWriteSmbiosDataReq)
end

function TWriteSmbiosDataReq.new(ManufactureId, BiosId, Operation, Srcdata)
    return TWriteSmbiosDataReq_from_obj({
        ManufactureId = ManufactureId,
        BiosId = BiosId,
        Operation = Operation,
        Srcdata = Srcdata
    })
end
---@param obj BiosIpmiCmds.WriteSmbiosDataReq
function TWriteSmbiosDataReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.BiosId = obj.BiosId
    self.Operation = obj.Operation
    self.Srcdata = obj.Srcdata
end

function TWriteSmbiosDataReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWriteSmbiosDataReq.group)
end

TWriteSmbiosDataReq.from_obj = TWriteSmbiosDataReq_from_obj

TWriteSmbiosDataReq.proto_property = {'ManufactureId', 'BiosId', 'Operation', 'Srcdata'}

TWriteSmbiosDataReq.default = {0, 0, 0, ''}

TWriteSmbiosDataReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'BiosId', is_array = false, struct = nil},
    {name = 'Operation', is_array = false, struct = nil}, {name = 'Srcdata', is_array = false, struct = nil}
}

function TWriteSmbiosDataReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'BiosId', self.BiosId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Operation', self.Operation, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Srcdata', self.Srcdata, 'string', false, errs, need_convert)

    TWriteSmbiosDataReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWriteSmbiosDataReq.proto_property, errs, need_convert)
    return self
end

function TWriteSmbiosDataReq:unpack(_)
    return self.ManufactureId, self.BiosId, self.Operation, self.Srcdata
end

WriteSmbiosData.WriteSmbiosDataReq = TWriteSmbiosDataReq

---@class BiosIpmiCmds.WriteSmbiosDataRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field RequiredOffset string
local TWriteSmbiosDataRsp = {}
TWriteSmbiosDataRsp.__index = TWriteSmbiosDataRsp
TWriteSmbiosDataRsp.group = {}

local function TWriteSmbiosDataRsp_from_obj(obj)
    return setmetatable(obj, TWriteSmbiosDataRsp)
end

function TWriteSmbiosDataRsp.new(CompletionCode, ManufactureId, RequiredOffset)
    return TWriteSmbiosDataRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        RequiredOffset = RequiredOffset
    })
end
---@param obj BiosIpmiCmds.WriteSmbiosDataRsp
function TWriteSmbiosDataRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.RequiredOffset = obj.RequiredOffset
end

function TWriteSmbiosDataRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWriteSmbiosDataRsp.group)
end

TWriteSmbiosDataRsp.from_obj = TWriteSmbiosDataRsp_from_obj

TWriteSmbiosDataRsp.proto_property = {'CompletionCode', 'ManufactureId', 'RequiredOffset'}

TWriteSmbiosDataRsp.default = {0, 0, ''}

TWriteSmbiosDataRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'RequiredOffset', is_array = false, struct = nil}
}

function TWriteSmbiosDataRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'RequiredOffset', self.RequiredOffset, 'string', false, errs, need_convert)

    TWriteSmbiosDataRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWriteSmbiosDataRsp.proto_property, errs, need_convert)
    return self
end

function TWriteSmbiosDataRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.RequiredOffset
end

WriteSmbiosData.WriteSmbiosDataRsp = TWriteSmbiosDataRsp

return WriteSmbiosData
