--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local WriteOcpCardBdfToBmc = {}

---@class BiosIpmiCmds.WriteOcpCardBdfToBmcReq
---@field MaxFrame integer
---@field CurrentFrame integer
---@field PCIeSlotNumber integer
---@field BdfData string
local TWriteOcpCardBdfToBmcReq = {}
TWriteOcpCardBdfToBmcReq.__index = TWriteOcpCardBdfToBmcReq
TWriteOcpCardBdfToBmcReq.group = {}

local function TWriteOcpCardBdfToBmcReq_from_obj(obj)
    return setmetatable(obj, TWriteOcpCardBdfToBmcReq)
end

function TWriteOcpCardBdfToBmcReq.new(MaxFrame, CurrentFrame, PCIeSlotNumber, BdfData)
    return TWriteOcpCardBdfToBmcReq_from_obj({
        MaxFrame = MaxFrame,
        CurrentFrame = CurrentFrame,
        PCIeSlotNumber = PCIeSlotNumber,
        BdfData = BdfData
    })
end
---@param obj BiosIpmiCmds.WriteOcpCardBdfToBmcReq
function TWriteOcpCardBdfToBmcReq:init_from_obj(obj)
    self.MaxFrame = obj.MaxFrame
    self.CurrentFrame = obj.CurrentFrame
    self.PCIeSlotNumber = obj.PCIeSlotNumber
    self.BdfData = obj.BdfData
end

function TWriteOcpCardBdfToBmcReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWriteOcpCardBdfToBmcReq.group)
end

TWriteOcpCardBdfToBmcReq.from_obj = TWriteOcpCardBdfToBmcReq_from_obj

TWriteOcpCardBdfToBmcReq.proto_property = {'MaxFrame', 'CurrentFrame', 'PCIeSlotNumber', 'BdfData'}

TWriteOcpCardBdfToBmcReq.default = {0, 0, 0, ''}

TWriteOcpCardBdfToBmcReq.struct = {
    {name = 'MaxFrame', is_array = false, struct = nil}, {name = 'CurrentFrame', is_array = false, struct = nil},
    {name = 'PCIeSlotNumber', is_array = false, struct = nil}, {name = 'BdfData', is_array = false, struct = nil}
}

function TWriteOcpCardBdfToBmcReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxFrame', self.MaxFrame, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'CurrentFrame', self.CurrentFrame, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PCIeSlotNumber', self.PCIeSlotNumber, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BdfData', self.BdfData, 'string', false, errs, need_convert)

    TWriteOcpCardBdfToBmcReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWriteOcpCardBdfToBmcReq.proto_property, errs, need_convert)
    return self
end

function TWriteOcpCardBdfToBmcReq:unpack(_)
    return self.MaxFrame, self.CurrentFrame, self.PCIeSlotNumber, self.BdfData
end

WriteOcpCardBdfToBmc.WriteOcpCardBdfToBmcReq = TWriteOcpCardBdfToBmcReq

---@class BiosIpmiCmds.WriteOcpCardBdfToBmcRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TWriteOcpCardBdfToBmcRsp = {}
TWriteOcpCardBdfToBmcRsp.__index = TWriteOcpCardBdfToBmcRsp
TWriteOcpCardBdfToBmcRsp.group = {}

local function TWriteOcpCardBdfToBmcRsp_from_obj(obj)
    return setmetatable(obj, TWriteOcpCardBdfToBmcRsp)
end

function TWriteOcpCardBdfToBmcRsp.new(CompletionCode, ManufactureId)
    return TWriteOcpCardBdfToBmcRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj BiosIpmiCmds.WriteOcpCardBdfToBmcRsp
function TWriteOcpCardBdfToBmcRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TWriteOcpCardBdfToBmcRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWriteOcpCardBdfToBmcRsp.group)
end

TWriteOcpCardBdfToBmcRsp.from_obj = TWriteOcpCardBdfToBmcRsp_from_obj

TWriteOcpCardBdfToBmcRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TWriteOcpCardBdfToBmcRsp.default = {0, 0}

TWriteOcpCardBdfToBmcRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TWriteOcpCardBdfToBmcRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TWriteOcpCardBdfToBmcRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWriteOcpCardBdfToBmcRsp.proto_property, errs, need_convert)
    return self
end

function TWriteOcpCardBdfToBmcRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

WriteOcpCardBdfToBmc.WriteOcpCardBdfToBmcRsp = TWriteOcpCardBdfToBmcRsp

return WriteOcpCardBdfToBmc
