--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local UpdatePostStatus = {}

---@class BiosIpmiCmds.UpdatePostStatusReq
---@field ManufactureId integer
---@field Info string
local TUpdatePostStatusReq = {}
TUpdatePostStatusReq.__index = TUpdatePostStatusReq
TUpdatePostStatusReq.group = {}

local function TUpdatePostStatusReq_from_obj(obj)
    return setmetatable(obj, TUpdatePostStatusReq)
end

function TUpdatePostStatusReq.new(ManufactureId, Info)
    return TUpdatePostStatusReq_from_obj({ManufactureId = ManufactureId, Info = Info})
end
---@param obj BiosIpmiCmds.UpdatePostStatusReq
function TUpdatePostStatusReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Info = obj.Info
end

function TUpdatePostStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdatePostStatusReq.group)
end

TUpdatePostStatusReq.from_obj = TUpdatePostStatusReq_from_obj

TUpdatePostStatusReq.proto_property = {'ManufactureId', 'Info'}

TUpdatePostStatusReq.default = {0, ''}

TUpdatePostStatusReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Info', is_array = false, struct = nil}
}

function TUpdatePostStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Info', self.Info, 'string', false, errs, need_convert)

    TUpdatePostStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdatePostStatusReq.proto_property, errs, need_convert)
    return self
end

function TUpdatePostStatusReq:unpack(_)
    return self.ManufactureId, self.Info
end

UpdatePostStatus.UpdatePostStatusReq = TUpdatePostStatusReq

---@class BiosIpmiCmds.UpdatePostStatusRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TUpdatePostStatusRsp = {}
TUpdatePostStatusRsp.__index = TUpdatePostStatusRsp
TUpdatePostStatusRsp.group = {}

local function TUpdatePostStatusRsp_from_obj(obj)
    return setmetatable(obj, TUpdatePostStatusRsp)
end

function TUpdatePostStatusRsp.new(CompletionCode, ManufactureId)
    return TUpdatePostStatusRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj BiosIpmiCmds.UpdatePostStatusRsp
function TUpdatePostStatusRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TUpdatePostStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdatePostStatusRsp.group)
end

TUpdatePostStatusRsp.from_obj = TUpdatePostStatusRsp_from_obj

TUpdatePostStatusRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TUpdatePostStatusRsp.default = {0, 0}

TUpdatePostStatusRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TUpdatePostStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TUpdatePostStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdatePostStatusRsp.proto_property, errs, need_convert)
    return self
end

function TUpdatePostStatusRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

UpdatePostStatus.UpdatePostStatusRsp = TUpdatePostStatusRsp

return UpdatePostStatus
