--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetTeeOSVersion = {}

---@class BiosIpmiCmds.SetTeeOSVersionReq
---@field ManufactureId integer
---@field Type integer
---@field Length integer
---@field Version string
local TSetTeeOSVersionReq = {}
TSetTeeOSVersionReq.__index = TSetTeeOSVersionReq
TSetTeeOSVersionReq.group = {}

local function TSetTeeOSVersionReq_from_obj(obj)
    return setmetatable(obj, TSetTeeOSVersionReq)
end

function TSetTeeOSVersionReq.new(ManufactureId, Type, Length, Version)
    return
        TSetTeeOSVersionReq_from_obj({ManufactureId = ManufactureId, Type = Type, Length = Length, Version = Version})
end
---@param obj BiosIpmiCmds.SetTeeOSVersionReq
function TSetTeeOSVersionReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Type = obj.Type
    self.Length = obj.Length
    self.Version = obj.Version
end

function TSetTeeOSVersionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetTeeOSVersionReq.group)
end

TSetTeeOSVersionReq.from_obj = TSetTeeOSVersionReq_from_obj

TSetTeeOSVersionReq.proto_property = {'ManufactureId', 'Type', 'Length', 'Version'}

TSetTeeOSVersionReq.default = {0, 0, 0, ''}

TSetTeeOSVersionReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Type', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}, {name = 'Version', is_array = false, struct = nil}
}

function TSetTeeOSVersionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Type', self.Type, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Version', self.Version, 'string', false, errs, need_convert)

    TSetTeeOSVersionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetTeeOSVersionReq.proto_property, errs, need_convert)
    return self
end

function TSetTeeOSVersionReq:unpack(_)
    return self.ManufactureId, self.Type, self.Length, self.Version
end

SetTeeOSVersion.SetTeeOSVersionReq = TSetTeeOSVersionReq

---@class BiosIpmiCmds.SetTeeOSVersionRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetTeeOSVersionRsp = {}
TSetTeeOSVersionRsp.__index = TSetTeeOSVersionRsp
TSetTeeOSVersionRsp.group = {}

local function TSetTeeOSVersionRsp_from_obj(obj)
    return setmetatable(obj, TSetTeeOSVersionRsp)
end

function TSetTeeOSVersionRsp.new(CompletionCode, ManufactureId)
    return TSetTeeOSVersionRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj BiosIpmiCmds.SetTeeOSVersionRsp
function TSetTeeOSVersionRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetTeeOSVersionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetTeeOSVersionRsp.group)
end

TSetTeeOSVersionRsp.from_obj = TSetTeeOSVersionRsp_from_obj

TSetTeeOSVersionRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetTeeOSVersionRsp.default = {0, 0}

TSetTeeOSVersionRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetTeeOSVersionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetTeeOSVersionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetTeeOSVersionRsp.proto_property, errs, need_convert)
    return self
end

function TSetTeeOSVersionRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetTeeOSVersion.SetTeeOSVersionRsp = TSetTeeOSVersionRsp

return SetTeeOSVersion
