--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetProgressSystemInfo = {}

---@class BiosIpmiCmds.SetProgressSystemInfoReq
---@field Info string
local TSetProgressSystemInfoReq = {}
TSetProgressSystemInfoReq.__index = TSetProgressSystemInfoReq
TSetProgressSystemInfoReq.group = {}

local function TSetProgressSystemInfoReq_from_obj(obj)
    return setmetatable(obj, TSetProgressSystemInfoReq)
end

function TSetProgressSystemInfoReq.new(Info)
    return TSetProgressSystemInfoReq_from_obj({Info = Info})
end
---@param obj BiosIpmiCmds.SetProgressSystemInfoReq
function TSetProgressSystemInfoReq:init_from_obj(obj)
    self.Info = obj.Info
end

function TSetProgressSystemInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetProgressSystemInfoReq.group)
end

TSetProgressSystemInfoReq.from_obj = TSetProgressSystemInfoReq_from_obj

TSetProgressSystemInfoReq.proto_property = {'Info'}

TSetProgressSystemInfoReq.default = {''}

TSetProgressSystemInfoReq.struct = {{name = 'Info', is_array = false, struct = nil}}

function TSetProgressSystemInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Info', self.Info, 'string', false, errs, need_convert)

    TSetProgressSystemInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetProgressSystemInfoReq.proto_property, errs, need_convert)
    return self
end

function TSetProgressSystemInfoReq:unpack(_)
    return self.Info
end

SetProgressSystemInfo.SetProgressSystemInfoReq = TSetProgressSystemInfoReq

---@class BiosIpmiCmds.SetProgressSystemInfoRsp
---@field CompletionCode integer
local TSetProgressSystemInfoRsp = {}
TSetProgressSystemInfoRsp.__index = TSetProgressSystemInfoRsp
TSetProgressSystemInfoRsp.group = {}

local function TSetProgressSystemInfoRsp_from_obj(obj)
    return setmetatable(obj, TSetProgressSystemInfoRsp)
end

function TSetProgressSystemInfoRsp.new(CompletionCode)
    return TSetProgressSystemInfoRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj BiosIpmiCmds.SetProgressSystemInfoRsp
function TSetProgressSystemInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetProgressSystemInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetProgressSystemInfoRsp.group)
end

TSetProgressSystemInfoRsp.from_obj = TSetProgressSystemInfoRsp_from_obj

TSetProgressSystemInfoRsp.proto_property = {'CompletionCode'}

TSetProgressSystemInfoRsp.default = {0}

TSetProgressSystemInfoRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetProgressSystemInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetProgressSystemInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetProgressSystemInfoRsp.proto_property, errs, need_convert)
    return self
end

function TSetProgressSystemInfoRsp:unpack(_)
    return self.CompletionCode
end

SetProgressSystemInfo.SetProgressSystemInfoRsp = TSetProgressSystemInfoRsp

return SetProgressSystemInfo
