--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetPrimaryOperatingSystemName = {}

---@class BiosIpmiCmds.SetPrimaryOperatingSystemNameReq
---@field Info string
local TSetPrimaryOperatingSystemNameReq = {}
TSetPrimaryOperatingSystemNameReq.__index = TSetPrimaryOperatingSystemNameReq
TSetPrimaryOperatingSystemNameReq.group = {}

local function TSetPrimaryOperatingSystemNameReq_from_obj(obj)
    return setmetatable(obj, TSetPrimaryOperatingSystemNameReq)
end

function TSetPrimaryOperatingSystemNameReq.new(Info)
    return TSetPrimaryOperatingSystemNameReq_from_obj({Info = Info})
end
---@param obj BiosIpmiCmds.SetPrimaryOperatingSystemNameReq
function TSetPrimaryOperatingSystemNameReq:init_from_obj(obj)
    self.Info = obj.Info
end

function TSetPrimaryOperatingSystemNameReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPrimaryOperatingSystemNameReq.group)
end

TSetPrimaryOperatingSystemNameReq.from_obj = TSetPrimaryOperatingSystemNameReq_from_obj

TSetPrimaryOperatingSystemNameReq.proto_property = {'Info'}

TSetPrimaryOperatingSystemNameReq.default = {''}

TSetPrimaryOperatingSystemNameReq.struct = {{name = 'Info', is_array = false, struct = nil}}

function TSetPrimaryOperatingSystemNameReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Info', self.Info, 'string', false, errs, need_convert)

    TSetPrimaryOperatingSystemNameReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPrimaryOperatingSystemNameReq.proto_property, errs, need_convert)
    return self
end

function TSetPrimaryOperatingSystemNameReq:unpack(_)
    return self.Info
end

SetPrimaryOperatingSystemName.SetPrimaryOperatingSystemNameReq = TSetPrimaryOperatingSystemNameReq

---@class BiosIpmiCmds.SetPrimaryOperatingSystemNameRsp
---@field CompletionCode integer
local TSetPrimaryOperatingSystemNameRsp = {}
TSetPrimaryOperatingSystemNameRsp.__index = TSetPrimaryOperatingSystemNameRsp
TSetPrimaryOperatingSystemNameRsp.group = {}

local function TSetPrimaryOperatingSystemNameRsp_from_obj(obj)
    return setmetatable(obj, TSetPrimaryOperatingSystemNameRsp)
end

function TSetPrimaryOperatingSystemNameRsp.new(CompletionCode)
    return TSetPrimaryOperatingSystemNameRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj BiosIpmiCmds.SetPrimaryOperatingSystemNameRsp
function TSetPrimaryOperatingSystemNameRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetPrimaryOperatingSystemNameRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPrimaryOperatingSystemNameRsp.group)
end

TSetPrimaryOperatingSystemNameRsp.from_obj = TSetPrimaryOperatingSystemNameRsp_from_obj

TSetPrimaryOperatingSystemNameRsp.proto_property = {'CompletionCode'}

TSetPrimaryOperatingSystemNameRsp.default = {0}

TSetPrimaryOperatingSystemNameRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetPrimaryOperatingSystemNameRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetPrimaryOperatingSystemNameRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPrimaryOperatingSystemNameRsp.proto_property, errs, need_convert)
    return self
end

function TSetPrimaryOperatingSystemNameRsp:unpack(_)
    return self.CompletionCode
end

SetPrimaryOperatingSystemName.SetPrimaryOperatingSystemNameRsp = TSetPrimaryOperatingSystemNameRsp

return SetPrimaryOperatingSystemName
