--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetCachedBiosUpgradeMode = {}

---@class BiosIpmiCmds.SetCachedBiosUpgradeModeReq
---@field ManufactureId integer
---@field UpgradeMode integer
local TSetCachedBiosUpgradeModeReq = {}
TSetCachedBiosUpgradeModeReq.__index = TSetCachedBiosUpgradeModeReq
TSetCachedBiosUpgradeModeReq.group = {}

local function TSetCachedBiosUpgradeModeReq_from_obj(obj)
    return setmetatable(obj, TSetCachedBiosUpgradeModeReq)
end

function TSetCachedBiosUpgradeModeReq.new(ManufactureId, UpgradeMode)
    return TSetCachedBiosUpgradeModeReq_from_obj({ManufactureId = ManufactureId, UpgradeMode = UpgradeMode})
end
---@param obj BiosIpmiCmds.SetCachedBiosUpgradeModeReq
function TSetCachedBiosUpgradeModeReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.UpgradeMode = obj.UpgradeMode
end

function TSetCachedBiosUpgradeModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCachedBiosUpgradeModeReq.group)
end

TSetCachedBiosUpgradeModeReq.from_obj = TSetCachedBiosUpgradeModeReq_from_obj

TSetCachedBiosUpgradeModeReq.proto_property = {'ManufactureId', 'UpgradeMode'}

TSetCachedBiosUpgradeModeReq.default = {0, 0}

TSetCachedBiosUpgradeModeReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'UpgradeMode', is_array = false, struct = nil}
}

function TSetCachedBiosUpgradeModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'UpgradeMode', self.UpgradeMode, 'uint8', false, errs, need_convert)

    TSetCachedBiosUpgradeModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCachedBiosUpgradeModeReq.proto_property, errs, need_convert)
    return self
end

function TSetCachedBiosUpgradeModeReq:unpack(_)
    return self.ManufactureId, self.UpgradeMode
end

SetCachedBiosUpgradeMode.SetCachedBiosUpgradeModeReq = TSetCachedBiosUpgradeModeReq

---@class BiosIpmiCmds.SetCachedBiosUpgradeModeRsp
---@field CompletionCode integer
local TSetCachedBiosUpgradeModeRsp = {}
TSetCachedBiosUpgradeModeRsp.__index = TSetCachedBiosUpgradeModeRsp
TSetCachedBiosUpgradeModeRsp.group = {}

local function TSetCachedBiosUpgradeModeRsp_from_obj(obj)
    return setmetatable(obj, TSetCachedBiosUpgradeModeRsp)
end

function TSetCachedBiosUpgradeModeRsp.new(CompletionCode)
    return TSetCachedBiosUpgradeModeRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj BiosIpmiCmds.SetCachedBiosUpgradeModeRsp
function TSetCachedBiosUpgradeModeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetCachedBiosUpgradeModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCachedBiosUpgradeModeRsp.group)
end

TSetCachedBiosUpgradeModeRsp.from_obj = TSetCachedBiosUpgradeModeRsp_from_obj

TSetCachedBiosUpgradeModeRsp.proto_property = {'CompletionCode'}

TSetCachedBiosUpgradeModeRsp.default = {0}

TSetCachedBiosUpgradeModeRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetCachedBiosUpgradeModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetCachedBiosUpgradeModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCachedBiosUpgradeModeRsp.proto_property, errs, need_convert)
    return self
end

function TSetCachedBiosUpgradeModeRsp:unpack(_)
    return self.CompletionCode
end

SetCachedBiosUpgradeMode.SetCachedBiosUpgradeModeRsp = TSetCachedBiosUpgradeModeRsp

return SetCachedBiosUpgradeMode
