--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetBiosVersion = {}

---@class BiosIpmiCmds.SetBiosVersionReq
---@field ManufactureId integer
---@field Version string
local TSetBiosVersionReq = {}
TSetBiosVersionReq.__index = TSetBiosVersionReq
TSetBiosVersionReq.group = {}

local function TSetBiosVersionReq_from_obj(obj)
    return setmetatable(obj, TSetBiosVersionReq)
end

function TSetBiosVersionReq.new(ManufactureId, Version)
    return TSetBiosVersionReq_from_obj({ManufactureId = ManufactureId, Version = Version})
end
---@param obj BiosIpmiCmds.SetBiosVersionReq
function TSetBiosVersionReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Version = obj.Version
end

function TSetBiosVersionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBiosVersionReq.group)
end

TSetBiosVersionReq.from_obj = TSetBiosVersionReq_from_obj

TSetBiosVersionReq.proto_property = {'ManufactureId', 'Version'}

TSetBiosVersionReq.default = {0, ''}

TSetBiosVersionReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Version', is_array = false, struct = nil}
}

function TSetBiosVersionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Version', self.Version, 'string', false, errs, need_convert)

    TSetBiosVersionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBiosVersionReq.proto_property, errs, need_convert)
    return self
end

function TSetBiosVersionReq:unpack(_)
    return self.ManufactureId, self.Version
end

SetBiosVersion.SetBiosVersionReq = TSetBiosVersionReq

---@class BiosIpmiCmds.SetBiosVersionRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetBiosVersionRsp = {}
TSetBiosVersionRsp.__index = TSetBiosVersionRsp
TSetBiosVersionRsp.group = {}

local function TSetBiosVersionRsp_from_obj(obj)
    return setmetatable(obj, TSetBiosVersionRsp)
end

function TSetBiosVersionRsp.new(CompletionCode, ManufactureId)
    return TSetBiosVersionRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj BiosIpmiCmds.SetBiosVersionRsp
function TSetBiosVersionRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetBiosVersionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBiosVersionRsp.group)
end

TSetBiosVersionRsp.from_obj = TSetBiosVersionRsp_from_obj

TSetBiosVersionRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetBiosVersionRsp.default = {0, 0}

TSetBiosVersionRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetBiosVersionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetBiosVersionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBiosVersionRsp.proto_property, errs, need_convert)
    return self
end

function TSetBiosVersionRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetBiosVersion.SetBiosVersionRsp = TSetBiosVersionRsp

return SetBiosVersion
