--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetBiosConfiguration = {}

---@class BiosIpmiCmds.SetBiosConfigurationReq
---@field ManufactureId integer
---@field SystemId integer
---@field Reserved integer
---@field Info string
local TSetBiosConfigurationReq = {}
TSetBiosConfigurationReq.__index = TSetBiosConfigurationReq
TSetBiosConfigurationReq.group = {}

local function TSetBiosConfigurationReq_from_obj(obj)
    return setmetatable(obj, TSetBiosConfigurationReq)
end

function TSetBiosConfigurationReq.new(ManufactureId, SystemId, Reserved, Info)
    return TSetBiosConfigurationReq_from_obj({
        ManufactureId = ManufactureId,
        SystemId = SystemId,
        Reserved = Reserved,
        Info = Info
    })
end
---@param obj BiosIpmiCmds.SetBiosConfigurationReq
function TSetBiosConfigurationReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.SystemId = obj.SystemId
    self.Reserved = obj.Reserved
    self.Info = obj.Info
end

function TSetBiosConfigurationReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBiosConfigurationReq.group)
end

TSetBiosConfigurationReq.from_obj = TSetBiosConfigurationReq_from_obj

TSetBiosConfigurationReq.proto_property = {'ManufactureId', 'SystemId', 'Reserved', 'Info'}

TSetBiosConfigurationReq.default = {0, 0, 0, ''}

TSetBiosConfigurationReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'SystemId', is_array = false, struct = nil},
    {name = 'Reserved', is_array = false, struct = nil}, {name = 'Info', is_array = false, struct = nil}
}

function TSetBiosConfigurationReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Info', self.Info, 'string', false, errs, need_convert)

    TSetBiosConfigurationReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBiosConfigurationReq.proto_property, errs, need_convert)
    return self
end

function TSetBiosConfigurationReq:unpack(_)
    return self.ManufactureId, self.SystemId, self.Reserved, self.Info
end

SetBiosConfiguration.SetBiosConfigurationReq = TSetBiosConfigurationReq

---@class BiosIpmiCmds.SetBiosConfigurationRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetBiosConfigurationRsp = {}
TSetBiosConfigurationRsp.__index = TSetBiosConfigurationRsp
TSetBiosConfigurationRsp.group = {}

local function TSetBiosConfigurationRsp_from_obj(obj)
    return setmetatable(obj, TSetBiosConfigurationRsp)
end

function TSetBiosConfigurationRsp.new(CompletionCode, ManufactureId)
    return TSetBiosConfigurationRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj BiosIpmiCmds.SetBiosConfigurationRsp
function TSetBiosConfigurationRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetBiosConfigurationRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBiosConfigurationRsp.group)
end

TSetBiosConfigurationRsp.from_obj = TSetBiosConfigurationRsp_from_obj

TSetBiosConfigurationRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetBiosConfigurationRsp.default = {0, 0}

TSetBiosConfigurationRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetBiosConfigurationRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetBiosConfigurationRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBiosConfigurationRsp.proto_property, errs, need_convert)
    return self
end

function TSetBiosConfigurationRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetBiosConfiguration.SetBiosConfigurationRsp = TSetBiosConfigurationRsp

return SetBiosConfiguration
