--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetBaseOSBootEvent = {}

---@class BiosIpmiCmds.SetBaseOSBootEventReq
---@field ManuId integer
---@field EventDir integer
---@field DeviceStatus integer
---@field Datas string
local TSetBaseOSBootEventReq = {}
TSetBaseOSBootEventReq.__index = TSetBaseOSBootEventReq
TSetBaseOSBootEventReq.group = {}

local function TSetBaseOSBootEventReq_from_obj(obj)
    return setmetatable(obj, TSetBaseOSBootEventReq)
end

function TSetBaseOSBootEventReq.new(ManuId, EventDir, DeviceStatus, Datas)
    return TSetBaseOSBootEventReq_from_obj({
        ManuId = ManuId,
        EventDir = EventDir,
        DeviceStatus = DeviceStatus,
        Datas = Datas
    })
end
---@param obj BiosIpmiCmds.SetBaseOSBootEventReq
function TSetBaseOSBootEventReq:init_from_obj(obj)
    self.ManuId = obj.ManuId
    self.EventDir = obj.EventDir
    self.DeviceStatus = obj.DeviceStatus
    self.Datas = obj.Datas
end

function TSetBaseOSBootEventReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBaseOSBootEventReq.group)
end

TSetBaseOSBootEventReq.from_obj = TSetBaseOSBootEventReq_from_obj

TSetBaseOSBootEventReq.proto_property = {'ManuId', 'EventDir', 'DeviceStatus', 'Datas'}

TSetBaseOSBootEventReq.default = {0, 0, 0, ''}

TSetBaseOSBootEventReq.struct = {
    {name = 'ManuId', is_array = false, struct = nil}, {name = 'EventDir', is_array = false, struct = nil},
    {name = 'DeviceStatus', is_array = false, struct = nil}, {name = 'Datas', is_array = false, struct = nil}
}

function TSetBaseOSBootEventReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManuId', self.ManuId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EventDir', self.EventDir, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceStatus', self.DeviceStatus, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Datas', self.Datas, 'string', false, errs, need_convert)

    TSetBaseOSBootEventReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBaseOSBootEventReq.proto_property, errs, need_convert)
    return self
end

function TSetBaseOSBootEventReq:unpack(_)
    return self.ManuId, self.EventDir, self.DeviceStatus, self.Datas
end

SetBaseOSBootEvent.SetBaseOSBootEventReq = TSetBaseOSBootEventReq

---@class BiosIpmiCmds.SetBaseOSBootEventRsp
---@field CompletionCode integer
---@field ManuId integer
local TSetBaseOSBootEventRsp = {}
TSetBaseOSBootEventRsp.__index = TSetBaseOSBootEventRsp
TSetBaseOSBootEventRsp.group = {}

local function TSetBaseOSBootEventRsp_from_obj(obj)
    return setmetatable(obj, TSetBaseOSBootEventRsp)
end

function TSetBaseOSBootEventRsp.new(CompletionCode, ManuId)
    return TSetBaseOSBootEventRsp_from_obj({CompletionCode = CompletionCode, ManuId = ManuId})
end
---@param obj BiosIpmiCmds.SetBaseOSBootEventRsp
function TSetBaseOSBootEventRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManuId = obj.ManuId
end

function TSetBaseOSBootEventRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBaseOSBootEventRsp.group)
end

TSetBaseOSBootEventRsp.from_obj = TSetBaseOSBootEventRsp_from_obj

TSetBaseOSBootEventRsp.proto_property = {'CompletionCode', 'ManuId'}

TSetBaseOSBootEventRsp.default = {0, 0}

TSetBaseOSBootEventRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManuId', is_array = false, struct = nil}
}

function TSetBaseOSBootEventRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManuId', self.ManuId, 'uint32', false, errs, need_convert)

    TSetBaseOSBootEventRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBaseOSBootEventRsp.proto_property, errs, need_convert)
    return self
end

function TSetBaseOSBootEventRsp:unpack(_)
    return self.CompletionCode, self.ManuId
end

SetBaseOSBootEvent.SetBaseOSBootEventRsp = TSetBaseOSBootEventRsp

return SetBaseOSBootEvent
