--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSystemFirmwareVersion = {}

---@class BiosIpmiCmds.GetSystemFirmwareVersionReq
---@field GetOption integer
---@field SetSelector integer
---@field BlockSelector integer
local TGetSystemFirmwareVersionReq = {}
TGetSystemFirmwareVersionReq.__index = TGetSystemFirmwareVersionReq
TGetSystemFirmwareVersionReq.group = {}

local function TGetSystemFirmwareVersionReq_from_obj(obj)
    return setmetatable(obj, TGetSystemFirmwareVersionReq)
end

function TGetSystemFirmwareVersionReq.new(GetOption, SetSelector, BlockSelector)
    return TGetSystemFirmwareVersionReq_from_obj({
        GetOption = GetOption,
        SetSelector = SetSelector,
        BlockSelector = BlockSelector
    })
end
---@param obj BiosIpmiCmds.GetSystemFirmwareVersionReq
function TGetSystemFirmwareVersionReq:init_from_obj(obj)
    self.GetOption = obj.GetOption
    self.SetSelector = obj.SetSelector
    self.BlockSelector = obj.BlockSelector
end

function TGetSystemFirmwareVersionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs,
                                    TGetSystemFirmwareVersionReq.group)
end

TGetSystemFirmwareVersionReq.from_obj = TGetSystemFirmwareVersionReq_from_obj

TGetSystemFirmwareVersionReq.proto_property = {
    'GetOption', 'SetSelector', 'BlockSelector'
}

TGetSystemFirmwareVersionReq.default = {0, 0, 0}

TGetSystemFirmwareVersionReq.struct = {
    {name = 'GetOption', is_array = false, struct = nil},
    {name = 'SetSelector', is_array = false, struct = nil},
    {name = 'BlockSelector', is_array = false, struct = nil}
}

function TGetSystemFirmwareVersionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GetOption', self.GetOption, "uint8", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'SetSelector', self.SetSelector, "uint8", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'BlockSelector', self.BlockSelector, "uint8",
                      false, errs, need_convert)

    TGetSystemFirmwareVersionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self,
                                 TGetSystemFirmwareVersionReq.proto_property,
                                 errs, need_convert)
    return self
end

function TGetSystemFirmwareVersionReq:unpack(_)
    return self.GetOption, self.SetSelector, self.BlockSelector
end

GetSystemFirmwareVersion.GetSystemFirmwareVersionReq =
    TGetSystemFirmwareVersionReq

---@class BiosIpmiCmds.GetSystemFirmwareVersionRsp
---@field CompletionCode integer
---@field ParameterRevision integer
---@field Info string
local TGetSystemFirmwareVersionRsp = {}
TGetSystemFirmwareVersionRsp.__index = TGetSystemFirmwareVersionRsp
TGetSystemFirmwareVersionRsp.group = {}

local function TGetSystemFirmwareVersionRsp_from_obj(obj)
    return setmetatable(obj, TGetSystemFirmwareVersionRsp)
end

function TGetSystemFirmwareVersionRsp.new(CompletionCode, ParameterRevision,
                                          Info)
    return TGetSystemFirmwareVersionRsp_from_obj({
        CompletionCode = CompletionCode,
        ParameterRevision = ParameterRevision,
        Info = Info
    })
end
---@param obj BiosIpmiCmds.GetSystemFirmwareVersionRsp
function TGetSystemFirmwareVersionRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ParameterRevision = obj.ParameterRevision
    self.Info = obj.Info
end

function TGetSystemFirmwareVersionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs,
                                    TGetSystemFirmwareVersionRsp.group)
end

TGetSystemFirmwareVersionRsp.from_obj = TGetSystemFirmwareVersionRsp_from_obj

TGetSystemFirmwareVersionRsp.proto_property = {
    'CompletionCode', 'ParameterRevision', 'Info'
}

TGetSystemFirmwareVersionRsp.default = {0, 0, ''}

TGetSystemFirmwareVersionRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'ParameterRevision', is_array = false, struct = nil},
    {name = 'Info', is_array = false, struct = nil}
}

function TGetSystemFirmwareVersionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'ParameterRevision', self.ParameterRevision,
                      "uint8", false, errs, need_convert)
    validate.Optional(prefix .. 'Info', self.Info, "string", false, errs,
                      need_convert)

    TGetSystemFirmwareVersionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self,
                                 TGetSystemFirmwareVersionRsp.proto_property,
                                 errs, need_convert)
    return self
end

function TGetSystemFirmwareVersionRsp:unpack(_)
    return self.CompletionCode, self.ParameterRevision, self.Info
end

GetSystemFirmwareVersion.GetSystemFirmwareVersionRsp =
    TGetSystemFirmwareVersionRsp

return GetSystemFirmwareVersion
