--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetBootOptionPowerOnDelay0 = {}

---@class BiosIpmiCmds.GetBootOptionPowerOnDelay0Req
---@field OtherSelector string
local TGetBootOptionPowerOnDelay0Req = {}
TGetBootOptionPowerOnDelay0Req.__index = TGetBootOptionPowerOnDelay0Req
TGetBootOptionPowerOnDelay0Req.group = {}

local function TGetBootOptionPowerOnDelay0Req_from_obj(obj)
    return setmetatable(obj, TGetBootOptionPowerOnDelay0Req)
end

function TGetBootOptionPowerOnDelay0Req.new(OtherSelector)
    return TGetBootOptionPowerOnDelay0Req_from_obj({OtherSelector = OtherSelector})
end
---@param obj BiosIpmiCmds.GetBootOptionPowerOnDelay0Req
function TGetBootOptionPowerOnDelay0Req:init_from_obj(obj)
    self.OtherSelector = obj.OtherSelector
end

function TGetBootOptionPowerOnDelay0Req:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBootOptionPowerOnDelay0Req.group)
end

TGetBootOptionPowerOnDelay0Req.from_obj = TGetBootOptionPowerOnDelay0Req_from_obj

TGetBootOptionPowerOnDelay0Req.proto_property = {'OtherSelector'}

TGetBootOptionPowerOnDelay0Req.default = {''}

TGetBootOptionPowerOnDelay0Req.struct = {{name = 'OtherSelector', is_array = false, struct = nil}}

function TGetBootOptionPowerOnDelay0Req:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OtherSelector', self.OtherSelector, 'string', false, errs, need_convert)

    TGetBootOptionPowerOnDelay0Req:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBootOptionPowerOnDelay0Req.proto_property, errs, need_convert)
    return self
end

function TGetBootOptionPowerOnDelay0Req:unpack(_)
    return self.OtherSelector
end

GetBootOptionPowerOnDelay0.GetBootOptionPowerOnDelay0Req = TGetBootOptionPowerOnDelay0Req

---@class BiosIpmiCmds.GetBootOptionPowerOnDelay0Rsp
---@field CompletionCode integer
---@field ParameterVersion integer
---@field BootOptionSelector integer
---@field OtherData string
local TGetBootOptionPowerOnDelay0Rsp = {}
TGetBootOptionPowerOnDelay0Rsp.__index = TGetBootOptionPowerOnDelay0Rsp
TGetBootOptionPowerOnDelay0Rsp.group = {}

local function TGetBootOptionPowerOnDelay0Rsp_from_obj(obj)
    return setmetatable(obj, TGetBootOptionPowerOnDelay0Rsp)
end

function TGetBootOptionPowerOnDelay0Rsp.new(CompletionCode, ParameterVersion, BootOptionSelector, OtherData)
    return TGetBootOptionPowerOnDelay0Rsp_from_obj({
        CompletionCode = CompletionCode,
        ParameterVersion = ParameterVersion,
        BootOptionSelector = BootOptionSelector,
        OtherData = OtherData
    })
end
---@param obj BiosIpmiCmds.GetBootOptionPowerOnDelay0Rsp
function TGetBootOptionPowerOnDelay0Rsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ParameterVersion = obj.ParameterVersion
    self.BootOptionSelector = obj.BootOptionSelector
    self.OtherData = obj.OtherData
end

function TGetBootOptionPowerOnDelay0Rsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBootOptionPowerOnDelay0Rsp.group)
end

TGetBootOptionPowerOnDelay0Rsp.from_obj = TGetBootOptionPowerOnDelay0Rsp_from_obj

TGetBootOptionPowerOnDelay0Rsp.proto_property = {
    'CompletionCode', 'ParameterVersion', 'BootOptionSelector', 'OtherData'
}

TGetBootOptionPowerOnDelay0Rsp.default = {0, 0, 0, ''}

TGetBootOptionPowerOnDelay0Rsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'ParameterVersion', is_array = false, struct = nil},
    {name = 'BootOptionSelector', is_array = false, struct = nil}, {name = 'OtherData', is_array = false, struct = nil}
}

function TGetBootOptionPowerOnDelay0Rsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ParameterVersion', self.ParameterVersion, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BootOptionSelector', self.BootOptionSelector, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'OtherData', self.OtherData, 'string', false, errs, need_convert)

    TGetBootOptionPowerOnDelay0Rsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBootOptionPowerOnDelay0Rsp.proto_property, errs, need_convert)
    return self
end

function TGetBootOptionPowerOnDelay0Rsp:unpack(_)
    return self.CompletionCode, self.ParameterVersion, self.BootOptionSelector, self.OtherData
end

GetBootOptionPowerOnDelay0.GetBootOptionPowerOnDelay0Rsp = TGetBootOptionPowerOnDelay0Rsp

return GetBootOptionPowerOnDelay0
