--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetBiosConfiguration = {}

---@class BiosIpmiCmds.GetBiosConfigurationReq
---@field ManufactureId integer
---@field SystemId integer
---@field Type integer
---@field Reserved integer
---@field Info string
local TGetBiosConfigurationReq = {}
TGetBiosConfigurationReq.__index = TGetBiosConfigurationReq
TGetBiosConfigurationReq.group = {}

local function TGetBiosConfigurationReq_from_obj(obj)
    return setmetatable(obj, TGetBiosConfigurationReq)
end

function TGetBiosConfigurationReq.new(ManufactureId, SystemId, Type, Reserved, Info)
    return TGetBiosConfigurationReq_from_obj({
        ManufactureId = ManufactureId,
        SystemId = SystemId,
        Type = Type,
        Reserved = Reserved,
        Info = Info
    })
end
---@param obj BiosIpmiCmds.GetBiosConfigurationReq
function TGetBiosConfigurationReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.SystemId = obj.SystemId
    self.Type = obj.Type
    self.Reserved = obj.Reserved
    self.Info = obj.Info
end

function TGetBiosConfigurationReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBiosConfigurationReq.group)
end

TGetBiosConfigurationReq.from_obj = TGetBiosConfigurationReq_from_obj

TGetBiosConfigurationReq.proto_property = {'ManufactureId', 'SystemId', 'Type', 'Reserved', 'Info'}

TGetBiosConfigurationReq.default = {0, 0, 0, 0, ''}

TGetBiosConfigurationReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'SystemId', is_array = false, struct = nil},
    {name = 'Type', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'Info', is_array = false, struct = nil}
}

function TGetBiosConfigurationReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Type', self.Type, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Info', self.Info, 'string', false, errs, need_convert)

    TGetBiosConfigurationReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBiosConfigurationReq.proto_property, errs, need_convert)
    return self
end

function TGetBiosConfigurationReq:unpack(_)
    return self.ManufactureId, self.SystemId, self.Type, self.Reserved, self.Info
end

GetBiosConfiguration.GetBiosConfigurationReq = TGetBiosConfigurationReq

---@class BiosIpmiCmds.GetBiosConfigurationRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserved integer
---@field Info string
local TGetBiosConfigurationRsp = {}
TGetBiosConfigurationRsp.__index = TGetBiosConfigurationRsp
TGetBiosConfigurationRsp.group = {}

local function TGetBiosConfigurationRsp_from_obj(obj)
    return setmetatable(obj, TGetBiosConfigurationRsp)
end

function TGetBiosConfigurationRsp.new(CompletionCode, ManufactureId, Reserved, Info)
    return TGetBiosConfigurationRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserved = Reserved,
        Info = Info
    })
end
---@param obj BiosIpmiCmds.GetBiosConfigurationRsp
function TGetBiosConfigurationRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserved = obj.Reserved
    self.Info = obj.Info
end

function TGetBiosConfigurationRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBiosConfigurationRsp.group)
end

TGetBiosConfigurationRsp.from_obj = TGetBiosConfigurationRsp_from_obj

TGetBiosConfigurationRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserved', 'Info'}

TGetBiosConfigurationRsp.default = {0, 0, 0, ''}

TGetBiosConfigurationRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserved', is_array = false, struct = nil}, {name = 'Info', is_array = false, struct = nil}
}

function TGetBiosConfigurationRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Info', self.Info, 'string', false, errs, need_convert)

    TGetBiosConfigurationRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBiosConfigurationRsp.proto_property, errs, need_convert)
    return self
end

function TGetBiosConfigurationRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserved, self.Info
end

GetBiosConfiguration.GetBiosConfigurationRsp = TGetBiosConfigurationRsp

return GetBiosConfiguration
