--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetAllowedPackageType = {}

---@class BiosIpmiCmds.GetAllowedPackageTypeReq
local TGetAllowedPackageTypeReq = {}
TGetAllowedPackageTypeReq.__index = TGetAllowedPackageTypeReq
TGetAllowedPackageTypeReq.group = {}

local function TGetAllowedPackageTypeReq_from_obj(obj)
    return setmetatable(obj, TGetAllowedPackageTypeReq)
end

function TGetAllowedPackageTypeReq.new()
    return TGetAllowedPackageTypeReq_from_obj({})
end
---@param obj BiosIpmiCmds.GetAllowedPackageTypeReq
function TGetAllowedPackageTypeReq:init_from_obj(obj)

end

function TGetAllowedPackageTypeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetAllowedPackageTypeReq.group)
end

TGetAllowedPackageTypeReq.from_obj = TGetAllowedPackageTypeReq_from_obj

TGetAllowedPackageTypeReq.proto_property = {}

TGetAllowedPackageTypeReq.default = {}

TGetAllowedPackageTypeReq.struct = {}

function TGetAllowedPackageTypeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetAllowedPackageTypeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetAllowedPackageTypeReq.proto_property, errs, need_convert)
    return self
end

function TGetAllowedPackageTypeReq:unpack(_)
end

GetAllowedPackageType.GetAllowedPackageTypeReq = TGetAllowedPackageTypeReq

---@class BiosIpmiCmds.GetAllowedPackageTypeRsp
---@field CompletionCode integer
---@field PackageStatus integer
---@field AllowedPackageType integer
local TGetAllowedPackageTypeRsp = {}
TGetAllowedPackageTypeRsp.__index = TGetAllowedPackageTypeRsp
TGetAllowedPackageTypeRsp.group = {}

local function TGetAllowedPackageTypeRsp_from_obj(obj)
    return setmetatable(obj, TGetAllowedPackageTypeRsp)
end

function TGetAllowedPackageTypeRsp.new(CompletionCode, PackageStatus, AllowedPackageType)
    return TGetAllowedPackageTypeRsp_from_obj({
        CompletionCode = CompletionCode,
        PackageStatus = PackageStatus,
        AllowedPackageType = AllowedPackageType
    })
end
---@param obj BiosIpmiCmds.GetAllowedPackageTypeRsp
function TGetAllowedPackageTypeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.PackageStatus = obj.PackageStatus
    self.AllowedPackageType = obj.AllowedPackageType
end

function TGetAllowedPackageTypeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetAllowedPackageTypeRsp.group)
end

TGetAllowedPackageTypeRsp.from_obj = TGetAllowedPackageTypeRsp_from_obj

TGetAllowedPackageTypeRsp.proto_property = {'CompletionCode', 'PackageStatus', 'AllowedPackageType'}

TGetAllowedPackageTypeRsp.default = {0, 0, 0}

TGetAllowedPackageTypeRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'PackageStatus', is_array = false, struct = nil},
    {name = 'AllowedPackageType', is_array = false, struct = nil}
}

function TGetAllowedPackageTypeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PackageStatus', self.PackageStatus, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AllowedPackageType', self.AllowedPackageType, 'uint8', false, errs, need_convert)

    TGetAllowedPackageTypeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetAllowedPackageTypeRsp.proto_property, errs, need_convert)
    return self
end

function TGetAllowedPackageTypeRsp:unpack(_)
    return self.CompletionCode, self.PackageStatus, self.AllowedPackageType
end

GetAllowedPackageType.GetAllowedPackageTypeRsp = TGetAllowedPackageTypeRsp

return GetAllowedPackageType
