/*
 * Copyright (c) 2025 Huawei Technologies Co., Ltd.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *        http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
#ifndef __PUBLIC_H__
#define __PUBLIC_H__

#include <openssl/err.h>

#define log_debug(format, arg...)  \
    do {                           \
        if (verbose != 0) {         \
            printf(format, ##arg); \
            printf("\n");          \
        }                          \
    } while (0)

#define log_info(format, arg...) \
    do {                         \
        printf("\e[32m");        \
        printf(format, ##arg);   \
        printf("\e[m\n");        \
    } while (0)

#define log_error(format, arg...)       \
    do {                                \
        fprintf(stderr, "\e[31m");      \
        fprintf(stderr, format, ##arg); \
        fprintf(stderr, "\e[m\n");      \
    } while (0)

#define log_debug_ident(n, format, arg...) \
    do {                                   \
        if (verbose != 0) {                 \
            printf("%*c", n, ' ');         \
        }                                  \
        log_debug(format, ##arg);          \
    } while (0)
#define log_info_indent(n, format, arg...) \
    do {                                   \
        printf("%*c", n, ' ');             \
        log_debug(format, ##arg);          \
    } while (0)
#define log_deror_indent(n, format, arg...) \
    do {                                    \
        printf("%*c", n, ' ');              \
        log_error(format, ##arg);           \
    } while (0)

#define ERR_PRINT_BUF_SIZE 4096

static inline void print_ssl_error(void)
{
    unsigned long ssl_err   = ERR_get_error();
    char          buf[4096] = {0};
    ERR_error_string(ssl_err, buf);
    log_error("%s", buf);
}

#endif