# coding: utf-8
# Copyright (c) 2025 Huawei Technologies Co., Ltd.
# openUBMC is licensed under Mulan PSL v2.
# You can use this software according to the terms and conditions of the Mulan PSL v2.
# You may obtain a copy of Mulan PSL v2 at:
#         http://license.coscl.org.cn/MulanPSL2
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
# EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
# MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
# See the Mulan PSL v2 for more details.
import os
import unittest
import tempfile

from git.repo import Repo
from bmcgo.bmcgo_config import BmcgoConfig
from bmcgo.utils.tools import Tools
from bmcgo.functional.conan_index_build import BmcgoCommand as BuildIndexCommand

tools = Tools()


class TestConanIndexBuild(unittest.TestCase):
    @classmethod
    def setUpClass(cls):
        # 创建临时目录
        cls.tmpdir = tempfile.TemporaryDirectory()
        os.chdir(cls.tmpdir.name)
        return super().setUpClass()

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def test_bmcgo_config(self):
        # 用例标题：测试conan_index仓环境探测能力
        bconfig = BmcgoConfig()
        self.assertIsNone(bconfig.manifest)
        self.assertIsNone(bconfig.component)
