-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MPasswordPolicyDB = {}

---@class MPasswordPolicyDB.MaxPasswordLength
---@field MaxPasswordLength integer
local TMaxPasswordLength = {}
TMaxPasswordLength.__index = TMaxPasswordLength
TMaxPasswordLength.group = {}

local function TMaxPasswordLength_from_obj(obj)
    return setmetatable(obj, TMaxPasswordLength)
end

function TMaxPasswordLength.new(MaxPasswordLength)
    return TMaxPasswordLength_from_obj({MaxPasswordLength = MaxPasswordLength})
end
---@param obj MPasswordPolicyDB.MaxPasswordLength
function TMaxPasswordLength:init_from_obj(obj)
    self.MaxPasswordLength = obj.MaxPasswordLength
end

function TMaxPasswordLength:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxPasswordLength.group)
end

TMaxPasswordLength.from_obj = TMaxPasswordLength_from_obj

TMaxPasswordLength.proto_property = {'MaxPasswordLength'}

TMaxPasswordLength.default = {0}

TMaxPasswordLength.struct = {{name = 'MaxPasswordLength', is_array = false, struct = nil}}

function TMaxPasswordLength:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxPasswordLength', self.MaxPasswordLength, 'uint32', false, errs, need_convert)

    TMaxPasswordLength:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxPasswordLength.proto_property, errs, need_convert)
    return self
end

function TMaxPasswordLength:unpack(_)
    return self.MaxPasswordLength
end

MPasswordPolicyDB.MaxPasswordLength = TMaxPasswordLength

---@class MPasswordPolicyDB.Pattern
---@field Pattern string
local TPattern = {}
TPattern.__index = TPattern
TPattern.group = {}

local function TPattern_from_obj(obj)
    return setmetatable(obj, TPattern)
end

function TPattern.new(Pattern)
    return TPattern_from_obj({Pattern = Pattern or [=[]=]})
end
---@param obj MPasswordPolicyDB.Pattern
function TPattern:init_from_obj(obj)
    self.Pattern = obj.Pattern or [=[]=]
end

function TPattern:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPattern.group)
end

TPattern.from_obj = TPattern_from_obj

TPattern.proto_property = {'Pattern'}

TPattern.default = {''}

TPattern.struct = {{name = 'Pattern', is_array = false, struct = nil}}

function TPattern:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Pattern', self.Pattern, 'string', false, errs, need_convert)

    TPattern:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPattern.proto_property, errs, need_convert)
    return self
end

function TPattern:unpack(_)
    return self.Pattern
end

MPasswordPolicyDB.Pattern = TPattern

---@class MPasswordPolicyDB.Policy
---@field Policy integer
local TPolicy = {}
TPolicy.__index = TPolicy
TPolicy.group = {}

local function TPolicy_from_obj(obj)
    return setmetatable(obj, TPolicy)
end

function TPolicy.new(Policy)
    return TPolicy_from_obj({Policy = Policy or 1})
end
---@param obj MPasswordPolicyDB.Policy
function TPolicy:init_from_obj(obj)
    self.Policy = obj.Policy or 1
end

function TPolicy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPolicy.group)
end

TPolicy.from_obj = TPolicy_from_obj

TPolicy.proto_property = {'Policy'}

TPolicy.default = {0}

TPolicy.struct = {{name = 'Policy', is_array = false, struct = nil}}

function TPolicy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Policy', self.Policy, 'uint8', false, errs, need_convert)

    TPolicy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPolicy.proto_property, errs, need_convert)
    return self
end

function TPolicy:unpack(_)
    return self.Policy
end

MPasswordPolicyDB.Policy = TPolicy

---@class MPasswordPolicyDB.AccountTypeName
---@field AccountTypeName string
local TAccountTypeName = {}
TAccountTypeName.__index = TAccountTypeName
TAccountTypeName.group = {}

local function TAccountTypeName_from_obj(obj)
    return setmetatable(obj, TAccountTypeName)
end

function TAccountTypeName.new(AccountTypeName)
    return TAccountTypeName_from_obj({AccountTypeName = AccountTypeName})
end
---@param obj MPasswordPolicyDB.AccountTypeName
function TAccountTypeName:init_from_obj(obj)
    self.AccountTypeName = obj.AccountTypeName
end

function TAccountTypeName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAccountTypeName.group)
end

TAccountTypeName.from_obj = TAccountTypeName_from_obj

TAccountTypeName.proto_property = {'AccountTypeName'}

TAccountTypeName.default = {''}

TAccountTypeName.struct = {{name = 'AccountTypeName', is_array = false, struct = nil}}

function TAccountTypeName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AccountTypeName', self.AccountTypeName, 'string', false, errs, need_convert)

    TAccountTypeName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAccountTypeName.proto_property, errs, need_convert)
    return self
end

function TAccountTypeName:unpack(_)
    return self.AccountTypeName
end

MPasswordPolicyDB.AccountTypeName = TAccountTypeName

---@class MPasswordPolicyDB.AccountType
---@field AccountType integer
local TAccountType = {}
TAccountType.__index = TAccountType
TAccountType.group = {}

local function TAccountType_from_obj(obj)
    return setmetatable(obj, TAccountType)
end

function TAccountType.new(AccountType)
    return TAccountType_from_obj({AccountType = AccountType})
end
---@param obj MPasswordPolicyDB.AccountType
function TAccountType:init_from_obj(obj)
    self.AccountType = obj.AccountType
end

function TAccountType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAccountType.group)
end

TAccountType.from_obj = TAccountType_from_obj

TAccountType.proto_property = {'AccountType'}

TAccountType.default = {0}

TAccountType.struct = {{name = 'AccountType', is_array = false, struct = nil}}

function TAccountType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'AccountType', self.AccountType, 'uint8', false, errs, need_convert)

    TAccountType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAccountType.proto_property, errs, need_convert)
    return self
end

function TAccountType:unpack(_)
    return self.AccountType
end

MPasswordPolicyDB.AccountType = TAccountType

return MPasswordPolicyDB
