-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local LocalAccountAuthN = {}

---@class LocalAccountAuthN.GenRmcp15CodeRsp
---@field AuthCode integer[]
local TGenRmcp15CodeRsp = {}
TGenRmcp15CodeRsp.__index = TGenRmcp15CodeRsp
TGenRmcp15CodeRsp.group = {}

local function TGenRmcp15CodeRsp_from_obj(obj)
    return setmetatable(obj, TGenRmcp15CodeRsp)
end

function TGenRmcp15CodeRsp.new(AuthCode)
    return TGenRmcp15CodeRsp_from_obj({AuthCode = AuthCode})
end
---@param obj LocalAccountAuthN.GenRmcp15CodeRsp
function TGenRmcp15CodeRsp:init_from_obj(obj)
    self.AuthCode = obj.AuthCode
end

function TGenRmcp15CodeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGenRmcp15CodeRsp.group)
end

TGenRmcp15CodeRsp.from_obj = TGenRmcp15CodeRsp_from_obj

TGenRmcp15CodeRsp.proto_property = {'AuthCode'}

TGenRmcp15CodeRsp.default = {{}}

TGenRmcp15CodeRsp.struct = {{name = 'AuthCode', is_array = true, struct = nil}}

function TGenRmcp15CodeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'AuthCode', self.AuthCode, 'uint8', false, errs, need_convert)

    TGenRmcp15CodeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGenRmcp15CodeRsp.proto_property, errs, need_convert)
    return self
end

function TGenRmcp15CodeRsp:unpack(_)
    return self.AuthCode
end

LocalAccountAuthN.GenRmcp15CodeRsp = TGenRmcp15CodeRsp

---@class LocalAccountAuthN.GenRmcp15CodeReq
---@field AuthAlgo integer
---@field PayLoad integer[]
---@field AccountId integer
---@field SessionId integer
---@field SessionSequence integer
local TGenRmcp15CodeReq = {}
TGenRmcp15CodeReq.__index = TGenRmcp15CodeReq
TGenRmcp15CodeReq.group = {}

local function TGenRmcp15CodeReq_from_obj(obj)
    return setmetatable(obj, TGenRmcp15CodeReq)
end

function TGenRmcp15CodeReq.new(AuthAlgo, PayLoad, AccountId, SessionId, SessionSequence)
    return TGenRmcp15CodeReq_from_obj({
        AuthAlgo = AuthAlgo,
        PayLoad = PayLoad,
        AccountId = AccountId,
        SessionId = SessionId,
        SessionSequence = SessionSequence
    })
end
---@param obj LocalAccountAuthN.GenRmcp15CodeReq
function TGenRmcp15CodeReq:init_from_obj(obj)
    self.AuthAlgo = obj.AuthAlgo
    self.PayLoad = obj.PayLoad
    self.AccountId = obj.AccountId
    self.SessionId = obj.SessionId
    self.SessionSequence = obj.SessionSequence
end

function TGenRmcp15CodeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGenRmcp15CodeReq.group)
end

TGenRmcp15CodeReq.from_obj = TGenRmcp15CodeReq_from_obj

TGenRmcp15CodeReq.proto_property = {'AuthAlgo', 'PayLoad', 'AccountId', 'SessionId', 'SessionSequence'}

TGenRmcp15CodeReq.default = {0, {}, 0, 0, 0}

TGenRmcp15CodeReq.struct = {
    {name = 'AuthAlgo', is_array = false, struct = nil}, {name = 'PayLoad', is_array = true, struct = nil},
    {name = 'AccountId', is_array = false, struct = nil}, {name = 'SessionId', is_array = false, struct = nil},
    {name = 'SessionSequence', is_array = false, struct = nil}
}

function TGenRmcp15CodeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AuthAlgo', self.AuthAlgo, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'PayLoad', self.PayLoad, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AccountId', self.AccountId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SessionId', self.SessionId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'SessionSequence', self.SessionSequence, 'uint32', false, errs, need_convert)

    if self.PayLoad ~= nil then
        validate.lens(prefix .. 'PayLoad', self.PayLoad, 1, 255, errs, need_convert)
    end

    TGenRmcp15CodeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGenRmcp15CodeReq.proto_property, errs, need_convert)
    return self
end

function TGenRmcp15CodeReq:unpack(_)
    return self.AuthAlgo, self.PayLoad, self.AccountId, self.SessionId, self.SessionSequence
end

LocalAccountAuthN.GenRmcp15CodeReq = TGenRmcp15CodeReq

---@class LocalAccountAuthN.GenRmcp20CodeRsp
---@field Rap2AuthCode integer[]
---@field Sik integer[]
---@field Rap3AuthCode integer[]
local TGenRmcp20CodeRsp = {}
TGenRmcp20CodeRsp.__index = TGenRmcp20CodeRsp
TGenRmcp20CodeRsp.group = {}

local function TGenRmcp20CodeRsp_from_obj(obj)
    return setmetatable(obj, TGenRmcp20CodeRsp)
end

function TGenRmcp20CodeRsp.new(Rap2AuthCode, Sik, Rap3AuthCode)
    return TGenRmcp20CodeRsp_from_obj({Rap2AuthCode = Rap2AuthCode, Sik = Sik, Rap3AuthCode = Rap3AuthCode})
end
---@param obj LocalAccountAuthN.GenRmcp20CodeRsp
function TGenRmcp20CodeRsp:init_from_obj(obj)
    self.Rap2AuthCode = obj.Rap2AuthCode
    self.Sik = obj.Sik
    self.Rap3AuthCode = obj.Rap3AuthCode
end

function TGenRmcp20CodeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGenRmcp20CodeRsp.group)
end

TGenRmcp20CodeRsp.from_obj = TGenRmcp20CodeRsp_from_obj

TGenRmcp20CodeRsp.proto_property = {'Rap2AuthCode', 'Sik', 'Rap3AuthCode'}

TGenRmcp20CodeRsp.default = {{}, {}, {}}

TGenRmcp20CodeRsp.struct = {
    {name = 'Rap2AuthCode', is_array = true, struct = nil}, {name = 'Sik', is_array = true, struct = nil},
    {name = 'Rap3AuthCode', is_array = true, struct = nil}
}

function TGenRmcp20CodeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'Rap2AuthCode', self.Rap2AuthCode, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Sik', self.Sik, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Rap3AuthCode', self.Rap3AuthCode, 'uint8', false, errs, need_convert)

    TGenRmcp20CodeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGenRmcp20CodeRsp.proto_property, errs, need_convert)
    return self
end

function TGenRmcp20CodeRsp:unpack(_)
    return self.Rap2AuthCode, self.Sik, self.Rap3AuthCode
end

LocalAccountAuthN.GenRmcp20CodeRsp = TGenRmcp20CodeRsp

---@class LocalAccountAuthN.GenRmcp20CodeReq
---@field AuthAlgo integer
---@field UserName string
---@field ConsoleSid integer
---@field ManagedSid integer
---@field ConsoleRandom integer[]
---@field ManagedRandom integer[]
---@field ManagedGuid integer[]
---@field Role integer
---@field Ip string
local TGenRmcp20CodeReq = {}
TGenRmcp20CodeReq.__index = TGenRmcp20CodeReq
TGenRmcp20CodeReq.group = {}

local function TGenRmcp20CodeReq_from_obj(obj)
    return setmetatable(obj, TGenRmcp20CodeReq)
end

function TGenRmcp20CodeReq.new(AuthAlgo, UserName, ConsoleSid, ManagedSid, ConsoleRandom, ManagedRandom, ManagedGuid,
    Role, Ip)
    return TGenRmcp20CodeReq_from_obj({
        AuthAlgo = AuthAlgo,
        UserName = UserName,
        ConsoleSid = ConsoleSid,
        ManagedSid = ManagedSid,
        ConsoleRandom = ConsoleRandom,
        ManagedRandom = ManagedRandom,
        ManagedGuid = ManagedGuid,
        Role = Role,
        Ip = Ip
    })
end
---@param obj LocalAccountAuthN.GenRmcp20CodeReq
function TGenRmcp20CodeReq:init_from_obj(obj)
    self.AuthAlgo = obj.AuthAlgo
    self.UserName = obj.UserName
    self.ConsoleSid = obj.ConsoleSid
    self.ManagedSid = obj.ManagedSid
    self.ConsoleRandom = obj.ConsoleRandom
    self.ManagedRandom = obj.ManagedRandom
    self.ManagedGuid = obj.ManagedGuid
    self.Role = obj.Role
    self.Ip = obj.Ip
end

function TGenRmcp20CodeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGenRmcp20CodeReq.group)
end

TGenRmcp20CodeReq.from_obj = TGenRmcp20CodeReq_from_obj

TGenRmcp20CodeReq.proto_property = {
    'AuthAlgo', 'UserName', 'ConsoleSid', 'ManagedSid', 'ConsoleRandom', 'ManagedRandom', 'ManagedGuid', 'Role', 'Ip'
}

TGenRmcp20CodeReq.default = {0, '', 0, 0, {}, {}, {}, 0, ''}

TGenRmcp20CodeReq.struct = {
    {name = 'AuthAlgo', is_array = false, struct = nil}, {name = 'UserName', is_array = false, struct = nil},
    {name = 'ConsoleSid', is_array = false, struct = nil}, {name = 'ManagedSid', is_array = false, struct = nil},
    {name = 'ConsoleRandom', is_array = true, struct = nil}, {name = 'ManagedRandom', is_array = true, struct = nil},
    {name = 'ManagedGuid', is_array = true, struct = nil}, {name = 'Role', is_array = false, struct = nil},
    {name = 'Ip', is_array = false, struct = nil}
}

function TGenRmcp20CodeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AuthAlgo', self.AuthAlgo, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UserName', self.UserName, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'ConsoleSid', self.ConsoleSid, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'ManagedSid', self.ManagedSid, 'uint32', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'ConsoleRandom', self.ConsoleRandom, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'ManagedRandom', self.ManagedRandom, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'ManagedGuid', self.ManagedGuid, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Role', self.Role, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Ip', self.Ip, 'string', false, errs, need_convert)

    if self.UserName ~= nil then
        validate.lens(prefix .. 'UserName', self.UserName, 1, 32, errs, need_convert)
    end
    if self.ConsoleRandom ~= nil then
        validate.lens(prefix .. 'ConsoleRandom', self.ConsoleRandom, 16, 16, errs, need_convert)
    end
    if self.ManagedRandom ~= nil then
        validate.lens(prefix .. 'ManagedRandom', self.ManagedRandom, 16, 16, errs, need_convert)
    end
    if self.ManagedGuid ~= nil then
        validate.lens(prefix .. 'ManagedGuid', self.ManagedGuid, 16, 16, errs, need_convert)
    end

    TGenRmcp20CodeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGenRmcp20CodeReq.proto_property, errs, need_convert)
    return self
end

function TGenRmcp20CodeReq:unpack(_)
    return self.AuthAlgo, self.UserName, self.ConsoleSid, self.ManagedSid, self.ConsoleRandom, self.ManagedRandom,
        self.ManagedGuid, self.Role, self.Ip
end

LocalAccountAuthN.GenRmcp20CodeReq = TGenRmcp20CodeReq

---@class LocalAccountAuthN.VncAuthenticateReq
---@field CipherText string
---@field AuthChallenge string
local TVncAuthenticateReq = {}
TVncAuthenticateReq.__index = TVncAuthenticateReq
TVncAuthenticateReq.group = {}

local function TVncAuthenticateReq_from_obj(obj)
    return setmetatable(obj, TVncAuthenticateReq)
end

function TVncAuthenticateReq.new(CipherText, AuthChallenge)
    return TVncAuthenticateReq_from_obj({CipherText = CipherText, AuthChallenge = AuthChallenge})
end
---@param obj LocalAccountAuthN.VncAuthenticateReq
function TVncAuthenticateReq:init_from_obj(obj)
    self.CipherText = obj.CipherText
    self.AuthChallenge = obj.AuthChallenge
end

function TVncAuthenticateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVncAuthenticateReq.group)
end

TVncAuthenticateReq.from_obj = TVncAuthenticateReq_from_obj

TVncAuthenticateReq.proto_property = {'CipherText', 'AuthChallenge'}

TVncAuthenticateReq.default = {'', ''}

TVncAuthenticateReq.struct = {
    {name = 'CipherText', is_array = false, struct = nil}, {name = 'AuthChallenge', is_array = false, struct = nil}
}

function TVncAuthenticateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CipherText', self.CipherText, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'AuthChallenge', self.AuthChallenge, 'string', false, errs, need_convert)

    TVncAuthenticateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVncAuthenticateReq.proto_property, errs, need_convert)
    return self
end

function TVncAuthenticateReq:unpack(_)
    return self.CipherText, self.AuthChallenge
end

LocalAccountAuthN.VncAuthenticateReq = TVncAuthenticateReq

---@class LocalAccountAuthN.AccountData
---@field key string
---@field value string
local TAccountData = {}
TAccountData.__index = TAccountData
TAccountData.group = {}

local function TAccountData_from_obj(obj)
    return setmetatable(obj, TAccountData)
end

function TAccountData.new(dict)
    return TAccountData_from_obj(dict)
end

---@param obj LocalAccountAuthN.AccountData
function TAccountData:init_from_obj(obj)
    self = obj
end

function TAccountData:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAccountData.group)
end

TAccountData.from_obj = TAccountData_from_obj

TAccountData.proto_property = {}

TAccountData.default = {}

TAccountData.struct = {}

function TAccountData:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TAccountData:remove_error_props(errs, self)
    return self
end

function TAccountData:unpack(_)
    return self
end

LocalAccountAuthN.AccountData = TAccountData

---@class LocalAccountAuthN.VncAuthenticateRsp
---@field AccountData LocalAccountAuthN.AccountData
local TVncAuthenticateRsp = {}
TVncAuthenticateRsp.__index = TVncAuthenticateRsp
TVncAuthenticateRsp.group = {}

local function TVncAuthenticateRsp_from_obj(obj)
    return setmetatable(obj, TVncAuthenticateRsp)
end

function TVncAuthenticateRsp.new(AccountData)
    return TVncAuthenticateRsp_from_obj({AccountData = AccountData})
end
---@param obj LocalAccountAuthN.VncAuthenticateRsp
function TVncAuthenticateRsp:init_from_obj(obj)
    self.AccountData = obj.AccountData
end

function TVncAuthenticateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVncAuthenticateRsp.group)
end

TVncAuthenticateRsp.from_obj = TVncAuthenticateRsp_from_obj

TVncAuthenticateRsp.proto_property = {'AccountData'}

TVncAuthenticateRsp.default = {LocalAccountAuthN.AccountData.default}

TVncAuthenticateRsp.struct = {{name = 'AccountData', is_array = false, struct = LocalAccountAuthN.AccountData.struct}}

function TVncAuthenticateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    LocalAccountAuthN.AccountData.new(self.AccountData):validate(prefix, errs, need_convert)

    TVncAuthenticateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVncAuthenticateRsp.proto_property, errs, need_convert)
    return self
end

function TVncAuthenticateRsp:unpack(_)
    return self.AccountData
end

LocalAccountAuthN.VncAuthenticateRsp = TVncAuthenticateRsp

---@class LocalAccountAuthN.LocalAuthenticateRsp
---@field AccountData LocalAccountAuthN.AccountData
local TLocalAuthenticateRsp = {}
TLocalAuthenticateRsp.__index = TLocalAuthenticateRsp
TLocalAuthenticateRsp.group = {}

local function TLocalAuthenticateRsp_from_obj(obj)
    return setmetatable(obj, TLocalAuthenticateRsp)
end

function TLocalAuthenticateRsp.new(AccountData)
    return TLocalAuthenticateRsp_from_obj({AccountData = AccountData})
end
---@param obj LocalAccountAuthN.LocalAuthenticateRsp
function TLocalAuthenticateRsp:init_from_obj(obj)
    self.AccountData = obj.AccountData
end

function TLocalAuthenticateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLocalAuthenticateRsp.group)
end

TLocalAuthenticateRsp.from_obj = TLocalAuthenticateRsp_from_obj

TLocalAuthenticateRsp.proto_property = {'AccountData'}

TLocalAuthenticateRsp.default = {LocalAccountAuthN.AccountData.default}

TLocalAuthenticateRsp.struct = {{name = 'AccountData', is_array = false, struct = LocalAccountAuthN.AccountData.struct}}

function TLocalAuthenticateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    LocalAccountAuthN.AccountData.new(self.AccountData):validate(prefix, errs, need_convert)

    TLocalAuthenticateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLocalAuthenticateRsp.proto_property, errs, need_convert)
    return self
end

function TLocalAuthenticateRsp:unpack(_)
    return self.AccountData
end

LocalAccountAuthN.LocalAuthenticateRsp = TLocalAuthenticateRsp

---@class LocalAccountAuthN.Config
---@field key string
---@field value boolean
local TConfig = {}
TConfig.__index = TConfig
TConfig.group = {}

local function TConfig_from_obj(obj)
    return setmetatable(obj, TConfig)
end

function TConfig.new(dict)
    return TConfig_from_obj(dict)
end

---@param obj LocalAccountAuthN.Config
function TConfig:init_from_obj(obj)
    self = obj
end

function TConfig:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConfig.group)
end

TConfig.from_obj = TConfig_from_obj

TConfig.proto_property = {}

TConfig.default = {}

TConfig.struct = {}

function TConfig:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'bool', false, errs, need_convert)

    end

    TConfig:remove_error_props(errs, self)
    return self
end

function TConfig:unpack(_)
    return self
end

LocalAccountAuthN.Config = TConfig

---@class LocalAccountAuthN.LocalAuthenticateReq
---@field UserName string
---@field Password integer[]
---@field Config LocalAccountAuthN.Config
local TLocalAuthenticateReq = {}
TLocalAuthenticateReq.__index = TLocalAuthenticateReq
TLocalAuthenticateReq.group = {}

local function TLocalAuthenticateReq_from_obj(obj)
    return setmetatable(obj, TLocalAuthenticateReq)
end

function TLocalAuthenticateReq.new(UserName, Password, Config)
    return TLocalAuthenticateReq_from_obj({UserName = UserName, Password = Password, Config = Config})
end
---@param obj LocalAccountAuthN.LocalAuthenticateReq
function TLocalAuthenticateReq:init_from_obj(obj)
    self.UserName = obj.UserName
    self.Password = obj.Password
    self.Config = obj.Config
end

function TLocalAuthenticateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLocalAuthenticateReq.group)
end

TLocalAuthenticateReq.from_obj = TLocalAuthenticateReq_from_obj

TLocalAuthenticateReq.proto_property = {'UserName', 'Password', 'Config'}

TLocalAuthenticateReq.default = {'', {}, LocalAccountAuthN.Config.default}

TLocalAuthenticateReq.struct = {
    {name = 'UserName', is_array = false, struct = nil}, {name = 'Password', is_array = true, struct = nil},
    {name = 'Config', is_array = false, struct = LocalAccountAuthN.Config.struct}
}

function TLocalAuthenticateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    LocalAccountAuthN.Config.new(self.Config):validate(prefix, errs, need_convert)

    validate.Optional(prefix .. 'UserName', self.UserName, 'string', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Password', self.Password, 'uint8', false, errs, need_convert)

    if self.UserName ~= nil then
        validate.lens(prefix .. 'UserName', self.UserName, 1, 32, errs, need_convert)
    end

    TLocalAuthenticateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLocalAuthenticateReq.proto_property, errs, need_convert)
    return self
end

function TLocalAuthenticateReq:unpack(_)
    return self.UserName, self.Password, self.Config
end

LocalAccountAuthN.LocalAuthenticateReq = TLocalAuthenticateReq

LocalAccountAuthN.interface = mdb.register_interface('bmc.kepler.AccountService.LocalAccountAuthN', {}, {
    LocalAuthenticate = {'a{ss}saya{sb}', 'a{ss}', TLocalAuthenticateReq, TLocalAuthenticateRsp},
    VncAuthenticate = {'a{ss}ss', 'a{ss}', TVncAuthenticateReq, TVncAuthenticateRsp},
    GenRmcp20Code = {'a{ss}ysuuayayayys', 'ayayay', TGenRmcp20CodeReq, TGenRmcp20CodeRsp},
    GenRmcp15Code = {'a{ss}yayyuu', 'ay', TGenRmcp15CodeReq, TGenRmcp15CodeRsp}
}, {})

return LocalAccountAuthN
