-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local ChannelNumberMapping = {}

---@class ChannelNumberMapping.Internal
---@field Internal integer
local TInternal = {}
TInternal.__index = TInternal
TInternal.group = {}

local function TInternal_from_obj(obj)
    return setmetatable(obj, TInternal)
end

function TInternal.new(Internal)
    return TInternal_from_obj({Internal = Internal})
end
---@param obj ChannelNumberMapping.Internal
function TInternal:init_from_obj(obj)
    self.Internal = obj.Internal
end

function TInternal:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInternal.group)
end

TInternal.from_obj = TInternal_from_obj

TInternal.proto_property = {'Internal'}

TInternal.default = {0}

TInternal.struct = {{name = 'Internal', is_array = false, struct = nil}}

function TInternal:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Internal', self.Internal, 'uint8', true, errs, need_convert)

    TInternal:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInternal.proto_property, errs, need_convert)
    return self
end

function TInternal:unpack(_)
    return self.Internal
end

ChannelNumberMapping.Internal = TInternal

---@class ChannelNumberMapping.External
---@field External integer
local TExternal = {}
TExternal.__index = TExternal
TExternal.group = {}

local function TExternal_from_obj(obj)
    return setmetatable(obj, TExternal)
end

function TExternal.new(External)
    return TExternal_from_obj({External = External})
end
---@param obj ChannelNumberMapping.External
function TExternal:init_from_obj(obj)
    self.External = obj.External
end

function TExternal:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExternal.group)
end

TExternal.from_obj = TExternal_from_obj

TExternal.proto_property = {'External'}

TExternal.default = {0}

TExternal.struct = {{name = 'External', is_array = false, struct = nil}}

function TExternal:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'External', self.External, 'uint8', true, errs, need_convert)

    TExternal:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExternal.proto_property, errs, need_convert)
    return self
end

function TExternal:unpack(_)
    return self.External
end

ChannelNumberMapping.External = TExternal

ChannelNumberMapping.interface = mdb.register_interface('bmc.kepler.IpmiService.ChannelNumberMapping', {
    External = {'y', {'EMIT_CHANGE'}, true, nil, false},
    Internal = {'y', {}, true, nil, false}
}, {}, {})

return ChannelNumberMapping
