--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetHistoryPwdCheckCount = {}

---@class AccountIpmiCmds.SetHistoryPwdCheckCountReq
---@field ManufactureId integer
---@field UserId integer
---@field Reserved1 integer
---@field Reserved2 integer
---@field Length integer
---@field Data string
local TSetHistoryPwdCheckCountReq = {}
TSetHistoryPwdCheckCountReq.__index = TSetHistoryPwdCheckCountReq
TSetHistoryPwdCheckCountReq.group = {}

local function TSetHistoryPwdCheckCountReq_from_obj(obj)
    return setmetatable(obj, TSetHistoryPwdCheckCountReq)
end

function TSetHistoryPwdCheckCountReq.new(ManufactureId, UserId, Reserved1, Reserved2, Length, Data)
    return TSetHistoryPwdCheckCountReq_from_obj({
        ManufactureId = ManufactureId,
        UserId = UserId,
        Reserved1 = Reserved1,
        Reserved2 = Reserved2,
        Length = Length,
        Data = Data
    })
end
---@param obj AccountIpmiCmds.SetHistoryPwdCheckCountReq
function TSetHistoryPwdCheckCountReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.UserId = obj.UserId
    self.Reserved1 = obj.Reserved1
    self.Reserved2 = obj.Reserved2
    self.Length = obj.Length
    self.Data = obj.Data
end

function TSetHistoryPwdCheckCountReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetHistoryPwdCheckCountReq.group)
end

TSetHistoryPwdCheckCountReq.from_obj = TSetHistoryPwdCheckCountReq_from_obj

TSetHistoryPwdCheckCountReq.proto_property = {'ManufactureId', 'UserId', 'Reserved1', 'Reserved2', 'Length', 'Data'}

TSetHistoryPwdCheckCountReq.default = {0, 0, 0, 0, 0, ''}

TSetHistoryPwdCheckCountReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'UserId', is_array = false, struct = nil},
    {name = 'Reserved1', is_array = false, struct = nil}, {name = 'Reserved2', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetHistoryPwdCheckCountReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'UserId', self.UserId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved1', self.Reserved1, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved2', self.Reserved2, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetHistoryPwdCheckCountReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetHistoryPwdCheckCountReq.proto_property, errs, need_convert)
    return self
end

function TSetHistoryPwdCheckCountReq:unpack(_)
    return self.ManufactureId, self.UserId, self.Reserved1, self.Reserved2, self.Length, self.Data
end

SetHistoryPwdCheckCount.SetHistoryPwdCheckCountReq = TSetHistoryPwdCheckCountReq

---@class AccountIpmiCmds.SetHistoryPwdCheckCountRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetHistoryPwdCheckCountRsp = {}
TSetHistoryPwdCheckCountRsp.__index = TSetHistoryPwdCheckCountRsp
TSetHistoryPwdCheckCountRsp.group = {}

local function TSetHistoryPwdCheckCountRsp_from_obj(obj)
    return setmetatable(obj, TSetHistoryPwdCheckCountRsp)
end

function TSetHistoryPwdCheckCountRsp.new(CompletionCode, ManufactureId)
    return TSetHistoryPwdCheckCountRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj AccountIpmiCmds.SetHistoryPwdCheckCountRsp
function TSetHistoryPwdCheckCountRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetHistoryPwdCheckCountRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetHistoryPwdCheckCountRsp.group)
end

TSetHistoryPwdCheckCountRsp.from_obj = TSetHistoryPwdCheckCountRsp_from_obj

TSetHistoryPwdCheckCountRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetHistoryPwdCheckCountRsp.default = {0, 0}

TSetHistoryPwdCheckCountRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetHistoryPwdCheckCountRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetHistoryPwdCheckCountRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetHistoryPwdCheckCountRsp.proto_property, errs, need_convert)
    return self
end

function TSetHistoryPwdCheckCountRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetHistoryPwdCheckCount.SetHistoryPwdCheckCountRsp = TSetHistoryPwdCheckCountRsp

return SetHistoryPwdCheckCount
