--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetEmergencyLoginAccount = {}

---@class AccountIpmiCmds.SetEmergencyLoginAccountReq
---@field ManufactureId integer
---@field UserId integer
---@field Reserved1 integer
---@field Reserved2 integer
---@field Length integer
---@field Data string
local TSetEmergencyLoginAccountReq = {}
TSetEmergencyLoginAccountReq.__index = TSetEmergencyLoginAccountReq
TSetEmergencyLoginAccountReq.group = {}

local function TSetEmergencyLoginAccountReq_from_obj(obj)
    return setmetatable(obj, TSetEmergencyLoginAccountReq)
end

function TSetEmergencyLoginAccountReq.new(ManufactureId, UserId, Reserved1, Reserved2, Length, Data)
    return TSetEmergencyLoginAccountReq_from_obj({
        ManufactureId = ManufactureId,
        UserId = UserId,
        Reserved1 = Reserved1,
        Reserved2 = Reserved2,
        Length = Length,
        Data = Data
    })
end
---@param obj AccountIpmiCmds.SetEmergencyLoginAccountReq
function TSetEmergencyLoginAccountReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.UserId = obj.UserId
    self.Reserved1 = obj.Reserved1
    self.Reserved2 = obj.Reserved2
    self.Length = obj.Length
    self.Data = obj.Data
end

function TSetEmergencyLoginAccountReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetEmergencyLoginAccountReq.group)
end

TSetEmergencyLoginAccountReq.from_obj = TSetEmergencyLoginAccountReq_from_obj

TSetEmergencyLoginAccountReq.proto_property = {'ManufactureId', 'UserId', 'Reserved1', 'Reserved2', 'Length', 'Data'}

TSetEmergencyLoginAccountReq.default = {0, 0, 0, 0, 0, ''}

TSetEmergencyLoginAccountReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'UserId', is_array = false, struct = nil},
    {name = 'Reserved1', is_array = false, struct = nil}, {name = 'Reserved2', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetEmergencyLoginAccountReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'UserId', self.UserId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved1', self.Reserved1, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved2', self.Reserved2, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetEmergencyLoginAccountReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetEmergencyLoginAccountReq.proto_property, errs, need_convert)
    return self
end

function TSetEmergencyLoginAccountReq:unpack(_)
    return self.ManufactureId, self.UserId, self.Reserved1, self.Reserved2, self.Length, self.Data
end

SetEmergencyLoginAccount.SetEmergencyLoginAccountReq = TSetEmergencyLoginAccountReq

---@class AccountIpmiCmds.SetEmergencyLoginAccountRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetEmergencyLoginAccountRsp = {}
TSetEmergencyLoginAccountRsp.__index = TSetEmergencyLoginAccountRsp
TSetEmergencyLoginAccountRsp.group = {}

local function TSetEmergencyLoginAccountRsp_from_obj(obj)
    return setmetatable(obj, TSetEmergencyLoginAccountRsp)
end

function TSetEmergencyLoginAccountRsp.new(CompletionCode, ManufactureId)
    return TSetEmergencyLoginAccountRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj AccountIpmiCmds.SetEmergencyLoginAccountRsp
function TSetEmergencyLoginAccountRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetEmergencyLoginAccountRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetEmergencyLoginAccountRsp.group)
end

TSetEmergencyLoginAccountRsp.from_obj = TSetEmergencyLoginAccountRsp_from_obj

TSetEmergencyLoginAccountRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetEmergencyLoginAccountRsp.default = {0, 0}

TSetEmergencyLoginAccountRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetEmergencyLoginAccountRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetEmergencyLoginAccountRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetEmergencyLoginAccountRsp.proto_property, errs, need_convert)
    return self
end

function TSetEmergencyLoginAccountRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetEmergencyLoginAccount.SetEmergencyLoginAccountRsp = TSetEmergencyLoginAccountRsp

return SetEmergencyLoginAccount
