--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSNMPConfiguration = {}

---@class AccountIpmiCmds.GetSNMPConfigurationReq
---@field ManufactureId integer
---@field SNMPParameter integer
---@field BlockSelector integer
---@field SubBlockSelector integer
local TGetSNMPConfigurationReq = {}
TGetSNMPConfigurationReq.__index = TGetSNMPConfigurationReq
TGetSNMPConfigurationReq.group = {}

local function TGetSNMPConfigurationReq_from_obj(obj)
    return setmetatable(obj, TGetSNMPConfigurationReq)
end

function TGetSNMPConfigurationReq.new(ManufactureId, SNMPParameter, BlockSelector, SubBlockSelector)
    return TGetSNMPConfigurationReq_from_obj({
        ManufactureId = ManufactureId,
        SNMPParameter = SNMPParameter,
        BlockSelector = BlockSelector,
        SubBlockSelector = SubBlockSelector
    })
end
---@param obj AccountIpmiCmds.GetSNMPConfigurationReq
function TGetSNMPConfigurationReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.SNMPParameter = obj.SNMPParameter
    self.BlockSelector = obj.BlockSelector
    self.SubBlockSelector = obj.SubBlockSelector
end

function TGetSNMPConfigurationReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSNMPConfigurationReq.group)
end

TGetSNMPConfigurationReq.from_obj = TGetSNMPConfigurationReq_from_obj

TGetSNMPConfigurationReq.proto_property = {'ManufactureId', 'SNMPParameter', 'BlockSelector', 'SubBlockSelector'}

TGetSNMPConfigurationReq.default = {0, 0, 0, 0}

TGetSNMPConfigurationReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'SNMPParameter', is_array = false, struct = nil},
    {name = 'BlockSelector', is_array = false, struct = nil},
    {name = 'SubBlockSelector', is_array = false, struct = nil}
}

function TGetSNMPConfigurationReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'SNMPParameter', self.SNMPParameter, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BlockSelector', self.BlockSelector, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SubBlockSelector', self.SubBlockSelector, 'uint8', false, errs, need_convert)

    TGetSNMPConfigurationReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSNMPConfigurationReq.proto_property, errs, need_convert)
    return self
end

function TGetSNMPConfigurationReq:unpack(_)
    return self.ManufactureId, self.SNMPParameter, self.BlockSelector, self.SubBlockSelector
end

GetSNMPConfiguration.GetSNMPConfigurationReq = TGetSNMPConfigurationReq

---@class AccountIpmiCmds.GetSNMPConfigurationRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Length integer
---@field Data string
local TGetSNMPConfigurationRsp = {}
TGetSNMPConfigurationRsp.__index = TGetSNMPConfigurationRsp
TGetSNMPConfigurationRsp.group = {}

local function TGetSNMPConfigurationRsp_from_obj(obj)
    return setmetatable(obj, TGetSNMPConfigurationRsp)
end

function TGetSNMPConfigurationRsp.new(CompletionCode, ManufactureId, Length, Data)
    return TGetSNMPConfigurationRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Length = Length,
        Data = Data
    })
end
---@param obj AccountIpmiCmds.GetSNMPConfigurationRsp
function TGetSNMPConfigurationRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Length = obj.Length
    self.Data = obj.Data
end

function TGetSNMPConfigurationRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSNMPConfigurationRsp.group)
end

TGetSNMPConfigurationRsp.from_obj = TGetSNMPConfigurationRsp_from_obj

TGetSNMPConfigurationRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Length', 'Data'}

TGetSNMPConfigurationRsp.default = {0, 0, 0, ''}

TGetSNMPConfigurationRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetSNMPConfigurationRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetSNMPConfigurationRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSNMPConfigurationRsp.proto_property, errs, need_convert)
    return self
end

function TGetSNMPConfigurationRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Length, self.Data
end

GetSNMPConfiguration.GetSNMPConfigurationRsp = TGetSNMPConfigurationRsp

return GetSNMPConfiguration
