#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2024. All rights reserved.
from dataclasses import dataclass
from typing import List, Optional
from abc import ABC, abstractmethod


@dataclass
class GrammarRule(ABC):
    rule_id: str
    name: str
    category: str
    alarm_level: str
    main_error_template: str
    error_list_template: List[str]
    repair_sug_template: List[str]
    require_repo: List[str]
    need_manifest: bool
    south_rebuild_branch: Optional[bool]
    ci_enabled: bool

    def __init__(self, rule_id: str, config: dict):
        self.rule_id = rule_id
        self.name = config.get("name", "")
        self.category = config.get("category", "")
        self.alarm_level = config.get("alarmLevel", "严重")
        self.main_error_template = config.get("mainErrorTemplate", "")
        self.error_list_template = config.get("errorListTemplate", [])
        self.repair_sug_template = config.get("repairSugTemplate", [])
        self.require_repo = config.get("requireRepo", [])
        self.need_manifest = config.get("needManifest", False)
        self.ci_enabled = config.get("ciEnabled", False)
        self.south_rebuild_branch = config.get("southRebuildBranch", None)
    
    @abstractmethod
    def validate(self, model: str, value: dict, file_path: str, data: dict):
        # 规则检查逻辑，由子类实现
        pass

    def skip_check(self):
        return False