//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { traduction } from '@/utils/language';
import { DOMAIN_NAME, IPV4, IPV6 } from '@/utils/regular';

export class DomainValidators {
  public static ipv46AndDomin = (trigger?: string, errorMsg?: string) => {
    const _trigger = trigger || 'change';
    return {
      type: 'string',
      trigger: _trigger,
      message: errorMsg ? errorMsg : traduction('COMMON_FORMAT_ERROR'),
      validator: (rule: any, value: any, callback: (error?: Error) => void) => {
        if (value === '') {
          callback();
          return;
        }
        let result = false;
        if (/^[0-9.]+$/.test(value)) {
          result = IPV4.test(value);
        } else if (value.indexOf(':') > -1) {
          result = IPV6.test(value);
        } else {
          result = DOMAIN_NAME.test(value);
        }
        !result ? callback(new Error()) : callback();
      },
    };
  };

  public static ipv46 = () => {
    return {
      type: 'string',
      trigger: 'change',
      message: traduction('COMMON_FORMAT_ERROR'),
      validator: (rule: any, value: any, callback: (error?: Error) => void) => {
        if (value === '') {
          callback();
          return;
        }
        let result = false;
        if (/^[0-9.]+$/.test(value)) {
          result = IPV4.test(value);
        } else if (value.indexOf(':') > -1) {
          result = IPV6.test(value);
        }
        !result ? callback(new Error()) : callback();
      },
    };
  };

  public static ipv6 = () => {
    return {
      type: 'string',
      trigger: 'change',
      message: traduction('COMMON_FORMAT_ERROR'),
      validator: (rule: any, value: any, callback: (error?: Error) => void) => {
        if (value === '') {
          callback();
          return;
        }
        let result = false;
        if (value.indexOf(':') > -1) {
          result = IPV6.test(value);
        }
        !result ? callback(new Error()) : callback();
      },
    };
  };

  public static domin = (trigger?: string, errorMsg?: string): any => {
    const _trigger = trigger ?? 'change';
    return {
      type: 'string',
      trigger: _trigger,
      message: errorMsg ? errorMsg : traduction('COMMON_FORMAT_ERROR'),
      validator: (rule: any, value: any, callback: (error?: Error) => void): any => {
        if (value === '') {
          callback();
          return;
        }
        let result = false;
        if (/[0-9.]+$/.test(value)) {
          result = false;
        } else if (value.indexOf(':') > -1) {
          result = false;
        } else {
          result = DOMAIN_NAME.test(value);
        }
        !result ? callback(new Error()) : callback();
      },
    };
  };
}
