//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
declare const Date:any;

function getRegReplaceArr1(_this: any) {
  return [
    {
      reg: /y+/,
      replaceFn(str:any) {
        return String(_this.getFullYear()).substr(-1 * str.length);
      },
    },
    {
      reg: /M+/,
      replaceStr: _this.getMonth() + 1,
    },
    {
      reg: /d+/,
      replaceStr: _this.getDate(),
    },
    {
      reg: /E+/,
      replaceFn(str:any) {
        const weekDay = ['/u65e5', '/u4e00', '/u4e8c', '/u4e09', '/u56db', '/u4e94', '/u516d'];
        const day = weekDay[_this.getDay()];
        if (str.length > 2) {
          return `/u661f/u671f${day}`;
        }
        if (str.length === 2) {
          return `/u5468${day}`;
        }
        return day;
      },
    },
  ];
}

function getRegReplaceArr2(_this: any) {
  return [
    {
      reg: /H+/,
      replaceStr: _this.getHours(),
    },
    {
      reg: /h+/,
      replaceStr: _this.getHours() % 12 === 0 ? 12 : _this.getHours() % 12,
    },
    {
      reg: /m+/,
      replaceStr: _this.getMinutes(),
    },
    {
      reg: /s+/,
      replaceStr: _this.getSeconds(),
    },
    {
      reg: /q+/,
      replaceStr: Math.floor(_this.getMonth() / 3 + 1),
    },
    {
      reg: /S/,
      replaceStr: _this.getMilliseconds(),
    },
  ];
}

Date.prototype.pattern = function (format: any): any {
  const _this = this;
  const regReplaceArr: any = [...getRegReplaceArr1(_this), ...getRegReplaceArr2(_this)];
  let formatedStr = format;
  regReplaceArr.forEach((item: any) => {
    formatedStr = formatedStr.replace(item.reg, (matchedStr:any) => {
      if (item.replaceFn) {
        return item.replaceFn(matchedStr);
      }
      const replaceStr = String(item.replaceStr);
      if (matchedStr.length > 1 && parseInt(replaceStr, 10) < 10) {
        return `0${replaceStr}`;
      }
      return replaceStr;
    });
  });
  return formatedStr;
};

Date.prototype.format = function (format: any): any {
  const o = {
    'M+': this.getUTCMonth() + 1,
    'd+': this.getUTCDate(),
    'h+': this.getUTCHours(),
    'm+': this.getUTCMinutes(),
    's+': this.getUTCSeconds(),
    'q+': Math.floor((this.getUTCMonth() + 3) / 3),
    S: this.getUTCMilliseconds(),
  };
  let tempFormat = '';
  if (/(y+)/.test(format)) {
    tempFormat = format.replace(RegExp.$1, String(this.getUTCFullYear()).substr(4 - RegExp.$1.length));
  } else {
    tempFormat = format;
  }
  for (const k in o) {
    if (new RegExp(`(${k})`).test(format)) {
      tempFormat = tempFormat.replace(
        RegExp.$1,
        RegExp.$1.length === 1 ? o[k] : (`00${o[k]}`).substr(String(o[k]).length),
      );
    }
  }
  return tempFormat;
};
export default Date;
