//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export class StatusBar {
  public _sendBytes = 0;
  public _reciveBytes = 0;
  public _frameRate = 0;
  public _owner;
  public _title;
  constructor(owner: any, title: string) {
    this._owner = owner;
    this._title = title;
    (document.getElementById('status_title') as HTMLElement).innerText = this._title;
    setInterval(() => {
      this._ResetStatus();
    }, 1000);
  }

  _ResetStatus() {
    (document.getElementById('send_bytes') as HTMLElement).innerText = String(this._sendBytes);
    (document.getElementById('recive_bytes') as HTMLElement).innerText = String(this._reciveBytes);
    (document.getElementById('frame_rate') as HTMLElement).innerText = String(this._frameRate);
    this._sendBytes = 0;
    this._reciveBytes = 0;
    this._frameRate = 0;
  }

  updateSend(sendBytes: any) {
    if (typeof sendBytes === 'number') {
      this._sendBytes += sendBytes;
    }
  }

  updateRecive(reciveBytes: any) {
    if (typeof reciveBytes === 'number') {
      this._reciveBytes += reciveBytes;
    }
  }

  updateFrame(frameRate: any) {
    this._frameRate += frameRate;
  }
}
